/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding.xml;

import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.messaging.saaj.soap.AttachmentPartImpl;
import com.sun.xml.internal.messaging.saaj.util.ByteOutputStream;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.message.Attachment;
import com.sun.xml.internal.ws.api.message.AttachmentSet;
import com.sun.xml.internal.ws.api.message.HeaderList;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Messages;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.api.pipe.ContentType;
import com.sun.xml.internal.ws.api.streaming.XMLStreamReaderFactory;
import com.sun.xml.internal.ws.api.streaming.XMLStreamWriterFactory;
import com.sun.xml.internal.ws.encoding.MimeMultipartParser;
import com.sun.xml.internal.ws.encoding.XMLHTTPBindingCodec;
import com.sun.xml.internal.ws.message.AbstractMessageImpl;
import com.sun.xml.internal.ws.message.EmptyMessageImpl;
import com.sun.xml.internal.ws.util.xml.XMLStreamReaderToXMLStreamWriter;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.activation.DataSource;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.WebServiceException;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public final class XMLMessage {
    private static final int PLAIN_XML_FLAG = 1;
    private static final int MIME_MULTIPART_FLAG = 2;
    private static final int FI_ENCODED_FLAG = 16;

    private static InputStream hasSomeData(InputStream in) throws IOException {
        if (in != null && in.available() < 1) {
            if (!in.markSupported()) {
                in = new BufferedInputStream(in);
            }
            in.mark(1);
            if (in.read() != -1) {
                in.reset();
            } else {
                in = null;
            }
        }
        return in;
    }

    public static Message create(String ct, InputStream in) {
        Message data;
        try {
            com.sun.xml.internal.messaging.saaj.packaging.mime.internet.ContentType contentType;
            int contentTypeId;
            in = XMLMessage.hasSomeData(in);
            if (in == null) {
                Message data2 = Messages.createEmpty(SOAPVersion.SOAP_11);
                return data2;
            }
            data = ct != null ? (((contentTypeId = XMLMessage.identifyContentType(contentType = new com.sun.xml.internal.messaging.saaj.packaging.mime.internet.ContentType(ct))) & 2) != 0 ? new XMLMultiPart(ct, in) : ((contentTypeId & 1) != 0 ? Messages.createUsingPayload(new StreamSource(in), SOAPVersion.SOAP_11) : new UnknownContent(ct, in))) : Messages.createEmpty(SOAPVersion.SOAP_11);
        }
        catch (Exception ex) {
            throw new WebServiceException(ex);
        }
        return data;
    }

    public static Message create(Source source) {
        return source == null ? Messages.createEmpty(SOAPVersion.SOAP_11) : Messages.createUsingPayload(source, SOAPVersion.SOAP_11);
    }

    public static Message create(DataSource ds) {
        try {
            return ds == null ? Messages.createEmpty(SOAPVersion.SOAP_11) : XMLMessage.create(ds.getContentType(), ds.getInputStream());
        }
        catch (IOException ioe) {
            throw new WebServiceException(ioe);
        }
    }

    public static Message create(Exception e) {
        return new FaultMessage(SOAPVersion.SOAP_11);
    }

    private static int getContentId(String ct) {
        try {
            com.sun.xml.internal.messaging.saaj.packaging.mime.internet.ContentType contentType = new com.sun.xml.internal.messaging.saaj.packaging.mime.internet.ContentType(ct);
            return XMLMessage.identifyContentType(contentType);
        }
        catch (Exception ex) {
            throw new WebServiceException(ex);
        }
    }

    public static boolean isFastInfoset(String ct) {
        return (XMLMessage.getContentId(ct) & 0x10) != 0;
    }

    public static int identifyContentType(com.sun.xml.internal.messaging.saaj.packaging.mime.internet.ContentType contentType) {
        String primary = contentType.getPrimaryType();
        String sub = contentType.getSubType();
        if (primary.equalsIgnoreCase("multipart") && sub.equalsIgnoreCase("related")) {
            String type = contentType.getParameter("type");
            if (type != null) {
                if (XMLMessage.isXMLType(type)) {
                    return 3;
                }
                if (XMLMessage.isFastInfosetType(type)) {
                    return 18;
                }
            }
            return 0;
        }
        if (XMLMessage.isXMLType(primary, sub)) {
            return 1;
        }
        if (XMLMessage.isFastInfosetType(primary, sub)) {
            return 16;
        }
        return 0;
    }

    protected static boolean isXMLType(@NotNull String primary, @NotNull String sub) {
        return primary.equalsIgnoreCase("text") && sub.equalsIgnoreCase("xml") || primary.equalsIgnoreCase("application") && sub.equalsIgnoreCase("xml") || primary.equalsIgnoreCase("application") && sub.toLowerCase().endsWith("+xml");
    }

    protected static boolean isXMLType(String type) {
        String lowerType = type.toLowerCase();
        return lowerType.startsWith("text/xml") || lowerType.startsWith("application/xml") || lowerType.startsWith("application/") && lowerType.indexOf("+xml") != -1;
    }

    protected static boolean isFastInfosetType(String primary, String sub) {
        return primary.equalsIgnoreCase("application") && sub.equalsIgnoreCase("fastinfoset");
    }

    protected static boolean isFastInfosetType(String type) {
        return type.toLowerCase().startsWith("application/fastinfoset");
    }

    public static DataSource getDataSource(Message msg) {
        if (msg instanceof MessageDataSource) {
            return ((MessageDataSource)((Object)msg)).getDataSource();
        }
        AttachmentSet atts = msg.getAttachments();
        if (atts != null && !atts.isEmpty()) {
            ByteOutputStream bos = new ByteOutputStream();
            try {
                XMLHTTPBindingCodec codec = new XMLHTTPBindingCodec();
                ContentType ct = codec.getStaticContentType(new Packet(msg));
                codec.encode(new Packet(msg), (OutputStream)bos);
                return XMLMessage.createDataSource(ct.getContentType(), bos.newInputStream());
            }
            catch (IOException ioe) {
                throw new WebServiceException(ioe);
            }
        }
        ByteOutputStream bos = new ByteOutputStream();
        XMLStreamWriter writer = XMLStreamWriterFactory.create(bos);
        try {
            msg.writePayloadTo(writer);
            writer.flush();
        }
        catch (XMLStreamException e) {
            throw new WebServiceException(e);
        }
        return XMLMessage.createDataSource("text/xml", bos.newInputStream());
    }

    public static DataSource createDataSource(final String contentType, final InputStream is) {
        return new DataSource(){

            public InputStream getInputStream() {
                return is;
            }

            public OutputStream getOutputStream() {
                return null;
            }

            public String getContentType() {
                return contentType;
            }

            public String getName() {
                return "";
            }
        };
    }

    static {
        new AttachmentPartImpl();
    }

    public static class UnknownContent
    extends AbstractMessageImpl
    implements MessageDataSource {
        private final DataSource ds;
        private final HeaderList headerList;

        public UnknownContent(String ct, InputStream in) {
            this(XMLMessage.createDataSource(ct, in));
        }

        public UnknownContent(DataSource ds) {
            super(SOAPVersion.SOAP_11);
            this.ds = ds;
            this.headerList = new HeaderList();
        }

        private UnknownContent(UnknownContent that) {
            super(that.soapVersion);
            this.ds = that.ds;
            this.headerList = HeaderList.copy(that.headerList);
        }

        public boolean hasUnconsumedDataSource() {
            return true;
        }

        public DataSource getDataSource() {
            assert (this.ds != null);
            return this.ds;
        }

        protected void writePayloadTo(ContentHandler contentHandler, ErrorHandler errorHandler, boolean fragment) throws SAXException {
            throw new UnsupportedOperationException();
        }

        public boolean hasHeaders() {
            return false;
        }

        public boolean isFault() {
            return false;
        }

        public HeaderList getHeaders() {
            return this.headerList;
        }

        public String getPayloadLocalPart() {
            throw new UnsupportedOperationException();
        }

        public String getPayloadNamespaceURI() {
            throw new UnsupportedOperationException();
        }

        public boolean hasPayload() {
            return false;
        }

        public Source readPayloadAsSource() {
            return null;
        }

        public XMLStreamReader readPayload() throws XMLStreamException {
            throw new WebServiceException("There isn't XML payload. Shouldn't come here.");
        }

        public void writePayloadTo(XMLStreamWriter sw) throws XMLStreamException {
        }

        public Message copy() {
            return new UnknownContent(this);
        }
    }

    private static class FaultMessage
    extends EmptyMessageImpl {
        public FaultMessage(SOAPVersion version) {
            super(version);
        }

        public boolean isFault() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class XMLAttachmentSet
    implements AttachmentSet {
        private final Map<String, Attachment> attMap = new HashMap<String, Attachment>();

        public XMLAttachmentSet(MimeMultipartParser mpp) {
            this.attMap.putAll(mpp.getAttachmentParts());
        }

        @Override
        public Attachment get(String contentId) {
            return this.attMap.get(contentId);
        }

        @Override
        public boolean isEmpty() {
            return this.attMap.isEmpty();
        }

        @Override
        public Iterator<Attachment> iterator() {
            return this.attMap.values().iterator();
        }

        @Override
        public void add(Attachment att) {
            this.attMap.put(att.getContentId(), att);
        }
    }

    public static final class XMLMultiPart
    extends AbstractMessageImpl
    implements MessageDataSource {
        private final DataSource dataSource;
        private MimeMultipartParser mpp;

        public XMLMultiPart(String contentType, InputStream is) {
            super(SOAPVersion.SOAP_11);
            this.dataSource = XMLMessage.createDataSource(contentType, is);
        }

        public XMLMultiPart(DataSource dataSource) {
            super(SOAPVersion.SOAP_11);
            this.dataSource = dataSource;
        }

        public DataSource getDataSource() {
            assert (this.dataSource != null);
            return this.dataSource;
        }

        private void convertDataSourceToMessage() {
            if (this.mpp == null) {
                try {
                    this.mpp = new MimeMultipartParser(this.dataSource.getInputStream(), this.dataSource.getContentType());
                }
                catch (IOException ioe) {
                    throw new WebServiceException(ioe);
                }
            }
        }

        public boolean isOneWay(@NotNull WSDLPort port) {
            return false;
        }

        public boolean isFault() {
            return false;
        }

        public boolean hasHeaders() {
            return false;
        }

        public HeaderList getHeaders() {
            return new HeaderList();
        }

        public AttachmentSet getAttachments() {
            this.convertDataSourceToMessage();
            return new XMLAttachmentSet(this.mpp);
        }

        public String getPayloadLocalPart() {
            throw new UnsupportedOperationException();
        }

        public String getPayloadNamespaceURI() {
            throw new UnsupportedOperationException();
        }

        public boolean hasPayload() {
            return true;
        }

        public Source readPayloadAsSource() {
            this.convertDataSourceToMessage();
            return this.mpp.getRootPart().asSource();
        }

        public XMLStreamReader readPayload() throws XMLStreamException {
            this.convertDataSourceToMessage();
            return XMLStreamReaderFactory.create(null, this.mpp.getRootPart().asInputStream(), true);
        }

        public void writePayloadTo(XMLStreamWriter sw) {
            XMLStreamReaderToXMLStreamWriter c = new XMLStreamReaderToXMLStreamWriter();
            try {
                XMLStreamReader r = this.readPayload();
                c.bridge(r, sw);
                XMLStreamReaderFactory.recycle(r);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        protected void writePayloadTo(ContentHandler contentHandler, ErrorHandler errorHandler, boolean fragment) {
            throw new UnsupportedOperationException();
        }

        public Message copy() {
            throw new UnsupportedOperationException();
        }

        public boolean hasUnconsumedDataSource() {
            return this.mpp == null;
        }
    }

    public static interface MessageDataSource {
        public boolean hasUnconsumedDataSource();

        public DataSource getDataSource();
    }
}

