/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.rmi.registry;

import com.sun.jndi.rmi.registry.RegistryContext;
import com.sun.jndi.url.rmi.rmiURLContextFactory;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryContextFactory
implements ObjectFactory,
InitialContextFactory {
    public static final String ADDRESS_TYPE = "URL";

    @Override
    public Context getInitialContext(Hashtable<?, ?> env) throws NamingException {
        if (env != null) {
            env = (Hashtable)env.clone();
        }
        return RegistryContextFactory.URLToContext(RegistryContextFactory.getInitCtxURL(env), env);
    }

    @Override
    public Object getObjectInstance(Object ref, Name name, Context nameCtx, Hashtable<?, ?> env) throws NamingException {
        if (!RegistryContextFactory.isRegistryRef(ref)) {
            return null;
        }
        Object obj = RegistryContextFactory.URLsToObject(RegistryContextFactory.getURLs((Reference)ref), env);
        if (obj instanceof RegistryContext) {
            RegistryContext ctx = (RegistryContext)obj;
            ctx.reference = (Reference)ref;
        }
        return obj;
    }

    private static Context URLToContext(String url, Hashtable env) throws NamingException {
        rmiURLContextFactory factory = new rmiURLContextFactory();
        Object obj = factory.getObjectInstance(url, null, null, env);
        if (obj instanceof Context) {
            return (Context)obj;
        }
        throw new NotContextException(url);
    }

    private static Object URLsToObject(String[] urls, Hashtable env) throws NamingException {
        rmiURLContextFactory factory = new rmiURLContextFactory();
        return factory.getObjectInstance(urls, null, null, env);
    }

    private static String getInitCtxURL(Hashtable env) {
        String defaultURL = "rmi:";
        String url = null;
        if (env != null) {
            url = (String)env.get("java.naming.provider.url");
        }
        return url != null ? url : "rmi:";
    }

    private static boolean isRegistryRef(Object obj) {
        if (!(obj instanceof Reference)) {
            return false;
        }
        String thisClassName = RegistryContextFactory.class.getName();
        Reference ref = (Reference)obj;
        return thisClassName.equals(ref.getFactoryClassName());
    }

    private static String[] getURLs(Reference ref) throws NamingException {
        int size = 0;
        String[] urls = new String[ref.size()];
        Enumeration<RefAddr> addrs = ref.getAll();
        while (addrs.hasMoreElements()) {
            RefAddr addr = addrs.nextElement();
            if (!(addr instanceof StringRefAddr) || !addr.getType().equals(ADDRESS_TYPE)) continue;
            urls[size++] = (String)addr.getContent();
        }
        if (size == 0) {
            throw new ConfigurationException("Reference contains no valid addresses");
        }
        if (size == ref.size()) {
            return urls;
        }
        String[] urls2 = new String[size];
        System.arraycopy(urls, 0, urls2, 0, size);
        return urls2;
    }
}

