/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.daemon;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.snmp.IPAcl.SnmpAcl;
import com.sun.jmx.snmp.InetAddressAcl;
import com.sun.jmx.snmp.SnmpDefinitions;
import com.sun.jmx.snmp.SnmpIpAddress;
import com.sun.jmx.snmp.SnmpMessage;
import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpParameters;
import com.sun.jmx.snmp.SnmpPduFactory;
import com.sun.jmx.snmp.SnmpPduFactoryBER;
import com.sun.jmx.snmp.SnmpPduPacket;
import com.sun.jmx.snmp.SnmpPduRequest;
import com.sun.jmx.snmp.SnmpPduTrap;
import com.sun.jmx.snmp.SnmpPeer;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpTimeticks;
import com.sun.jmx.snmp.SnmpTooBigException;
import com.sun.jmx.snmp.SnmpVarBind;
import com.sun.jmx.snmp.SnmpVarBindList;
import com.sun.jmx.snmp.agent.SnmpErrorHandlerAgent;
import com.sun.jmx.snmp.agent.SnmpMibAgent;
import com.sun.jmx.snmp.agent.SnmpMibHandler;
import com.sun.jmx.snmp.agent.SnmpUserDataFactory;
import com.sun.jmx.snmp.daemon.CommunicationException;
import com.sun.jmx.snmp.daemon.CommunicatorServer;
import com.sun.jmx.snmp.daemon.SnmpAdaptorServerMBean;
import com.sun.jmx.snmp.daemon.SnmpInformHandler;
import com.sun.jmx.snmp.daemon.SnmpInformRequest;
import com.sun.jmx.snmp.daemon.SnmpMibTree;
import com.sun.jmx.snmp.daemon.SnmpRequestHandler;
import com.sun.jmx.snmp.daemon.SnmpSession;
import com.sun.jmx.snmp.daemon.SnmpSubRequestHandler;
import com.sun.jmx.snmp.tasks.ThreadService;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class SnmpAdaptorServer
extends CommunicatorServer
implements SnmpAdaptorServerMBean,
MBeanRegistration,
SnmpDefinitions,
SnmpMibHandler {
    private int trapPort = 162;
    private int informPort = 162;
    InetAddress address = null;
    private Object ipacl = null;
    private SnmpPduFactory pduFactory = null;
    private SnmpUserDataFactory userDataFactory = null;
    private boolean authRespEnabled = true;
    private boolean authTrapEnabled = true;
    private SnmpOid enterpriseOid = new SnmpOid("1.3.6.1.4.1.42");
    int bufferSize = 1024;
    private transient long startUpTime = 0L;
    private transient DatagramSocket socket = null;
    transient DatagramSocket trapSocket = null;
    private transient SnmpSession informSession = null;
    private transient DatagramPacket packet = null;
    transient Vector<SnmpMibAgent> mibs = new Vector();
    private transient SnmpMibTree root;
    private transient boolean useAcl = true;
    private int maxTries = 3;
    private int timeout = 3000;
    int snmpOutTraps = 0;
    private int snmpOutGetResponses = 0;
    private int snmpOutGenErrs = 0;
    private int snmpOutBadValues = 0;
    private int snmpOutNoSuchNames = 0;
    private int snmpOutTooBigs = 0;
    int snmpOutPkts = 0;
    private int snmpInASNParseErrs = 0;
    private int snmpInBadCommunityUses = 0;
    private int snmpInBadCommunityNames = 0;
    private int snmpInBadVersions = 0;
    private int snmpInGetRequests = 0;
    private int snmpInGetNexts = 0;
    private int snmpInSetRequests = 0;
    private int snmpInPkts = 0;
    private int snmpInTotalReqVars = 0;
    private int snmpInTotalSetVars = 0;
    private int snmpSilentDrops = 0;
    private static final String InterruptSysCallMsg = "Interrupted system call";
    static final SnmpOid sysUpTimeOid = new SnmpOid("1.3.6.1.2.1.1.3.0");
    static final SnmpOid snmpTrapOidOid = new SnmpOid("1.3.6.1.6.3.1.1.4.1.0");
    private ThreadService threadService;
    private static int threadNumber = 6;

    public SnmpAdaptorServer() {
        this(true, null, 161, null);
    }

    public SnmpAdaptorServer(int port) {
        this(true, null, port, null);
    }

    public SnmpAdaptorServer(InetAddressAcl acl) {
        this(false, acl, 161, null);
    }

    public SnmpAdaptorServer(InetAddress addr) {
        this(true, null, 161, addr);
    }

    public SnmpAdaptorServer(InetAddressAcl acl, int port) {
        this(false, acl, port, null);
    }

    public SnmpAdaptorServer(int port, InetAddress addr) {
        this(true, null, port, addr);
    }

    public SnmpAdaptorServer(InetAddressAcl acl, InetAddress addr) {
        this(false, acl, 161, addr);
    }

    public SnmpAdaptorServer(InetAddressAcl acl, int port, InetAddress addr) {
        this(false, acl, port, addr);
    }

    public SnmpAdaptorServer(boolean useAcl, int port, InetAddress addr) {
        this(useAcl, null, port, addr);
    }

    private SnmpAdaptorServer(boolean forceAcl, InetAddressAcl acl, int port, InetAddress addr) {
        super(4);
        if (acl == null && forceAcl) {
            try {
                acl = new SnmpAcl("SNMP protocol adaptor IP ACL");
            }
            catch (UnknownHostException e) {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "constructor", "UnknowHostException when creating ACL", e);
                }
            }
        } else {
            this.useAcl = acl != null || forceAcl;
        }
        this.init(acl, port, addr);
    }

    public int getServedClientCount() {
        return super.getServedClientCount();
    }

    public int getActiveClientCount() {
        return super.getActiveClientCount();
    }

    public int getMaxActiveClientCount() {
        return super.getMaxActiveClientCount();
    }

    public void setMaxActiveClientCount(int c) throws IllegalStateException {
        super.setMaxActiveClientCount(c);
    }

    public InetAddressAcl getInetAddressAcl() {
        return (InetAddressAcl)this.ipacl;
    }

    public Integer getTrapPort() {
        return new Integer(this.trapPort);
    }

    public void setTrapPort(Integer port) {
        this.setTrapPort((int)port);
    }

    public void setTrapPort(int port) {
        int val = port;
        if (val < 0) {
            throw new IllegalArgumentException("Trap port cannot be a negative value");
        }
        this.trapPort = val;
    }

    public int getInformPort() {
        return this.informPort;
    }

    public void setInformPort(int port) {
        if (port < 0) {
            throw new IllegalArgumentException("Inform request port cannot be a negative value");
        }
        this.informPort = port;
    }

    public String getProtocol() {
        return "snmp";
    }

    public Integer getBufferSize() {
        return new Integer(this.bufferSize);
    }

    public void setBufferSize(Integer s) throws IllegalStateException {
        if (this.state == 0 || this.state == 3) {
            throw new IllegalStateException("Stop server before carrying out this operation");
        }
        this.bufferSize = s;
    }

    public final int getMaxTries() {
        return this.maxTries;
    }

    public final synchronized void setMaxTries(int newMaxTries) {
        if (newMaxTries < 0) {
            throw new IllegalArgumentException();
        }
        this.maxTries = newMaxTries;
    }

    public final int getTimeout() {
        return this.timeout;
    }

    public final synchronized void setTimeout(int newTimeout) {
        if (newTimeout < 0) {
            throw new IllegalArgumentException();
        }
        this.timeout = newTimeout;
    }

    public SnmpPduFactory getPduFactory() {
        return this.pduFactory;
    }

    public void setPduFactory(SnmpPduFactory factory) {
        this.pduFactory = factory == null ? new SnmpPduFactoryBER() : factory;
    }

    public void setUserDataFactory(SnmpUserDataFactory factory) {
        this.userDataFactory = factory;
    }

    public SnmpUserDataFactory getUserDataFactory() {
        return this.userDataFactory;
    }

    public boolean getAuthTrapEnabled() {
        return this.authTrapEnabled;
    }

    public void setAuthTrapEnabled(boolean enabled) {
        this.authTrapEnabled = enabled;
    }

    public boolean getAuthRespEnabled() {
        return this.authRespEnabled;
    }

    public void setAuthRespEnabled(boolean enabled) {
        this.authRespEnabled = enabled;
    }

    public String getEnterpriseOid() {
        return this.enterpriseOid.toString();
    }

    public void setEnterpriseOid(String oid) throws IllegalArgumentException {
        this.enterpriseOid = new SnmpOid(oid);
    }

    public String[] getMibs() {
        String[] result = new String[this.mibs.size()];
        int i = 0;
        Enumeration<SnmpMibAgent> e = this.mibs.elements();
        while (e.hasMoreElements()) {
            SnmpMibAgent mib = e.nextElement();
            result[i++] = mib.getMibName();
        }
        return result;
    }

    public Long getSnmpOutTraps() {
        return new Long(this.snmpOutTraps);
    }

    public Long getSnmpOutGetResponses() {
        return new Long(this.snmpOutGetResponses);
    }

    public Long getSnmpOutGenErrs() {
        return new Long(this.snmpOutGenErrs);
    }

    public Long getSnmpOutBadValues() {
        return new Long(this.snmpOutBadValues);
    }

    public Long getSnmpOutNoSuchNames() {
        return new Long(this.snmpOutNoSuchNames);
    }

    public Long getSnmpOutTooBigs() {
        return new Long(this.snmpOutTooBigs);
    }

    public Long getSnmpInASNParseErrs() {
        return new Long(this.snmpInASNParseErrs);
    }

    public Long getSnmpInBadCommunityUses() {
        return new Long(this.snmpInBadCommunityUses);
    }

    public Long getSnmpInBadCommunityNames() {
        return new Long(this.snmpInBadCommunityNames);
    }

    public Long getSnmpInBadVersions() {
        return new Long(this.snmpInBadVersions);
    }

    public Long getSnmpOutPkts() {
        return new Long(this.snmpOutPkts);
    }

    public Long getSnmpInPkts() {
        return new Long(this.snmpInPkts);
    }

    public Long getSnmpInGetRequests() {
        return new Long(this.snmpInGetRequests);
    }

    public Long getSnmpInGetNexts() {
        return new Long(this.snmpInGetNexts);
    }

    public Long getSnmpInSetRequests() {
        return new Long(this.snmpInSetRequests);
    }

    public Long getSnmpInTotalSetVars() {
        return new Long(this.snmpInTotalSetVars);
    }

    public Long getSnmpInTotalReqVars() {
        return new Long(this.snmpInTotalReqVars);
    }

    public Long getSnmpSilentDrops() {
        return new Long(this.snmpSilentDrops);
    }

    public Long getSnmpProxyDrops() {
        return new Long(0L);
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        if (name == null) {
            name = new ObjectName(server.getDefaultDomain() + ":" + "name=SnmpAdaptorServer");
        }
        return super.preRegister(server, name);
    }

    public void postRegister(Boolean registrationDone) {
        super.postRegister(registrationDone);
    }

    public void preDeregister() throws Exception {
        super.preDeregister();
    }

    public void postDeregister() {
        super.postDeregister();
    }

    public SnmpMibHandler addMib(SnmpMibAgent mib) throws IllegalArgumentException {
        if (mib == null) {
            throw new IllegalArgumentException();
        }
        if (!this.mibs.contains(mib)) {
            this.mibs.addElement(mib);
        }
        this.root.register(mib);
        return this;
    }

    public SnmpMibHandler addMib(SnmpMibAgent mib, SnmpOid[] oids) throws IllegalArgumentException {
        if (mib == null) {
            throw new IllegalArgumentException();
        }
        if (oids == null) {
            return this.addMib(mib);
        }
        if (!this.mibs.contains(mib)) {
            this.mibs.addElement(mib);
        }
        for (int i = 0; i < oids.length; ++i) {
            this.root.register(mib, oids[i].longValue());
        }
        return this;
    }

    public SnmpMibHandler addMib(SnmpMibAgent mib, String contextName) throws IllegalArgumentException {
        return this.addMib(mib);
    }

    public SnmpMibHandler addMib(SnmpMibAgent mib, String contextName, SnmpOid[] oids) throws IllegalArgumentException {
        return this.addMib(mib, oids);
    }

    public boolean removeMib(SnmpMibAgent mib, String contextName) {
        return this.removeMib(mib);
    }

    public boolean removeMib(SnmpMibAgent mib) {
        this.root.unregister(mib);
        return this.mibs.removeElement(mib);
    }

    public boolean removeMib(SnmpMibAgent mib, SnmpOid[] oids) {
        this.root.unregister(mib, oids);
        return this.mibs.removeElement(mib);
    }

    public boolean removeMib(SnmpMibAgent mib, String contextName, SnmpOid[] oids) {
        return this.removeMib(mib, oids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doBind() throws CommunicationException, InterruptedException {
        try {
            SnmpAdaptorServer snmpAdaptorServer = this;
            synchronized (snmpAdaptorServer) {
                this.socket = new DatagramSocket(this.port, this.address);
            }
            this.dbgTag = this.makeDebugTag();
        }
        catch (SocketException e) {
            if (e.getMessage().equals(InterruptSysCallMsg)) {
                throw new InterruptedException(e.toString());
            }
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "doBind", "cannot bind on port " + this.port);
            }
            throw new CommunicationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPort() {
        SnmpAdaptorServer snmpAdaptorServer = this;
        synchronized (snmpAdaptorServer) {
            if (this.socket != null) {
                return this.socket.getLocalPort();
            }
        }
        return super.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doUnbind() throws CommunicationException, InterruptedException {
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "doUnbind", "Finally close the socket");
        }
        SnmpAdaptorServer snmpAdaptorServer = this;
        synchronized (snmpAdaptorServer) {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        this.closeTrapSocketIfNeeded();
        this.closeInformSocketIfNeeded();
    }

    void createSnmpRequestHandler(SnmpAdaptorServer server, int id, DatagramSocket s, DatagramPacket p, SnmpMibTree tree, Vector m, Object a, SnmpPduFactory factory, SnmpUserDataFactory dataFactory, MBeanServer f, ObjectName n) {
        SnmpRequestHandler handler = new SnmpRequestHandler(this, id, s, p, tree, m, a, factory, dataFactory, f, n);
        this.threadService.submitTask(handler);
    }

    protected void doReceive() throws CommunicationException, InterruptedException {
        try {
            this.packet = new DatagramPacket(new byte[this.bufferSize], this.bufferSize);
            this.socket.receive(this.packet);
            int state = this.getState();
            if (state != 0) {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "doReceive", "received a message but state not online, returning.");
                }
                return;
            }
            this.createSnmpRequestHandler(this, this.servedClientCount, this.socket, this.packet, this.root, this.mibs, this.ipacl, this.pduFactory, this.userDataFactory, this.topMBS, this.objectName);
        }
        catch (SocketException e) {
            if (e.getMessage().equals(InterruptSysCallMsg)) {
                throw new InterruptedException(e.toString());
            }
            throw new CommunicationException(e);
        }
        catch (InterruptedIOException e) {
            throw new InterruptedException(e.toString());
        }
        catch (CommunicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CommunicationException(e);
        }
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "doReceive", "received a message");
        }
    }

    protected void doError(Exception e) throws CommunicationException {
    }

    protected void doProcess() throws CommunicationException, InterruptedException {
    }

    protected int getBindTries() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        block7: {
            int port = this.getPort();
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "stop", "Stopping: using port " + port);
            }
            if (this.state == 0 || this.state == 3) {
                super.stop();
                try {
                    DatagramSocket sn = new DatagramSocket(0);
                    try {
                        byte[] ob = new byte[1];
                        DatagramPacket pk = this.address != null ? new DatagramPacket(ob, 1, this.address, port) : new DatagramPacket(ob, 1, InetAddress.getLocalHost(), port);
                        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "stop", "Sending: using port " + port);
                        }
                        sn.send(pk);
                        Object var6_6 = null;
                        sn.close();
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        sn.close();
                        throw throwable;
                    }
                }
                catch (Throwable e) {
                    if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) break block7;
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "stop", "Got unexpected Throwable", e);
                }
            }
        }
    }

    public void snmpV1Trap(int generic, int specific, SnmpVarBindList varBindList) throws IOException, SnmpStatusException {
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "snmpV1Trap", "generic=" + generic + ", specific=" + specific);
        }
        SnmpPduTrap pdu = new SnmpPduTrap();
        pdu.address = null;
        pdu.port = this.trapPort;
        pdu.type = 5;
        pdu.version = 330;
        pdu.community = null;
        pdu.enterprise = this.enterpriseOid;
        pdu.genericTrap = generic;
        pdu.specificTrap = specific;
        pdu.timeStamp = this.getSysUpTime();
        if (varBindList != null) {
            pdu.varBindList = new SnmpVarBind[varBindList.size()];
            varBindList.copyInto(pdu.varBindList);
        } else {
            pdu.varBindList = null;
        }
        try {
            pdu.agentAddr = this.address != null ? this.handleMultipleIpVersion(this.address.getAddress()) : this.handleMultipleIpVersion(InetAddress.getLocalHost().getAddress());
        }
        catch (UnknownHostException e) {
            byte[] zeroedAddr = new byte[4];
            pdu.agentAddr = this.handleMultipleIpVersion(zeroedAddr);
        }
        this.sendTrapPdu(pdu);
    }

    private SnmpIpAddress handleMultipleIpVersion(byte[] address) {
        if (address.length == 4) {
            return new SnmpIpAddress(address);
        }
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "handleMultipleIPVersion", "Not an IPv4 address, return null");
        }
        return null;
    }

    public void snmpV1Trap(InetAddress addr, String cs, int generic, int specific, SnmpVarBindList varBindList) throws IOException, SnmpStatusException {
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "snmpV1Trap", "generic=" + generic + ", specific=" + specific);
        }
        SnmpPduTrap pdu = new SnmpPduTrap();
        pdu.address = null;
        pdu.port = this.trapPort;
        pdu.type = 5;
        pdu.version = 330;
        pdu.community = (byte[])(cs != null ? cs.getBytes() : null);
        pdu.enterprise = this.enterpriseOid;
        pdu.genericTrap = generic;
        pdu.specificTrap = specific;
        pdu.timeStamp = this.getSysUpTime();
        if (varBindList != null) {
            pdu.varBindList = new SnmpVarBind[varBindList.size()];
            varBindList.copyInto(pdu.varBindList);
        } else {
            pdu.varBindList = null;
        }
        try {
            pdu.agentAddr = this.address != null ? this.handleMultipleIpVersion(this.address.getAddress()) : this.handleMultipleIpVersion(InetAddress.getLocalHost().getAddress());
        }
        catch (UnknownHostException e) {
            byte[] zeroedAddr = new byte[4];
            pdu.agentAddr = this.handleMultipleIpVersion(zeroedAddr);
        }
        if (addr != null) {
            this.sendTrapPdu(addr, pdu);
        } else {
            this.sendTrapPdu(pdu);
        }
    }

    public void snmpV1Trap(InetAddress addr, SnmpIpAddress agentAddr, String cs, SnmpOid enterpOid, int generic, int specific, SnmpVarBindList varBindList, SnmpTimeticks time) throws IOException, SnmpStatusException {
        this.snmpV1Trap(addr, this.trapPort, agentAddr, cs, enterpOid, generic, specific, varBindList, time);
    }

    public void snmpV1Trap(SnmpPeer peer, SnmpIpAddress agentAddr, SnmpOid enterpOid, int generic, int specific, SnmpVarBindList varBindList, SnmpTimeticks time) throws IOException, SnmpStatusException {
        SnmpParameters p = peer.getParams();
        this.snmpV1Trap(peer.getDestAddr(), peer.getDestPort(), agentAddr, p.getRdCommunity(), enterpOid, generic, specific, varBindList, time);
    }

    private void snmpV1Trap(InetAddress addr, int port, SnmpIpAddress agentAddr, String cs, SnmpOid enterpOid, int generic, int specific, SnmpVarBindList varBindList, SnmpTimeticks time) throws IOException, SnmpStatusException {
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "snmpV1Trap", "generic=" + generic + ", specific=" + specific);
        }
        SnmpPduTrap pdu = new SnmpPduTrap();
        pdu.address = null;
        pdu.port = port;
        pdu.type = 5;
        pdu.version = 330;
        pdu.community = (byte[])(cs != null ? cs.getBytes() : null);
        pdu.enterprise = enterpOid != null ? enterpOid : this.enterpriseOid;
        pdu.genericTrap = generic;
        pdu.specificTrap = specific;
        pdu.timeStamp = time != null ? (long)time.longValue() : this.getSysUpTime();
        if (varBindList != null) {
            pdu.varBindList = new SnmpVarBind[varBindList.size()];
            varBindList.copyInto(pdu.varBindList);
        } else {
            pdu.varBindList = null;
        }
        if (agentAddr == null) {
            try {
                InetAddress inetAddr = this.address != null ? this.address : InetAddress.getLocalHost();
                agentAddr = this.handleMultipleIpVersion(inetAddr.getAddress());
            }
            catch (UnknownHostException e) {
                byte[] zeroedAddr = new byte[4];
                agentAddr = this.handleMultipleIpVersion(zeroedAddr);
            }
        }
        pdu.agentAddr = agentAddr;
        if (addr != null) {
            this.sendTrapPdu(addr, pdu);
        } else {
            this.sendTrapPdu(pdu);
        }
    }

    public void snmpV2Trap(SnmpPeer peer, SnmpOid trapOid, SnmpVarBindList varBindList, SnmpTimeticks time) throws IOException, SnmpStatusException {
        SnmpParameters p = peer.getParams();
        this.snmpV2Trap(peer.getDestAddr(), peer.getDestPort(), p.getRdCommunity(), trapOid, varBindList, time);
    }

    public void snmpV2Trap(SnmpOid trapOid, SnmpVarBindList varBindList) throws IOException, SnmpStatusException {
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "snmpV2Trap", "trapOid=" + trapOid);
        }
        SnmpPduRequest pdu = new SnmpPduRequest();
        pdu.address = null;
        pdu.port = this.trapPort;
        pdu.type = 9;
        pdu.version = 220;
        pdu.community = null;
        SnmpVarBindList fullVbl = varBindList != null ? varBindList.clone() : new SnmpVarBindList(2);
        SnmpTimeticks sysUpTimeValue = new SnmpTimeticks(this.getSysUpTime());
        fullVbl.insertElementAt(new SnmpVarBind(snmpTrapOidOid, trapOid), 0);
        fullVbl.insertElementAt(new SnmpVarBind(sysUpTimeOid, sysUpTimeValue), 0);
        pdu.varBindList = new SnmpVarBind[fullVbl.size()];
        fullVbl.copyInto(pdu.varBindList);
        this.sendTrapPdu(pdu);
    }

    public void snmpV2Trap(InetAddress addr, String cs, SnmpOid trapOid, SnmpVarBindList varBindList) throws IOException, SnmpStatusException {
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "snmpV2Trap", "trapOid=" + trapOid);
        }
        SnmpPduRequest pdu = new SnmpPduRequest();
        pdu.address = null;
        pdu.port = this.trapPort;
        pdu.type = 9;
        pdu.version = 220;
        pdu.community = (byte[])(cs != null ? cs.getBytes() : null);
        SnmpVarBindList fullVbl = varBindList != null ? varBindList.clone() : new SnmpVarBindList(2);
        SnmpTimeticks sysUpTimeValue = new SnmpTimeticks(this.getSysUpTime());
        fullVbl.insertElementAt(new SnmpVarBind(snmpTrapOidOid, trapOid), 0);
        fullVbl.insertElementAt(new SnmpVarBind(sysUpTimeOid, sysUpTimeValue), 0);
        pdu.varBindList = new SnmpVarBind[fullVbl.size()];
        fullVbl.copyInto(pdu.varBindList);
        if (addr != null) {
            this.sendTrapPdu(addr, pdu);
        } else {
            this.sendTrapPdu(pdu);
        }
    }

    public void snmpV2Trap(InetAddress addr, String cs, SnmpOid trapOid, SnmpVarBindList varBindList, SnmpTimeticks time) throws IOException, SnmpStatusException {
        this.snmpV2Trap(addr, this.trapPort, cs, trapOid, varBindList, time);
    }

    private void snmpV2Trap(InetAddress addr, int port, String cs, SnmpOid trapOid, SnmpVarBindList varBindList, SnmpTimeticks time) throws IOException, SnmpStatusException {
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            StringBuilder strb = new StringBuilder().append("trapOid=").append(trapOid).append("\ncommunity=").append(cs).append("\naddr=").append(addr).append("\nvarBindList=").append(varBindList).append("\ntime=").append(time).append("\ntrapPort=").append(port);
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "snmpV2Trap", strb.toString());
        }
        SnmpPduRequest pdu = new SnmpPduRequest();
        pdu.address = null;
        pdu.port = port;
        pdu.type = 9;
        pdu.version = 220;
        pdu.community = (byte[])(cs != null ? cs.getBytes() : null);
        SnmpVarBindList fullVbl = varBindList != null ? varBindList.clone() : new SnmpVarBindList(2);
        SnmpTimeticks sysUpTimeValue = null;
        sysUpTimeValue = time != null ? time : new SnmpTimeticks(this.getSysUpTime());
        fullVbl.insertElementAt(new SnmpVarBind(snmpTrapOidOid, trapOid), 0);
        fullVbl.insertElementAt(new SnmpVarBind(sysUpTimeOid, sysUpTimeValue), 0);
        pdu.varBindList = new SnmpVarBind[fullVbl.size()];
        fullVbl.copyInto(pdu.varBindList);
        if (addr != null) {
            this.sendTrapPdu(addr, pdu);
        } else {
            this.sendTrapPdu(pdu);
        }
    }

    public void snmpPduTrap(InetAddress address, SnmpPduPacket pdu) throws IOException, SnmpStatusException {
        if (address != null) {
            this.sendTrapPdu(address, pdu);
        } else {
            this.sendTrapPdu(pdu);
        }
    }

    public void snmpPduTrap(SnmpPeer peer, SnmpPduPacket pdu) throws IOException, SnmpStatusException {
        if (peer != null) {
            pdu.port = peer.getDestPort();
            this.sendTrapPdu(peer.getDestAddr(), pdu);
        } else {
            pdu.port = this.getTrapPort();
            this.sendTrapPdu(pdu);
        }
    }

    private void sendTrapPdu(SnmpPduPacket pdu) throws SnmpStatusException, IOException {
        block14: {
            SnmpMessage msg = null;
            try {
                msg = (SnmpMessage)this.pduFactory.encodeSnmpPdu(pdu, this.bufferSize);
                if (msg == null) {
                    throw new SnmpStatusException(70);
                }
            }
            catch (SnmpTooBigException x) {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "sendTrapPdu", "Trap pdu is too big. Trap hasn't been sent to anyone");
                }
                throw new SnmpStatusException(660);
            }
            int sendingCount = 0;
            this.openTrapSocketIfNeeded();
            if (this.ipacl != null) {
                Enumeration ed = ((InetAddressAcl)this.ipacl).getTrapDestinations();
                while (ed.hasMoreElements()) {
                    msg.address = (InetAddress)ed.nextElement();
                    Enumeration ec = ((InetAddressAcl)this.ipacl).getTrapCommunities(msg.address);
                    while (ec.hasMoreElements()) {
                        msg.community = ((String)ec.nextElement()).getBytes();
                        try {
                            this.sendTrapMessage(msg);
                            ++sendingCount;
                        }
                        catch (SnmpTooBigException x) {
                            if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) continue;
                            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "sendTrapPdu", "Trap pdu is too big. Trap hasn't been sent to " + msg.address);
                        }
                    }
                }
            }
            if (sendingCount == 0) {
                try {
                    msg.address = InetAddress.getLocalHost();
                    this.sendTrapMessage(msg);
                }
                catch (SnmpTooBigException x) {
                    if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "sendTrapPdu", "Trap pdu is too big. Trap hasn't been sent.");
                    }
                }
                catch (UnknownHostException e) {
                    if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) break block14;
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "sendTrapPdu", "Trap pdu is too big. Trap hasn't been sent.");
                }
            }
        }
        this.closeTrapSocketIfNeeded();
    }

    private void sendTrapPdu(InetAddress addr, SnmpPduPacket pdu) throws SnmpStatusException, IOException {
        block7: {
            SnmpMessage msg = null;
            try {
                msg = (SnmpMessage)this.pduFactory.encodeSnmpPdu(pdu, this.bufferSize);
                if (msg == null) {
                    throw new SnmpStatusException(70);
                }
            }
            catch (SnmpTooBigException x) {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "sendTrapPdu", "Trap pdu is too big. Trap hasn't been sent to the specified host.");
                }
                throw new SnmpStatusException(660);
            }
            this.openTrapSocketIfNeeded();
            if (addr != null) {
                msg.address = addr;
                try {
                    this.sendTrapMessage(msg);
                }
                catch (SnmpTooBigException x) {
                    if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) break block7;
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "sendTrapPdu", "Trap pdu is too big. Trap hasn't been sent to " + msg.address);
                }
            }
        }
        this.closeTrapSocketIfNeeded();
    }

    private void sendTrapMessage(SnmpMessage msg) throws IOException, SnmpTooBigException {
        byte[] buffer = new byte[this.bufferSize];
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
        int encodingLength = msg.encodeMessage(buffer);
        packet.setLength(encodingLength);
        packet.setAddress(msg.address);
        packet.setPort(msg.port);
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "sendTrapMessage", "sending trap to " + msg.address + ":" + msg.port);
        }
        this.trapSocket.send(packet);
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "sendTrapMessage", "sent to " + msg.address + ":" + msg.port);
        }
        ++this.snmpOutTraps;
        ++this.snmpOutPkts;
    }

    synchronized void openTrapSocketIfNeeded() throws SocketException {
        if (this.trapSocket == null) {
            this.trapSocket = new DatagramSocket(0, this.address);
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "openTrapSocketIfNeeded", "using port " + this.trapSocket.getLocalPort() + " to send traps");
            }
        }
    }

    synchronized void closeTrapSocketIfNeeded() {
        if (this.trapSocket != null && this.state != 0) {
            this.trapSocket.close();
            this.trapSocket = null;
        }
    }

    public Vector snmpInformRequest(SnmpInformHandler cb, SnmpOid trapOid, SnmpVarBindList varBindList) throws IllegalStateException, IOException, SnmpStatusException {
        if (!this.isActive()) {
            throw new IllegalStateException("Start SNMP adaptor server before carrying out this operation");
        }
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "snmpInformRequest", "trapOid=" + trapOid);
        }
        SnmpVarBindList fullVbl = varBindList != null ? varBindList.clone() : new SnmpVarBindList(2);
        SnmpTimeticks sysUpTimeValue = new SnmpTimeticks(this.getSysUpTime());
        fullVbl.insertElementAt(new SnmpVarBind(snmpTrapOidOid, trapOid), 0);
        fullVbl.insertElementAt(new SnmpVarBind(sysUpTimeOid, sysUpTimeValue), 0);
        this.openInformSocketIfNeeded();
        Vector<SnmpInformRequest> informReqList = new Vector<SnmpInformRequest>();
        InetAddress addr = null;
        String cs = null;
        if (this.ipacl != null) {
            Enumeration ed = ((InetAddressAcl)this.ipacl).getInformDestinations();
            while (ed.hasMoreElements()) {
                addr = (InetAddress)ed.nextElement();
                Enumeration ec = ((InetAddressAcl)this.ipacl).getInformCommunities(addr);
                while (ec.hasMoreElements()) {
                    cs = (String)ec.nextElement();
                    informReqList.addElement(this.informSession.makeAsyncRequest(addr, cs, cb, fullVbl, this.getInformPort()));
                }
            }
        }
        return informReqList;
    }

    public SnmpInformRequest snmpInformRequest(InetAddress addr, String cs, SnmpInformHandler cb, SnmpOid trapOid, SnmpVarBindList varBindList) throws IllegalStateException, IOException, SnmpStatusException {
        return this.snmpInformRequest(addr, this.getInformPort(), cs, cb, trapOid, varBindList);
    }

    public SnmpInformRequest snmpInformRequest(SnmpPeer peer, SnmpInformHandler cb, SnmpOid trapOid, SnmpVarBindList varBindList) throws IllegalStateException, IOException, SnmpStatusException {
        SnmpParameters p = peer.getParams();
        return this.snmpInformRequest(peer.getDestAddr(), peer.getDestPort(), p.getInformCommunity(), cb, trapOid, varBindList);
    }

    public static final int mapErrorStatus(int errorStatus, int protocolVersion, int reqPduType) {
        return SnmpSubRequestHandler.mapErrorStatus(errorStatus, protocolVersion, reqPduType);
    }

    private SnmpInformRequest snmpInformRequest(InetAddress addr, int port, String cs, SnmpInformHandler cb, SnmpOid trapOid, SnmpVarBindList varBindList) throws IllegalStateException, IOException, SnmpStatusException {
        if (!this.isActive()) {
            throw new IllegalStateException("Start SNMP adaptor server before carrying out this operation");
        }
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "snmpInformRequest", "trapOid=" + trapOid);
        }
        SnmpVarBindList fullVbl = varBindList != null ? varBindList.clone() : new SnmpVarBindList(2);
        SnmpTimeticks sysUpTimeValue = new SnmpTimeticks(this.getSysUpTime());
        fullVbl.insertElementAt(new SnmpVarBind(snmpTrapOidOid, trapOid), 0);
        fullVbl.insertElementAt(new SnmpVarBind(sysUpTimeOid, sysUpTimeValue), 0);
        this.openInformSocketIfNeeded();
        return this.informSession.makeAsyncRequest(addr, cs, cb, fullVbl, port);
    }

    synchronized void openInformSocketIfNeeded() throws SocketException {
        if (this.informSession == null) {
            this.informSession = new SnmpSession(this);
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "openInformSocketIfNeeded", "to send inform requests and receive inform responses");
            }
        }
    }

    synchronized void closeInformSocketIfNeeded() {
        if (this.informSession != null && this.state != 0) {
            this.informSession.destroySession();
            this.informSession = null;
        }
    }

    InetAddress getAddress() {
        return this.address;
    }

    protected void finalize() {
        block3: {
            try {
                if (this.socket != null) {
                    this.socket.close();
                    this.socket = null;
                }
                this.threadService.terminate();
            }
            catch (Exception e) {
                if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) break block3;
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "finalize", "Exception in finalizer", e);
            }
        }
    }

    String makeDebugTag() {
        return "SnmpAdaptorServer[" + this.getProtocol() + ":" + this.getPort() + "]";
    }

    void updateRequestCounters(int pduType) {
        switch (pduType) {
            case 1: {
                ++this.snmpInGetRequests;
                break;
            }
            case 2: {
                ++this.snmpInGetNexts;
                break;
            }
            case 4: {
                ++this.snmpInSetRequests;
                break;
            }
        }
        ++this.snmpInPkts;
    }

    void updateErrorCounters(int errorStatus) {
        switch (errorStatus) {
            case 1230: {
                ++this.snmpOutGetResponses;
                break;
            }
            case 0: {
                ++this.snmpOutGenErrs;
                break;
            }
            case 40: {
                ++this.snmpOutBadValues;
                break;
            }
            case 10: {
                ++this.snmpOutNoSuchNames;
                break;
            }
            case 660: {
                ++this.snmpOutTooBigs;
                break;
            }
        }
        ++this.snmpOutPkts;
    }

    void updateVarCounters(int pduType, int n) {
        switch (pduType) {
            case 1: 
            case 2: 
            case 8: {
                this.snmpInTotalReqVars += n;
                break;
            }
            case 4: {
                this.snmpInTotalSetVars += n;
            }
        }
    }

    void incSnmpInASNParseErrs(int n) {
        this.snmpInASNParseErrs += n;
    }

    void incSnmpInBadVersions(int n) {
        this.snmpInBadVersions += n;
    }

    void incSnmpInBadCommunityUses(int n) {
        this.snmpInBadCommunityUses += n;
    }

    void incSnmpInBadCommunityNames(int n) {
        this.snmpInBadCommunityNames += n;
    }

    void incSnmpSilentDrops(int n) {
        this.snmpSilentDrops += n;
    }

    long getSysUpTime() {
        return (System.currentTimeMillis() - this.startUpTime) / 10L;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.mibs = new Vector();
    }

    private void init(Object acl, int p, InetAddress a) {
        this.root = new SnmpMibTree();
        this.root.setDefaultAgent(new SnmpErrorHandlerAgent());
        this.startUpTime = System.currentTimeMillis();
        this.maxActiveClientCount = 10;
        this.pduFactory = new SnmpPduFactoryBER();
        this.port = p;
        this.ipacl = acl;
        this.address = a;
        if (this.ipacl == null && this.useAcl) {
            throw new IllegalArgumentException("ACL object cannot be null");
        }
        this.threadService = new ThreadService(threadNumber);
    }

    SnmpMibAgent getAgentMib(SnmpOid oid) {
        return this.root.getAgentMib(oid);
    }

    protected Thread createMainThread() {
        Thread t = super.createMainThread();
        t.setDaemon(true);
        return t;
    }

    static {
        String s = System.getProperty("com.sun.jmx.snmp.threadnumber");
        if (s != null) {
            try {
                threadNumber = Integer.parseInt(System.getProperty(s));
            }
            catch (Exception e) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpAdaptorServer.class.getName(), "<static init>", "Got wrong value for com.sun.jmx.snmp.threadnumber: " + s + ". Use the default value: " + threadNumber);
            }
        }
    }
}

