/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.snmp.BerDecoder;
import com.sun.jmx.snmp.BerEncoder;
import com.sun.jmx.snmp.BerException;
import com.sun.jmx.snmp.SnmpEngineId;
import com.sun.jmx.snmp.SnmpMsg;
import com.sun.jmx.snmp.SnmpPdu;
import com.sun.jmx.snmp.SnmpPduBulkType;
import com.sun.jmx.snmp.SnmpPduRequestType;
import com.sun.jmx.snmp.SnmpScopedPduBulk;
import com.sun.jmx.snmp.SnmpScopedPduPacket;
import com.sun.jmx.snmp.SnmpScopedPduRequest;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpTooBigException;
import java.util.logging.Level;

public class SnmpV3Message
extends SnmpMsg {
    public int msgId = 0;
    public int msgMaxSize = 0;
    public byte msgFlags = 0;
    public int msgSecurityModel = 0;
    public byte[] msgSecurityParameters = null;
    public byte[] contextEngineId = null;
    public byte[] contextName = null;
    public byte[] encryptedPdu = null;

    public int encodeMessage(byte[] outputBytes) throws SnmpTooBigException {
        boolean encodingLength = false;
        if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_LOGGER.logp(Level.FINER, SnmpV3Message.class.getName(), "encodeMessage", "Can't encode directly V3Message! Need a SecuritySubSystem");
        }
        throw new IllegalArgumentException("Can't encode");
    }

    public void decodeMessage(byte[] inputBytes, int byteCount) throws SnmpStatusException {
        try {
            BerDecoder bdec = new BerDecoder(inputBytes);
            bdec.openSequence();
            this.version = bdec.fetchInteger();
            bdec.openSequence();
            this.msgId = bdec.fetchInteger();
            this.msgMaxSize = bdec.fetchInteger();
            this.msgFlags = bdec.fetchOctetString()[0];
            this.msgSecurityModel = bdec.fetchInteger();
            bdec.closeSequence();
            this.msgSecurityParameters = bdec.fetchOctetString();
            if ((this.msgFlags & 0) == 0) {
                bdec.openSequence();
                this.contextEngineId = bdec.fetchOctetString();
                this.contextName = bdec.fetchOctetString();
                this.data = bdec.fetchAny();
                this.dataLength = this.data.length;
                bdec.closeSequence();
            } else {
                this.encryptedPdu = bdec.fetchOctetString();
            }
            bdec.closeSequence();
        }
        catch (BerException x) {
            x.printStackTrace();
            throw new SnmpStatusException("Invalid encoding");
        }
        if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINER)) {
            StringBuilder strb = new StringBuilder().append("Unmarshalled message : \n").append("version : ").append(this.version).append("\n").append("msgId : ").append(this.msgId).append("\n").append("msgMaxSize : ").append(this.msgMaxSize).append("\n").append("msgFlags : ").append(this.msgFlags).append("\n").append("msgSecurityModel : ").append(this.msgSecurityModel).append("\n").append("contextEngineId : ").append(this.contextEngineId == null ? null : SnmpEngineId.createEngineId(this.contextEngineId)).append("\n").append("contextName : ").append(this.contextName).append("\n").append("data : ").append(this.data).append("\n").append("dat len : ").append(this.data == null ? 0 : this.data.length).append("\n").append("encryptedPdu : ").append(this.encryptedPdu).append("\n");
            JmxProperties.SNMP_LOGGER.logp(Level.FINER, SnmpV3Message.class.getName(), "decodeMessage", strb.toString());
        }
    }

    public int getRequestId(byte[] data) throws SnmpStatusException {
        BerDecoder bdec = null;
        int msgId = 0;
        try {
            bdec = new BerDecoder(data);
            bdec.openSequence();
            bdec.fetchInteger();
            bdec.openSequence();
            msgId = bdec.fetchInteger();
        }
        catch (BerException x) {
            throw new SnmpStatusException("Invalid encoding");
        }
        try {
            bdec.closeSequence();
        }
        catch (BerException x) {
            // empty catch block
        }
        return msgId;
    }

    public void encodeSnmpPdu(SnmpPdu p, int maxDataLength) throws SnmpStatusException, SnmpTooBigException {
        SnmpScopedPduPacket pdu = (SnmpScopedPduPacket)p;
        if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINER)) {
            StringBuilder strb = new StringBuilder().append("PDU to marshall: \n").append("security parameters : ").append(pdu.securityParameters).append("\n").append("type : ").append(pdu.type).append("\n").append("version : ").append(pdu.version).append("\n").append("requestId : ").append(pdu.requestId).append("\n").append("msgId : ").append(pdu.msgId).append("\n").append("msgMaxSize : ").append(pdu.msgMaxSize).append("\n").append("msgFlags : ").append(pdu.msgFlags).append("\n").append("msgSecurityModel : ").append(pdu.msgSecurityModel).append("\n").append("contextEngineId : ").append(pdu.contextEngineId).append("\n").append("contextName : ").append(pdu.contextName).append("\n");
            JmxProperties.SNMP_LOGGER.logp(Level.FINER, SnmpV3Message.class.getName(), "encodeSnmpPdu", strb.toString());
        }
        this.version = pdu.version;
        this.address = pdu.address;
        this.port = pdu.port;
        this.msgId = pdu.msgId;
        this.msgMaxSize = pdu.msgMaxSize;
        this.msgFlags = pdu.msgFlags;
        this.msgSecurityModel = pdu.msgSecurityModel;
        this.contextEngineId = pdu.contextEngineId;
        this.contextName = pdu.contextName;
        this.securityParameters = pdu.securityParameters;
        this.data = new byte[maxDataLength];
        try {
            BerEncoder benc = new BerEncoder(this.data);
            benc.openSequence();
            this.encodeVarBindList(benc, pdu.varBindList);
            switch (pdu.type) {
                case 1: 
                case 2: 
                case 4: 
                case 6: 
                case 7: 
                case 9: 
                case 10: {
                    SnmpPduRequestType reqPdu = (SnmpPduRequestType)((Object)pdu);
                    benc.putInteger(reqPdu.getErrorIndex());
                    benc.putInteger(reqPdu.getErrorStatus());
                    benc.putInteger(pdu.requestId);
                    break;
                }
                case 8: {
                    SnmpPduBulkType bulkPdu = (SnmpPduBulkType)((Object)pdu);
                    benc.putInteger(bulkPdu.getMaxRepetitions());
                    benc.putInteger(bulkPdu.getNonRepeaters());
                    benc.putInteger(pdu.requestId);
                    break;
                }
                default: {
                    throw new SnmpStatusException("Invalid pdu type " + String.valueOf(pdu.type));
                }
            }
            benc.closeSequence(pdu.type);
            this.dataLength = benc.trim();
        }
        catch (ArrayIndexOutOfBoundsException x) {
            throw new SnmpTooBigException();
        }
    }

    public SnmpPdu decodeSnmpPdu() throws SnmpStatusException {
        SnmpScopedPduPacket pdu = null;
        BerDecoder bdec = new BerDecoder(this.data);
        try {
            int type = bdec.getTag();
            bdec.openSequence(type);
            switch (type) {
                case 1: 
                case 2: 
                case 4: 
                case 6: 
                case 7: 
                case 9: 
                case 10: {
                    SnmpScopedPduRequest reqPdu = new SnmpScopedPduRequest();
                    reqPdu.requestId = bdec.fetchInteger();
                    reqPdu.setErrorStatus(bdec.fetchInteger());
                    reqPdu.setErrorIndex(bdec.fetchInteger());
                    pdu = reqPdu;
                    break;
                }
                case 8: {
                    SnmpScopedPduBulk bulkPdu = new SnmpScopedPduBulk();
                    bulkPdu.requestId = bdec.fetchInteger();
                    bulkPdu.setNonRepeaters(bdec.fetchInteger());
                    bulkPdu.setMaxRepetitions(bdec.fetchInteger());
                    pdu = bulkPdu;
                    break;
                }
                default: {
                    throw new SnmpStatusException(0);
                }
            }
            pdu.type = type;
            pdu.varBindList = this.decodeVarBindList(bdec);
            bdec.closeSequence();
        }
        catch (BerException e) {
            if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_LOGGER.logp(Level.FINEST, SnmpV3Message.class.getName(), "decodeSnmpPdu", "BerException", e);
            }
            throw new SnmpStatusException(0);
        }
        pdu.address = this.address;
        pdu.port = this.port;
        pdu.msgFlags = this.msgFlags;
        pdu.version = this.version;
        pdu.msgId = this.msgId;
        pdu.msgMaxSize = this.msgMaxSize;
        pdu.msgSecurityModel = this.msgSecurityModel;
        pdu.contextEngineId = this.contextEngineId;
        pdu.contextName = this.contextName;
        pdu.securityParameters = this.securityParameters;
        if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINER)) {
            StringBuilder strb = new StringBuilder().append("Unmarshalled PDU : \n").append("type : ").append(pdu.type).append("\n").append("version : ").append(pdu.version).append("\n").append("requestId : ").append(pdu.requestId).append("\n").append("msgId : ").append(pdu.msgId).append("\n").append("msgMaxSize : ").append(pdu.msgMaxSize).append("\n").append("msgFlags : ").append(pdu.msgFlags).append("\n").append("msgSecurityModel : ").append(pdu.msgSecurityModel).append("\n").append("contextEngineId : ").append(pdu.contextEngineId).append("\n").append("contextName : ").append(pdu.contextName).append("\n");
            JmxProperties.SNMP_LOGGER.logp(Level.FINER, SnmpV3Message.class.getName(), "decodeSnmpPdu", strb.toString());
        }
        return pdu;
    }

    public String printMessage() {
        StringBuffer sb = new StringBuffer();
        sb.append("msgId : " + this.msgId + "\n");
        sb.append("msgMaxSize : " + this.msgMaxSize + "\n");
        sb.append("msgFlags : " + this.msgFlags + "\n");
        sb.append("msgSecurityModel : " + this.msgSecurityModel + "\n");
        if (this.contextEngineId == null) {
            sb.append("contextEngineId : null");
        } else {
            sb.append("contextEngineId : {\n");
            sb.append(SnmpV3Message.dumpHexBuffer(this.contextEngineId, 0, this.contextEngineId.length));
            sb.append("\n}\n");
        }
        if (this.contextName == null) {
            sb.append("contextName : null");
        } else {
            sb.append("contextName : {\n");
            sb.append(SnmpV3Message.dumpHexBuffer(this.contextName, 0, this.contextName.length));
            sb.append("\n}\n");
        }
        return sb.append(super.printMessage()).toString();
    }
}

