/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.IPAcl;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.snmp.IPAcl.PrincipalImpl;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NetMaskImpl
extends PrincipalImpl
implements Group,
Serializable {
    private static final long serialVersionUID = -7332541893877932896L;
    protected byte[] subnet = null;
    protected int prefix = -1;

    public NetMaskImpl() throws UnknownHostException {
    }

    private byte[] extractSubNet(byte[] b) {
        int fullyCoveredByte;
        int addrLength = b.length;
        byte[] subnet = null;
        if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_LOGGER.logp(Level.FINEST, NetMaskImpl.class.getName(), "extractSubNet", "BINARY ARRAY :");
            StringBuffer buff = new StringBuffer();
            for (int i = 0; i < addrLength; ++i) {
                buff.append((b[i] & 0xFF) + ":");
            }
            JmxProperties.SNMP_LOGGER.logp(Level.FINEST, NetMaskImpl.class.getName(), "extractSubNet", buff.toString());
        }
        if ((fullyCoveredByte = this.prefix / 8) == addrLength) {
            if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_LOGGER.logp(Level.FINEST, NetMaskImpl.class.getName(), "extractSubNet", "The mask is the complete address, strange..." + addrLength);
            }
            subnet = b;
            return subnet;
        }
        if (fullyCoveredByte > addrLength) {
            if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_LOGGER.logp(Level.FINEST, NetMaskImpl.class.getName(), "extractSubNet", "The number of covered byte is longer than the address. BUG");
            }
            throw new IllegalArgumentException("The number of covered byte is longer than the address.");
        }
        int partialyCoveredIndex = fullyCoveredByte;
        if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_LOGGER.logp(Level.FINEST, NetMaskImpl.class.getName(), "extractSubNet", "Partially covered index : " + partialyCoveredIndex);
        }
        byte toDeal = b[partialyCoveredIndex];
        if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_LOGGER.logp(Level.FINEST, NetMaskImpl.class.getName(), "extractSubNet", "Partially covered byte : " + toDeal);
        }
        int nbbits = this.prefix % 8;
        int subnetSize = 0;
        subnetSize = nbbits == 0 ? partialyCoveredIndex : partialyCoveredIndex + 1;
        if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_LOGGER.logp(Level.FINEST, NetMaskImpl.class.getName(), "extractSubNet", "Remains : " + nbbits);
        }
        int mask = 0;
        for (int i = 0; i < nbbits; ++i) {
            mask = (byte)(mask | 1 << 7 - i);
        }
        if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_LOGGER.logp(Level.FINEST, NetMaskImpl.class.getName(), "extractSubNet", "Mask value : " + (mask & 0xFF));
        }
        byte maskedValue = (byte)(toDeal & mask);
        if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_LOGGER.logp(Level.FINEST, NetMaskImpl.class.getName(), "extractSubNet", "Masked byte : " + (maskedValue & 0xFF));
        }
        subnet = new byte[subnetSize];
        if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_LOGGER.logp(Level.FINEST, NetMaskImpl.class.getName(), "extractSubNet", "Resulting subnet : ");
        }
        for (int i = 0; i < partialyCoveredIndex; ++i) {
            subnet[i] = b[i];
            if (!JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) continue;
            JmxProperties.SNMP_LOGGER.logp(Level.FINEST, NetMaskImpl.class.getName(), "extractSubNet", (subnet[i] & 0xFF) + ":");
        }
        if (nbbits != 0) {
            subnet[partialyCoveredIndex] = maskedValue;
            if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_LOGGER.logp(Level.FINEST, NetMaskImpl.class.getName(), "extractSubNet", "Last subnet byte : " + (subnet[partialyCoveredIndex] & 0xFF));
            }
        }
        return subnet;
    }

    public NetMaskImpl(String a, int prefix) throws UnknownHostException {
        super(a);
        this.prefix = prefix;
        this.subnet = this.extractSubNet(this.getAddress().getAddress());
    }

    @Override
    public boolean addMember(Principal p) {
        return true;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object p) {
        if (p instanceof PrincipalImpl || p instanceof NetMaskImpl) {
            PrincipalImpl received = (PrincipalImpl)p;
            InetAddress addr = received.getAddress();
            if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_LOGGER.logp(Level.FINEST, NetMaskImpl.class.getName(), "equals", "Received Address : " + addr);
            }
            byte[] recAddr = addr.getAddress();
            for (int i = 0; i < this.subnet.length; ++i) {
                if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_LOGGER.logp(Level.FINEST, NetMaskImpl.class.getName(), "equals", "(recAddr[i]) : " + (recAddr[i] & 0xFF));
                    JmxProperties.SNMP_LOGGER.logp(Level.FINEST, NetMaskImpl.class.getName(), "equals", "(recAddr[i] & subnet[i]) : " + (recAddr[i] & this.subnet[i] & 0xFF) + " subnet[i] : " + (this.subnet[i] & 0xFF));
                }
                if ((recAddr[i] & this.subnet[i]) == this.subnet[i]) continue;
                if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_LOGGER.logp(Level.FINEST, NetMaskImpl.class.getName(), "equals", "FALSE");
                }
                return false;
            }
            if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_LOGGER.logp(Level.FINEST, NetMaskImpl.class.getName(), "equals", "TRUE");
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isMember(Principal p) {
        return (((Object)p).hashCode() & super.hashCode()) == ((Object)p).hashCode();
    }

    @Override
    public Enumeration<? extends Principal> members() {
        Vector<NetMaskImpl> v = new Vector<NetMaskImpl>(1);
        v.addElement(this);
        return v.elements();
    }

    @Override
    public boolean removeMember(Principal p) {
        return true;
    }

    @Override
    public String toString() {
        return "NetMaskImpl :" + super.getAddress().toString() + "/" + this.prefix;
    }
}

