/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.IPAcl;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.snmp.IPAcl.AclEntryImpl;
import com.sun.jmx.snmp.IPAcl.AclImpl;
import com.sun.jmx.snmp.IPAcl.JDMAccess;
import com.sun.jmx.snmp.IPAcl.JDMAclItem;
import com.sun.jmx.snmp.IPAcl.JDMCommunities;
import com.sun.jmx.snmp.IPAcl.JDMHost;
import com.sun.jmx.snmp.IPAcl.JDMHostInform;
import com.sun.jmx.snmp.IPAcl.JDMHostTrap;
import com.sun.jmx.snmp.IPAcl.JDMInformCommunity;
import com.sun.jmx.snmp.IPAcl.JDMInformInterestedHost;
import com.sun.jmx.snmp.IPAcl.JDMInformItem;
import com.sun.jmx.snmp.IPAcl.JDMManagers;
import com.sun.jmx.snmp.IPAcl.JDMTrapCommunity;
import com.sun.jmx.snmp.IPAcl.JDMTrapInterestedHost;
import com.sun.jmx.snmp.IPAcl.JDMTrapItem;
import com.sun.jmx.snmp.IPAcl.Parser;
import com.sun.jmx.snmp.IPAcl.PrincipalImpl;
import com.sun.jmx.snmp.IPAcl.SimpleNode;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.acl.NotOwnerException;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Host
extends SimpleNode
implements Serializable {
    public Host(int id) {
        super(id);
    }

    public Host(Parser p, int id) {
        super(p, id);
    }

    protected abstract PrincipalImpl createAssociatedPrincipal() throws UnknownHostException;

    protected abstract String getHname();

    @Override
    public void buildAclEntries(PrincipalImpl owner, AclImpl acl) {
        PrincipalImpl p = null;
        try {
            p = this.createAssociatedPrincipal();
        }
        catch (UnknownHostException e) {
            if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_LOGGER.logp(Level.FINEST, Host.class.getName(), "buildAclEntries", "Cannot create ACL entry; got exception", e);
            }
            throw new IllegalArgumentException("Cannot create ACL entry for " + e.getMessage());
        }
        AclEntryImpl entry = null;
        try {
            entry = new AclEntryImpl(p);
            this.registerPermission(entry);
            acl.addEntry(owner, entry);
        }
        catch (UnknownHostException e) {
            if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_LOGGER.logp(Level.FINEST, Host.class.getName(), "buildAclEntries", "Cannot create ACL entry; got exception", e);
            }
            return;
        }
        catch (NotOwnerException a) {
            if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_LOGGER.logp(Level.FINEST, Host.class.getName(), "buildAclEntries", "Cannot create ACL entry; got exception", a);
            }
            return;
        }
    }

    private void registerPermission(AclEntryImpl entry) {
        JDMHost host = (JDMHost)this.jjtGetParent();
        JDMManagers manager = (JDMManagers)host.jjtGetParent();
        JDMAclItem acl = (JDMAclItem)manager.jjtGetParent();
        JDMAccess access = acl.getAccess();
        access.putPermission(entry);
        JDMCommunities comm = acl.getCommunities();
        comm.buildCommunities(entry);
    }

    @Override
    public void buildTrapEntries(Hashtable<InetAddress, Vector<String>> dest) {
        JDMHostTrap host = (JDMHostTrap)this.jjtGetParent();
        JDMTrapInterestedHost hosts = (JDMTrapInterestedHost)host.jjtGetParent();
        JDMTrapItem trap = (JDMTrapItem)hosts.jjtGetParent();
        JDMTrapCommunity community = trap.getCommunity();
        String comm = community.getCommunity();
        InetAddress add = null;
        try {
            add = InetAddress.getByName(this.getHname());
        }
        catch (UnknownHostException e) {
            if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_LOGGER.logp(Level.FINEST, Host.class.getName(), "buildTrapEntries", "Cannot create TRAP entry; got exception", e);
            }
            return;
        }
        Vector<Object> list = null;
        if (dest.containsKey(add)) {
            list = dest.get(add);
            if (!list.contains(comm)) {
                list.addElement(comm);
            }
        } else {
            list = new Vector();
            list.addElement(comm);
            dest.put(add, list);
        }
    }

    @Override
    public void buildInformEntries(Hashtable<InetAddress, Vector<String>> dest) {
        JDMHostInform host = (JDMHostInform)this.jjtGetParent();
        JDMInformInterestedHost hosts = (JDMInformInterestedHost)host.jjtGetParent();
        JDMInformItem inform = (JDMInformItem)hosts.jjtGetParent();
        JDMInformCommunity community = inform.getCommunity();
        String comm = community.getCommunity();
        InetAddress add = null;
        try {
            add = InetAddress.getByName(this.getHname());
        }
        catch (UnknownHostException e) {
            if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_LOGGER.logp(Level.FINEST, Host.class.getName(), "buildTrapEntries", "Cannot create INFORM entry; got exception", e);
            }
            return;
        }
        Vector<Object> list = null;
        if (dest.containsKey(add)) {
            list = dest.get(add);
            if (!list.contains(comm)) {
                list.addElement(comm);
            }
        } else {
            list = new Vector();
            list.addElement(comm);
            dest.put(add, list);
        }
    }
}

