/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp;

import com.sun.jmx.snmp.BerException;

public class BerDecoder {
    public static final int BooleanTag = 1;
    public static final int IntegerTag = 2;
    public static final int OctetStringTag = 4;
    public static final int NullTag = 5;
    public static final int OidTag = 6;
    public static final int SequenceTag = 48;
    private final byte[] bytes;
    private int next = 0;
    private final int[] stackBuf = new int[200];
    private int stackTop = 0;

    public BerDecoder(byte[] b) {
        this.bytes = b;
        this.reset();
    }

    public void reset() {
        this.next = 0;
        this.stackTop = 0;
    }

    public int fetchInteger() throws BerException {
        return this.fetchInteger(2);
    }

    public int fetchInteger(int tag) throws BerException {
        int result = 0;
        int backup = this.next;
        try {
            if (this.fetchTag() != tag) {
                throw new BerException();
            }
            result = this.fetchIntegerValue();
        }
        catch (BerException e) {
            this.next = backup;
            throw e;
        }
        return result;
    }

    public long fetchIntegerAsLong() throws BerException {
        return this.fetchIntegerAsLong(2);
    }

    public long fetchIntegerAsLong(int tag) throws BerException {
        long result = 0L;
        int backup = this.next;
        try {
            if (this.fetchTag() != tag) {
                throw new BerException();
            }
            result = this.fetchIntegerValueAsLong();
        }
        catch (BerException e) {
            this.next = backup;
            throw e;
        }
        return result;
    }

    public byte[] fetchOctetString() throws BerException {
        return this.fetchOctetString(4);
    }

    public byte[] fetchOctetString(int tag) throws BerException {
        byte[] result = null;
        int backup = this.next;
        try {
            if (this.fetchTag() != tag) {
                throw new BerException();
            }
            result = this.fetchStringValue();
        }
        catch (BerException e) {
            this.next = backup;
            throw e;
        }
        return result;
    }

    public long[] fetchOid() throws BerException {
        return this.fetchOid(6);
    }

    public long[] fetchOid(int tag) throws BerException {
        long[] result = null;
        int backup = this.next;
        try {
            if (this.fetchTag() != tag) {
                throw new BerException();
            }
            result = this.fetchOidValue();
        }
        catch (BerException e) {
            this.next = backup;
            throw e;
        }
        return result;
    }

    public void fetchNull() throws BerException {
        this.fetchNull(5);
    }

    public void fetchNull(int tag) throws BerException {
        int backup = this.next;
        try {
            if (this.fetchTag() != tag) {
                throw new BerException();
            }
            int length = this.fetchLength();
            if (length != 0) {
                throw new BerException();
            }
        }
        catch (BerException e) {
            this.next = backup;
            throw e;
        }
    }

    public byte[] fetchAny() throws BerException {
        byte[] result = null;
        int backup = this.next;
        try {
            int tag = this.fetchTag();
            int contentLength = this.fetchLength();
            if (contentLength < 0) {
                throw new BerException();
            }
            int tlvLength = this.next + contentLength - backup;
            if (contentLength > this.bytes.length - this.next) {
                throw new IndexOutOfBoundsException("Decoded length exceeds buffer");
            }
            byte[] data = new byte[tlvLength];
            System.arraycopy(this.bytes, backup, data, 0, tlvLength);
            this.next += contentLength;
            result = data;
        }
        catch (IndexOutOfBoundsException e) {
            this.next = backup;
            throw new BerException();
        }
        return result;
    }

    public byte[] fetchAny(int tag) throws BerException {
        if (this.getTag() != tag) {
            throw new BerException();
        }
        return this.fetchAny();
    }

    public void openSequence() throws BerException {
        this.openSequence(48);
    }

    public void openSequence(int tag) throws BerException {
        int backup = this.next;
        try {
            if (this.fetchTag() != tag) {
                throw new BerException();
            }
            int l = this.fetchLength();
            if (l < 0) {
                throw new BerException();
            }
            if (l > this.bytes.length - this.next) {
                throw new BerException();
            }
            this.stackBuf[this.stackTop++] = this.next + l;
        }
        catch (BerException e) {
            this.next = backup;
            throw e;
        }
    }

    public void closeSequence() throws BerException {
        if (this.stackBuf[this.stackTop - 1] == this.next) {
            --this.stackTop;
        } else {
            throw new BerException();
        }
    }

    public boolean cannotCloseSequence() {
        return this.next < this.stackBuf[this.stackTop - 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTag() throws BerException {
        int result = 0;
        int backup = this.next;
        try {
            result = this.fetchTag();
        }
        finally {
            this.next = backup;
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.bytes.length * 2);
        for (int i = 0; i < this.bytes.length; ++i) {
            int b;
            int n = b = this.bytes[i] > 0 ? this.bytes[i] : this.bytes[i] + 256;
            if (i == this.next) {
                result.append("(");
            }
            result.append(Character.forDigit(b / 16, 16));
            result.append(Character.forDigit(b % 16, 16));
            if (i != this.next) continue;
            result.append(")");
        }
        if (this.bytes.length == this.next) {
            result.append("()");
        }
        return new String(result);
    }

    private final int fetchTag() throws BerException {
        int result = 0;
        int backup = this.next;
        try {
            int b0 = this.bytes[this.next++];
            int n = result = b0 >= 0 ? b0 : b0 + 256;
            if ((result & 0x1F) == 31) {
                while ((this.bytes[this.next] & 0x80) != 0) {
                    result <<= 7;
                    result |= this.bytes[this.next++] & 0x7F;
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            this.next = backup;
            throw new BerException();
        }
        return result;
    }

    private final int fetchLength() throws BerException {
        int result = 0;
        int backup = this.next;
        try {
            int b0 = this.bytes[this.next++];
            if (b0 >= 0) {
                result = b0;
            } else {
                for (int c = 128 + b0; c > 0; --c) {
                    int bX = this.bytes[this.next++];
                    result <<= 8;
                    result |= bX >= 0 ? bX : bX + 256;
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            this.next = backup;
            throw new BerException();
        }
        return result;
    }

    private int fetchIntegerValue() throws BerException {
        int result = 0;
        int backup = this.next;
        try {
            int length = this.fetchLength();
            if (length <= 0) {
                throw new BerException();
            }
            if (length > this.bytes.length - this.next) {
                throw new IndexOutOfBoundsException("Decoded length exceeds buffer");
            }
            int end = this.next + length;
            result = this.bytes[this.next++];
            while (this.next < end) {
                byte b;
                if ((b = this.bytes[this.next++]) < 0) {
                    result = result << 8 | 256 + b;
                    continue;
                }
                result = result << 8 | b;
            }
        }
        catch (BerException e) {
            this.next = backup;
            throw e;
        }
        catch (IndexOutOfBoundsException e) {
            this.next = backup;
            throw new BerException();
        }
        catch (ArithmeticException e) {
            this.next = backup;
            throw new BerException();
        }
        return result;
    }

    private final long fetchIntegerValueAsLong() throws BerException {
        long result = 0L;
        int backup = this.next;
        try {
            int length = this.fetchLength();
            if (length <= 0) {
                throw new BerException();
            }
            if (length > this.bytes.length - this.next) {
                throw new IndexOutOfBoundsException("Decoded length exceeds buffer");
            }
            int end = this.next + length;
            result = this.bytes[this.next++];
            while (this.next < end) {
                byte b;
                if ((b = this.bytes[this.next++]) < 0) {
                    result = result << 8 | (long)(256 + b);
                    continue;
                }
                result = result << 8 | (long)b;
            }
        }
        catch (BerException e) {
            this.next = backup;
            throw e;
        }
        catch (IndexOutOfBoundsException e) {
            this.next = backup;
            throw new BerException();
        }
        catch (ArithmeticException e) {
            this.next = backup;
            throw new BerException();
        }
        return result;
    }

    private byte[] fetchStringValue() throws BerException {
        byte[] result = null;
        int backup = this.next;
        try {
            int length = this.fetchLength();
            if (length < 0) {
                throw new BerException();
            }
            if (length > this.bytes.length - this.next) {
                throw new IndexOutOfBoundsException("Decoded length exceeds buffer");
            }
            byte[] data = new byte[length];
            System.arraycopy(this.bytes, this.next, data, 0, length);
            this.next += length;
            result = data;
        }
        catch (BerException e) {
            this.next = backup;
            throw e;
        }
        catch (IndexOutOfBoundsException e) {
            this.next = backup;
            throw new BerException();
        }
        catch (ArithmeticException e) {
            this.next = backup;
            throw new BerException();
        }
        return result;
    }

    private final long[] fetchOidValue() throws BerException {
        long[] result = null;
        int backup = this.next;
        try {
            byte b0;
            int length = this.fetchLength();
            if (length <= 0) {
                throw new BerException();
            }
            if (length > this.bytes.length - this.next) {
                throw new IndexOutOfBoundsException("Decoded length exceeds buffer");
            }
            int subidCount = 2;
            for (int i = 1; i < length; ++i) {
                if ((this.bytes[this.next + i] & 0x80) != 0) continue;
                ++subidCount;
            }
            int datalen = subidCount;
            long[] data = new long[datalen];
            if ((b0 = this.bytes[this.next++]) < 0) {
                throw new BerException();
            }
            long lb0 = b0 / 40;
            if (lb0 > 2L) {
                throw new BerException();
            }
            long lb1 = b0 % 40;
            data[0] = lb0;
            data[1] = lb1;
            int i = 2;
            while (i < datalen) {
                long subid = 0L;
                byte b = this.bytes[this.next++];
                while ((b & 0x80) != 0) {
                    if ((subid = subid << 7 | (long)(b & 0x7F)) < 0L) {
                        throw new BerException();
                    }
                    b = this.bytes[this.next++];
                }
                if ((subid = subid << 7 | (long)b) < 0L) {
                    throw new BerException();
                }
                data[i++] = subid;
            }
            result = data;
        }
        catch (BerException e) {
            this.next = backup;
            throw e;
        }
        catch (IndexOutOfBoundsException e) {
            this.next = backup;
            throw new BerException();
        }
        return result;
    }
}

