/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.FeedbackCipher;
import com.sun.crypto.provider.SymmetricCipher;
import java.security.InvalidKeyException;

final class CipherFeedback
extends FeedbackCipher {
    private final byte[] k;
    private final byte[] register;
    private int numBytes;
    private byte[] registerSave = null;

    CipherFeedback(SymmetricCipher embeddedCipher, int numBytes) {
        super(embeddedCipher);
        if (numBytes > this.blockSize) {
            numBytes = this.blockSize;
        }
        this.numBytes = numBytes;
        this.k = new byte[this.blockSize];
        this.register = new byte[this.blockSize];
    }

    String getFeedback() {
        return "CFB";
    }

    void init(boolean decrypting, String algorithm, byte[] key, byte[] iv) throws InvalidKeyException {
        if (key == null || iv == null || iv.length != this.blockSize) {
            throw new InvalidKeyException("Internal error");
        }
        this.iv = iv;
        this.reset();
        this.embeddedCipher.init(false, algorithm, key);
    }

    void reset() {
        System.arraycopy(this.iv, 0, this.register, 0, this.blockSize);
    }

    void save() {
        if (this.registerSave == null) {
            this.registerSave = new byte[this.blockSize];
        }
        System.arraycopy(this.register, 0, this.registerSave, 0, this.blockSize);
    }

    void restore() {
        System.arraycopy(this.registerSave, 0, this.register, 0, this.blockSize);
    }

    void encrypt(byte[] plain, int plainOffset, int plainLen, byte[] cipher, int cipherOffset) {
        block8: {
            int i;
            int loopCount;
            int oddBytes;
            int len;
            block7: {
                int i2;
                len = this.blockSize - this.numBytes;
                oddBytes = plainLen % this.numBytes;
                if (len != 0) break block7;
                for (loopCount = plainLen / this.numBytes; loopCount > 0; --loopCount) {
                    this.embeddedCipher.encryptBlock(this.register, 0, this.k, 0);
                    for (i2 = 0; i2 < this.blockSize; ++i2) {
                        byte by = (byte)(this.k[i2] ^ plain[i2 + plainOffset]);
                        cipher[i2 + cipherOffset] = by;
                        this.register[i2] = by;
                    }
                    plainOffset += this.numBytes;
                    cipherOffset += this.numBytes;
                }
                if (oddBytes <= 0) break block8;
                this.embeddedCipher.encryptBlock(this.register, 0, this.k, 0);
                for (i2 = 0; i2 < oddBytes; ++i2) {
                    byte by = (byte)(this.k[i2] ^ plain[i2 + plainOffset]);
                    cipher[i2 + cipherOffset] = by;
                    this.register[i2] = by;
                }
                break block8;
            }
            while (loopCount > 0) {
                this.embeddedCipher.encryptBlock(this.register, 0, this.k, 0);
                System.arraycopy(this.register, this.numBytes, this.register, 0, len);
                for (i = 0; i < this.numBytes; ++i) {
                    byte by = (byte)(this.k[i] ^ plain[i + plainOffset]);
                    cipher[i + cipherOffset] = by;
                    this.register[i + len] = by;
                }
                plainOffset += this.numBytes;
                cipherOffset += this.numBytes;
                --loopCount;
            }
            if (oddBytes != 0) {
                this.embeddedCipher.encryptBlock(this.register, 0, this.k, 0);
                System.arraycopy(this.register, this.numBytes, this.register, 0, len);
                for (i = 0; i < oddBytes; ++i) {
                    byte by = (byte)(this.k[i] ^ plain[i + plainOffset]);
                    cipher[i + cipherOffset] = by;
                    this.register[i + len] = by;
                }
            }
        }
    }

    void decrypt(byte[] cipher, int cipherOffset, int cipherLen, byte[] plain, int plainOffset) {
        block8: {
            int i;
            int loopCount;
            int oddBytes;
            int len;
            block7: {
                int i2;
                len = this.blockSize - this.numBytes;
                oddBytes = cipherLen % this.numBytes;
                if (len != 0) break block7;
                for (loopCount = cipherLen / this.numBytes; loopCount > 0; --loopCount) {
                    this.embeddedCipher.encryptBlock(this.register, 0, this.k, 0);
                    for (i2 = 0; i2 < this.blockSize; ++i2) {
                        this.register[i2] = cipher[i2 + cipherOffset];
                        plain[i2 + plainOffset] = (byte)(cipher[i2 + cipherOffset] ^ this.k[i2]);
                    }
                    plainOffset += this.numBytes;
                    cipherOffset += this.numBytes;
                }
                if (oddBytes <= 0) break block8;
                this.embeddedCipher.encryptBlock(this.register, 0, this.k, 0);
                for (i2 = 0; i2 < oddBytes; ++i2) {
                    this.register[i2] = cipher[i2 + cipherOffset];
                    plain[i2 + plainOffset] = (byte)(cipher[i2 + cipherOffset] ^ this.k[i2]);
                }
                break block8;
            }
            while (loopCount > 0) {
                this.embeddedCipher.encryptBlock(this.register, 0, this.k, 0);
                System.arraycopy(this.register, this.numBytes, this.register, 0, len);
                for (i = 0; i < this.numBytes; ++i) {
                    this.register[i + len] = cipher[i + cipherOffset];
                    plain[i + plainOffset] = (byte)(cipher[i + cipherOffset] ^ this.k[i]);
                }
                plainOffset += this.numBytes;
                cipherOffset += this.numBytes;
                --loopCount;
            }
            if (oddBytes != 0) {
                this.embeddedCipher.encryptBlock(this.register, 0, this.k, 0);
                System.arraycopy(this.register, this.numBytes, this.register, 0, len);
                for (i = 0; i < oddBytes; ++i) {
                    this.register[i + len] = cipher[i + cipherOffset];
                    plain[i + plainOffset] = (byte)(cipher[i + cipherOffset] ^ this.k[i]);
                }
            }
        }
    }
}

