/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import com.sun.management.OperatingSystemMXBean;
import java.awt.BorderLayout;
import java.io.IOException;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.UndeclaredThrowableException;
import java.text.DateFormat;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import sun.tools.jconsole.Formatter;
import sun.tools.jconsole.HTMLPane;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.OverviewPanel;
import sun.tools.jconsole.Plotter;
import sun.tools.jconsole.ProxyClient;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.Tab;
import sun.tools.jconsole.Utilities;
import sun.tools.jconsole.VMPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SummaryTab
extends Tab {
    private static final String cpuUsageKey = "cpu";
    private static final String cpuUsageName = Resources.getText("CPU Usage", new Object[0]);
    private static final String cpuUsageFormat = "CPUUsageFormat";
    private static final String newDivider = "<tr><td colspan=4><font size =-1><hr>";
    private static final String newTable = "<tr><td colspan=4 align=left><table cellpadding=1>";
    private static final String newLeftTable = "<tr><td colspan=2 align=left><table cellpadding=1>";
    private static final String newRightTable = "<td colspan=2 align=left><table cellpadding=1>";
    private static final String endTable = "</table>";
    private static final int CPU_DECIMALS = 1;
    private CPUOverviewPanel overviewPanel;
    private DateFormat headerDateTimeFormat;
    private String pathSeparator = null;
    HTMLPane info;
    StringBuilder buf;

    public static String getTabName() {
        return Resources.getText("SummaryTab.tabName", new Object[0]);
    }

    public SummaryTab(VMPanel vmPanel) {
        super(vmPanel, SummaryTab.getTabName());
        this.setLayout(new BorderLayout());
        this.info = new HTMLPane();
        Utilities.setAccessibleName(this.info, SummaryTab.getTabName());
        this.add(new JScrollPane(this.info));
        this.headerDateTimeFormat = Formatter.getDateTimeFormat("SummaryTab.headerDateTimeFormat");
    }

    @Override
    public SwingWorker<?, ?> newSwingWorker() {
        return new SwingWorker<Result, Object>(){

            @Override
            public Result doInBackground() {
                return SummaryTab.this.formatSummary();
            }

            @Override
            protected void done() {
                block5: {
                    try {
                        Result result = (Result)this.get();
                        if (result != null) {
                            SummaryTab.this.info.setText(result.summary);
                            if (SummaryTab.this.overviewPanel != null && result.upTime > 0L && result.processCpuTime >= 0L) {
                                SummaryTab.this.overviewPanel.updateCPUInfo(result);
                            }
                        }
                    }
                    catch (InterruptedException ex) {
                    }
                    catch (ExecutionException ex) {
                        if (!JConsole.isDebug()) break block5;
                        ex.printStackTrace();
                    }
                }
            }
        };
    }

    synchronized Result formatSummary() {
        Result result = new Result();
        ProxyClient proxyClient = this.vmPanel.getProxyClient();
        if (proxyClient.isDead()) {
            return null;
        }
        this.buf = new StringBuilder();
        this.append("<table cellpadding=1>");
        try {
            RuntimeMXBean rmBean = proxyClient.getRuntimeMXBean();
            CompilationMXBean cmpMBean = proxyClient.getCompilationMXBean();
            ThreadMXBean tmBean = proxyClient.getThreadMXBean();
            MemoryMXBean memoryBean = proxyClient.getMemoryMXBean();
            ClassLoadingMXBean clMBean = proxyClient.getClassLoadingMXBean();
            java.lang.management.OperatingSystemMXBean osMBean = proxyClient.getOperatingSystemMXBean();
            OperatingSystemMXBean sunOSMBean = proxyClient.getSunOperatingSystemMXBean();
            this.append("<tr><td colspan=4>");
            this.append("<center><b>" + Resources.getText("SummaryTab.tabName", new Object[0]) + "</b></center>");
            String dateTime = this.headerDateTimeFormat.format(System.currentTimeMillis());
            this.append("<center>" + dateTime + "</center>");
            this.append(newDivider);
            this.append(newLeftTable);
            this.append("Connection name", this.vmPanel.getDisplayName());
            this.append("Virtual Machine", Resources.getText("SummaryTab.vmVersion", rmBean.getVmName(), rmBean.getVmVersion()));
            this.append("Vendor", rmBean.getVmVendor());
            this.append("Name", rmBean.getName());
            this.append(endTable);
            this.append(newRightTable);
            result.upTime = rmBean.getUptime();
            this.append("Uptime", Formatter.formatTime(result.upTime));
            if (sunOSMBean != null) {
                result.processCpuTime = sunOSMBean.getProcessCpuTime();
                this.append("Process CPU time", Formatter.formatNanoTime(result.processCpuTime));
            }
            if (cmpMBean != null) {
                this.append("JIT compiler", cmpMBean.getName());
                this.append("Total compile time", cmpMBean.isCompilationTimeMonitoringSupported() ? Formatter.formatTime(cmpMBean.getTotalCompilationTime()) : Resources.getText("Unavailable", new Object[0]));
            } else {
                this.append("JIT compiler", Resources.getText("Unavailable", new Object[0]));
            }
            this.append(endTable);
            this.append(newDivider);
            this.append(newLeftTable);
            int tlCount = tmBean.getThreadCount();
            int tdCount = tmBean.getDaemonThreadCount();
            int tpCount = tmBean.getPeakThreadCount();
            long ttCount = tmBean.getTotalStartedThreadCount();
            String[] strings1 = Formatter.formatLongs(tlCount, tpCount, tdCount, ttCount);
            this.append("Live Threads", strings1[0]);
            this.append("Peak", strings1[1]);
            this.append("Daemon threads", strings1[2]);
            this.append("Total threads started", strings1[3]);
            this.append(endTable);
            this.append(newRightTable);
            long clCount = clMBean.getLoadedClassCount();
            long cuCount = clMBean.getUnloadedClassCount();
            long ctCount = clMBean.getTotalLoadedClassCount();
            String[] strings2 = Formatter.formatLongs(clCount, cuCount, ctCount);
            this.append("Current classes loaded", strings2[0]);
            this.append("Total classes loaded", strings2[2]);
            this.append("Total classes unloaded", strings2[1]);
            this.append(null, "");
            this.append(endTable);
            this.append(newDivider);
            MemoryUsage u = memoryBean.getHeapMemoryUsage();
            this.append(newLeftTable);
            String[] strings12 = Formatter.formatKByteStrings(u.getUsed(), u.getMax());
            this.append("Current heap size", strings12[0]);
            this.append("Maximum heap size", strings12[1]);
            this.append(endTable);
            this.append(newRightTable);
            String[] strings22 = Formatter.formatKByteStrings(u.getCommitted());
            this.append("Committed memory", strings22[0]);
            this.append("SummaryTab.pendingFinalization.label", Resources.getText("SummaryTab.pendingFinalization.value", memoryBean.getObjectPendingFinalizationCount()));
            this.append(endTable);
            this.append(newTable);
            Collection<GarbageCollectorMXBean> garbageCollectors = proxyClient.getGarbageCollectorMXBeans();
            for (GarbageCollectorMXBean garbageCollectorMBean : garbageCollectors) {
                String gcName = garbageCollectorMBean.getName();
                long gcCount = garbageCollectorMBean.getCollectionCount();
                long gcTime = garbageCollectorMBean.getCollectionTime();
                this.append("Garbage collector", Resources.getText("GcInfo", gcName, gcCount, gcTime >= 0L ? Formatter.formatTime(gcTime) : Resources.getText("Unavailable", new Object[0])), 4);
            }
            this.append(endTable);
            this.append(newDivider);
            this.append(newLeftTable);
            String osName = osMBean.getName();
            String osVersion = osMBean.getVersion();
            String osArch = osMBean.getArch();
            result.nCPUs = osMBean.getAvailableProcessors();
            this.append("Operating System", osName + " " + osVersion);
            this.append("Architecture", osArch);
            this.append("Number of processors", result.nCPUs + "");
            if (this.pathSeparator == null) {
                String string = this.pathSeparator = osName.startsWith("Windows ") ? ";" : ":";
            }
            if (sunOSMBean != null) {
                String[] kbStrings1 = Formatter.formatKByteStrings(sunOSMBean.getCommittedVirtualMemorySize());
                String[] kbStrings2 = Formatter.formatKByteStrings(sunOSMBean.getTotalPhysicalMemorySize(), sunOSMBean.getFreePhysicalMemorySize(), sunOSMBean.getTotalSwapSpaceSize(), sunOSMBean.getFreeSwapSpaceSize());
                this.append("Committed virtual memory", kbStrings1[0]);
                this.append(endTable);
                this.append(newRightTable);
                this.append("Total physical memory", kbStrings2[0]);
                this.append("Free physical memory", kbStrings2[1]);
                this.append("Total swap space", kbStrings2[2]);
                this.append("Free swap space", kbStrings2[3]);
            }
            this.append(endTable);
            this.append(newDivider);
            this.append(newTable);
            String args = "";
            List<String> inputArguments = rmBean.getInputArguments();
            for (String arg : inputArguments) {
                args = args + arg + " ";
            }
            this.append("VM arguments", args, 4);
            this.append("Class path", rmBean.getClassPath(), 4);
            this.append("Library path", rmBean.getLibraryPath(), 4);
            this.append("Boot class path", rmBean.isBootClassPathSupported() ? rmBean.getBootClassPath() : Resources.getText("Unavailable", new Object[0]), 4);
            this.append(endTable);
        }
        catch (IOException e) {
            if (JConsole.isDebug()) {
                e.printStackTrace();
            }
            proxyClient.markAsDead();
            return null;
        }
        catch (UndeclaredThrowableException e) {
            if (JConsole.isDebug()) {
                e.printStackTrace();
            }
            proxyClient.markAsDead();
            return null;
        }
        this.append(endTable);
        result.timeStamp = System.currentTimeMillis();
        result.summary = this.buf.toString();
        return result;
    }

    private synchronized void append(String str) {
        this.buf.append(str);
    }

    void append(String label, String value) {
        this.append(Formatter.newRow(label != null ? Resources.getText(label, new Object[0]) : label, value));
    }

    private void append(String label, String value, int columnPerRow) {
        if (columnPerRow == 4 && this.pathSeparator != null) {
            value = value.replace(this.pathSeparator, "<b></b>" + this.pathSeparator);
        }
        this.append(Formatter.newRow(Resources.getText(label, new Object[0]), value, columnPerRow));
    }

    void append(String label1, String value1, String label2, String value2) {
        this.append(Formatter.newRow(Resources.getText(label1, new Object[0]), value1, Resources.getText(label2, new Object[0]), value2));
    }

    @Override
    OverviewPanel[] getOverviewPanels() {
        if (this.overviewPanel == null) {
            this.overviewPanel = new CPUOverviewPanel();
        }
        return new OverviewPanel[]{this.overviewPanel};
    }

    private static class CPUOverviewPanel
    extends OverviewPanel {
        private long prevUpTime;
        private long prevProcessCpuTime;

        CPUOverviewPanel() {
            super(Resources.getText("CPU Usage", new Object[0]), SummaryTab.cpuUsageKey, cpuUsageName, Plotter.Unit.PERCENT);
            this.getPlotter().setDecimals(1);
        }

        public void updateCPUInfo(Result result) {
            if (this.prevUpTime > 0L && result.upTime > this.prevUpTime) {
                long elapsedCpu = result.processCpuTime - this.prevProcessCpuTime;
                long elapsedTime = result.upTime - this.prevUpTime;
                float cpuUsage = Math.min(99.0f, (float)elapsedCpu / ((float)elapsedTime * 10000.0f * (float)result.nCPUs));
                this.getPlotter().addValues(result.timeStamp, Math.round((double)cpuUsage * Math.pow(10.0, 1.0)));
                this.getInfoLabel().setText(Resources.getText(SummaryTab.cpuUsageFormat, String.format("%.1f", Float.valueOf(cpuUsage))));
            }
            this.prevUpTime = result.upTime;
            this.prevProcessCpuTime = result.processCpuTime;
        }
    }

    private static class Result {
        long upTime = -1L;
        long processCpuTime = -1L;
        long timeStamp;
        int nCPUs;
        String summary;

        private Result() {
        }
    }
}

