/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.cmm.lcms;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import sun.java2d.cmm.ColorTransform;
import sun.java2d.cmm.ProfileDeferralMgr;
import sun.java2d.cmm.lcms.LCMS;
import sun.java2d.cmm.lcms.LCMSImageLayout;

public class LCMSTransform
implements ColorTransform {
    long ID;
    ICC_Profile[] profiles;
    long[] profileIDs;
    int renderType;
    int transformType;
    private Object disposerReferent = new Object();

    public LCMSTransform(ICC_Profile profile, int renderType, int transformType) {
        this.profiles = new ICC_Profile[1];
        this.profiles[0] = profile;
        this.profileIDs = new long[1];
        this.profileIDs[0] = LCMS.getProfileID(profile);
        this.renderType = renderType == -1 ? 0 : renderType;
        this.transformType = transformType;
    }

    public LCMSTransform(ColorTransform[] transforms) {
        int size = 0;
        for (int i = 0; i < transforms.length; ++i) {
            size += ((LCMSTransform)transforms[i]).profiles.length;
        }
        this.profiles = new ICC_Profile[size];
        this.profileIDs = new long[size];
        int j = 0;
        for (int i = 0; i < transforms.length; ++i) {
            LCMSTransform curTrans = (LCMSTransform)transforms[i];
            System.arraycopy(curTrans.profiles, 0, this.profiles, j, curTrans.profiles.length);
            System.arraycopy(curTrans.profileIDs, 0, this.profileIDs, j, curTrans.profileIDs.length);
            j += curTrans.profiles.length;
        }
        this.renderType = ((LCMSTransform)transforms[0]).renderType;
        this.ID = LCMS.createNativeTransform(this.profileIDs, this.renderType, this.disposerReferent);
    }

    public int getNumInComponents() {
        return this.profiles[0].getNumComponents();
    }

    public int getNumOutComponents() {
        return this.profiles[this.profiles.length - 1].getNumComponents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void colorConvert(BufferedImage src, BufferedImage dst) {
        int i;
        if (LCMSImageLayout.isSupported(src) && LCMSImageLayout.isSupported(dst)) {
            LCMSTransform lCMSTransform = this;
            synchronized (lCMSTransform) {
                LCMS.colorConvert(this, new LCMSImageLayout(src), new LCMSImageLayout(dst));
            }
            return;
        }
        WritableRaster srcRas = src.getRaster();
        WritableRaster dstRas = dst.getRaster();
        ColorModel srcCM = src.getColorModel();
        ColorModel dstCM = dst.getColorModel();
        int w = src.getWidth();
        int h = src.getHeight();
        int srcNumComp = srcCM.getNumColorComponents();
        int dstNumComp = dstCM.getNumColorComponents();
        int precision = 8;
        float maxNum = 255.0f;
        for (i = 0; i < srcNumComp; ++i) {
            if (srcCM.getComponentSize(i) <= 8) continue;
            precision = 16;
            maxNum = 65535.0f;
        }
        for (i = 0; i < dstNumComp; ++i) {
            if (dstCM.getComponentSize(i) <= 8) continue;
            precision = 16;
            maxNum = 65535.0f;
        }
        float[] srcMinVal = new float[srcNumComp];
        float[] srcInvDiffMinMax = new float[srcNumComp];
        ColorSpace cs = srcCM.getColorSpace();
        for (int i2 = 0; i2 < srcNumComp; ++i2) {
            srcMinVal[i2] = cs.getMinValue(i2);
            srcInvDiffMinMax[i2] = maxNum / (cs.getMaxValue(i2) - srcMinVal[i2]);
        }
        cs = dstCM.getColorSpace();
        float[] dstMinVal = new float[dstNumComp];
        float[] dstDiffMinMax = new float[dstNumComp];
        for (int i3 = 0; i3 < dstNumComp; ++i3) {
            dstMinVal[i3] = cs.getMinValue(i3);
            dstDiffMinMax[i3] = (cs.getMaxValue(i3) - dstMinVal[i3]) / maxNum;
        }
        boolean dstHasAlpha = dstCM.hasAlpha();
        boolean needSrcAlpha = srcCM.hasAlpha() && dstHasAlpha;
        float[] dstColor = dstHasAlpha ? new float[dstNumComp + 1] : new float[dstNumComp];
        if (precision == 8) {
            byte[] srcLine = new byte[w * srcNumComp];
            byte[] dstLine = new byte[w * dstNumComp];
            float[] alpha = null;
            if (needSrcAlpha) {
                alpha = new float[w];
            }
            LCMSImageLayout srcIL = new LCMSImageLayout(srcLine, srcLine.length / this.getNumInComponents(), LCMSImageLayout.CHANNELS_SH(this.getNumInComponents()) | LCMSImageLayout.BYTES_SH(1), this.getNumInComponents());
            LCMSImageLayout dstIL = new LCMSImageLayout(dstLine, dstLine.length / this.getNumOutComponents(), LCMSImageLayout.CHANNELS_SH(this.getNumOutComponents()) | LCMSImageLayout.BYTES_SH(1), this.getNumOutComponents());
            for (int y = 0; y < h; ++y) {
                int i4;
                int x2;
                Object pixel = null;
                float[] color = null;
                int idx = 0;
                for (x2 = 0; x2 < w; ++x2) {
                    pixel = srcRas.getDataElements(x2, y, pixel);
                    color = srcCM.getNormalizedComponents(pixel, color, 0);
                    for (i4 = 0; i4 < srcNumComp; ++i4) {
                        srcLine[idx++] = (byte)((color[i4] - srcMinVal[i4]) * srcInvDiffMinMax[i4] + 0.5f);
                    }
                    if (!needSrcAlpha) continue;
                    alpha[x2] = color[srcNumComp];
                }
                LCMSTransform x2 = this;
                synchronized (x2) {
                    LCMS.colorConvert(this, srcIL, dstIL);
                }
                pixel = null;
                idx = 0;
                for (x2 = 0; x2 < w; ++x2) {
                    for (i4 = 0; i4 < dstNumComp; ++i4) {
                        dstColor[i4] = (float)(dstLine[idx++] & 0xFF) * dstDiffMinMax[i4] + dstMinVal[i4];
                    }
                    if (needSrcAlpha) {
                        dstColor[dstNumComp] = alpha[x2];
                    } else if (dstHasAlpha) {
                        dstColor[dstNumComp] = 1.0f;
                    }
                    pixel = dstCM.getDataElements(dstColor, 0, pixel);
                    dstRas.setDataElements(x2, y, pixel);
                }
            }
        } else {
            short[] srcLine = new short[w * srcNumComp];
            short[] dstLine = new short[w * dstNumComp];
            float[] alpha = null;
            if (needSrcAlpha) {
                alpha = new float[w];
            }
            LCMSImageLayout srcIL = new LCMSImageLayout(srcLine, srcLine.length / this.getNumInComponents(), LCMSImageLayout.CHANNELS_SH(this.getNumInComponents()) | LCMSImageLayout.BYTES_SH(2), this.getNumInComponents() * 2);
            LCMSImageLayout dstIL = new LCMSImageLayout(dstLine, dstLine.length / this.getNumOutComponents(), LCMSImageLayout.CHANNELS_SH(this.getNumOutComponents()) | LCMSImageLayout.BYTES_SH(2), this.getNumOutComponents() * 2);
            for (int y = 0; y < h; ++y) {
                int i5;
                int x3;
                Object pixel = null;
                float[] color = null;
                int idx = 0;
                for (x3 = 0; x3 < w; ++x3) {
                    pixel = srcRas.getDataElements(x3, y, pixel);
                    color = srcCM.getNormalizedComponents(pixel, color, 0);
                    for (i5 = 0; i5 < srcNumComp; ++i5) {
                        srcLine[idx++] = (short)((color[i5] - srcMinVal[i5]) * srcInvDiffMinMax[i5] + 0.5f);
                    }
                    if (!needSrcAlpha) continue;
                    alpha[x3] = color[srcNumComp];
                }
                LCMSTransform x3 = this;
                synchronized (x3) {
                    LCMS.colorConvert(this, srcIL, dstIL);
                }
                pixel = null;
                idx = 0;
                for (x3 = 0; x3 < w; ++x3) {
                    for (i5 = 0; i5 < dstNumComp; ++i5) {
                        dstColor[i5] = (float)(dstLine[idx++] & 0xFFFF) * dstDiffMinMax[i5] + dstMinVal[i5];
                    }
                    if (needSrcAlpha) {
                        dstColor[dstNumComp] = alpha[x3];
                    } else if (dstHasAlpha) {
                        dstColor[dstNumComp] = 1.0f;
                    }
                    pixel = dstCM.getDataElements(dstColor, 0, pixel);
                    dstRas.setDataElements(x3, y, pixel);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void colorConvert(Raster src, WritableRaster dst, float[] srcMinVal, float[] srcMaxVal, float[] dstMinVal, float[] dstMaxVal) {
        int i;
        SampleModel srcSM = src.getSampleModel();
        SampleModel dstSM = dst.getSampleModel();
        int srcTransferType = src.getTransferType();
        int dstTransferType = dst.getTransferType();
        boolean srcIsFloat = srcTransferType == 4 || srcTransferType == 5;
        boolean dstIsFloat = dstTransferType == 4 || dstTransferType == 5;
        int w = src.getWidth();
        int h = src.getHeight();
        int srcNumBands = src.getNumBands();
        int dstNumBands = dst.getNumBands();
        float[] srcScaleFactor = new float[srcNumBands];
        float[] dstScaleFactor = new float[dstNumBands];
        float[] srcUseMinVal = new float[srcNumBands];
        float[] dstUseMinVal = new float[dstNumBands];
        for (i = 0; i < srcNumBands; ++i) {
            if (srcIsFloat) {
                srcScaleFactor[i] = 65535.0f / (srcMaxVal[i] - srcMinVal[i]);
                srcUseMinVal[i] = srcMinVal[i];
                continue;
            }
            srcScaleFactor[i] = srcTransferType == 2 ? 2.0000305f : 65535.0f / (float)((1 << srcSM.getSampleSize(i)) - 1);
            srcUseMinVal[i] = 0.0f;
        }
        for (i = 0; i < dstNumBands; ++i) {
            if (dstIsFloat) {
                dstScaleFactor[i] = (dstMaxVal[i] - dstMinVal[i]) / 65535.0f;
                dstUseMinVal[i] = dstMinVal[i];
                continue;
            }
            dstScaleFactor[i] = dstTransferType == 2 ? 0.49999237f : (float)((1 << dstSM.getSampleSize(i)) - 1) / 65535.0f;
            dstUseMinVal[i] = 0.0f;
        }
        int ys = src.getMinY();
        int yd = dst.getMinY();
        short[] srcLine = new short[w * srcNumBands];
        short[] dstLine = new short[w * dstNumBands];
        LCMSImageLayout srcIL = new LCMSImageLayout(srcLine, srcLine.length / this.getNumInComponents(), LCMSImageLayout.CHANNELS_SH(this.getNumInComponents()) | LCMSImageLayout.BYTES_SH(2), this.getNumInComponents() * 2);
        LCMSImageLayout dstIL = new LCMSImageLayout(dstLine, dstLine.length / this.getNumOutComponents(), LCMSImageLayout.CHANNELS_SH(this.getNumOutComponents()) | LCMSImageLayout.BYTES_SH(2), this.getNumOutComponents() * 2);
        int y = 0;
        while (y < h) {
            float sample;
            int i2;
            int xs = src.getMinX();
            int idx = 0;
            int x32 = 0;
            while (x32 < w) {
                for (i2 = 0; i2 < srcNumBands; ++i2) {
                    sample = src.getSampleFloat(xs, ys, i2);
                    srcLine[idx++] = (short)((sample - srcUseMinVal[i2]) * srcScaleFactor[i2] + 0.5f);
                }
                ++x32;
                ++xs;
            }
            LCMSTransform x32 = this;
            synchronized (x32) {
                LCMS.colorConvert(this, srcIL, dstIL);
            }
            int xd = dst.getMinX();
            idx = 0;
            x32 = 0;
            while (x32 < w) {
                for (i2 = 0; i2 < dstNumBands; ++i2) {
                    sample = (float)(dstLine[idx++] & 0xFFFF) * dstScaleFactor[i2] + dstUseMinVal[i2];
                    dst.setSample(xd, yd, i2, sample);
                }
                ++x32;
                ++xd;
            }
            ++y;
            ++ys;
            ++yd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void colorConvert(Raster src, WritableRaster dst) {
        int i;
        int i2;
        SampleModel srcSM = src.getSampleModel();
        SampleModel dstSM = dst.getSampleModel();
        int srcTransferType = src.getTransferType();
        int dstTransferType = dst.getTransferType();
        int w = src.getWidth();
        int h = src.getHeight();
        int srcNumBands = src.getNumBands();
        int dstNumBands = dst.getNumBands();
        int precision = 8;
        float maxNum = 255.0f;
        for (i2 = 0; i2 < srcNumBands; ++i2) {
            if (srcSM.getSampleSize(i2) <= 8) continue;
            precision = 16;
            maxNum = 65535.0f;
        }
        for (i2 = 0; i2 < dstNumBands; ++i2) {
            if (dstSM.getSampleSize(i2) <= 8) continue;
            precision = 16;
            maxNum = 65535.0f;
        }
        float[] srcScaleFactor = new float[srcNumBands];
        float[] dstScaleFactor = new float[dstNumBands];
        for (i = 0; i < srcNumBands; ++i) {
            srcScaleFactor[i] = srcTransferType == 2 ? maxNum / 32767.0f : maxNum / (float)((1 << srcSM.getSampleSize(i)) - 1);
        }
        for (i = 0; i < dstNumBands; ++i) {
            dstScaleFactor[i] = dstTransferType == 2 ? 32767.0f / maxNum : (float)((1 << dstSM.getSampleSize(i)) - 1) / maxNum;
        }
        int ys = src.getMinY();
        int yd = dst.getMinY();
        if (precision == 8) {
            byte[] srcLine = new byte[w * srcNumBands];
            byte[] dstLine = new byte[w * dstNumBands];
            LCMSImageLayout srcIL = new LCMSImageLayout(srcLine, srcLine.length / this.getNumInComponents(), LCMSImageLayout.CHANNELS_SH(this.getNumInComponents()) | LCMSImageLayout.BYTES_SH(1), this.getNumInComponents());
            LCMSImageLayout dstIL = new LCMSImageLayout(dstLine, dstLine.length / this.getNumOutComponents(), LCMSImageLayout.CHANNELS_SH(this.getNumOutComponents()) | LCMSImageLayout.BYTES_SH(1), this.getNumOutComponents());
            int y = 0;
            while (y < h) {
                int sample;
                int i3;
                int xs = src.getMinX();
                int idx = 0;
                int x32 = 0;
                while (x32 < w) {
                    for (i3 = 0; i3 < srcNumBands; ++i3) {
                        sample = src.getSample(xs, ys, i3);
                        srcLine[idx++] = (byte)((float)sample * srcScaleFactor[i3] + 0.5f);
                    }
                    ++x32;
                    ++xs;
                }
                LCMSTransform x32 = this;
                synchronized (x32) {
                    LCMS.colorConvert(this, srcIL, dstIL);
                }
                int xd = dst.getMinX();
                idx = 0;
                x32 = 0;
                while (x32 < w) {
                    for (i3 = 0; i3 < dstNumBands; ++i3) {
                        sample = (int)((float)(dstLine[idx++] & 0xFF) * dstScaleFactor[i3] + 0.5f);
                        dst.setSample(xd, yd, i3, sample);
                    }
                    ++x32;
                    ++xd;
                }
                ++y;
                ++ys;
                ++yd;
            }
        } else {
            short[] srcLine = new short[w * srcNumBands];
            short[] dstLine = new short[w * dstNumBands];
            LCMSImageLayout srcIL = new LCMSImageLayout(srcLine, srcLine.length / this.getNumInComponents(), LCMSImageLayout.CHANNELS_SH(this.getNumInComponents()) | LCMSImageLayout.BYTES_SH(2), this.getNumInComponents() * 2);
            LCMSImageLayout dstIL = new LCMSImageLayout(dstLine, dstLine.length / this.getNumOutComponents(), LCMSImageLayout.CHANNELS_SH(this.getNumOutComponents()) | LCMSImageLayout.BYTES_SH(2), this.getNumOutComponents() * 2);
            int y = 0;
            while (y < h) {
                int sample;
                int i4;
                int xs = src.getMinX();
                int idx = 0;
                int x42 = 0;
                while (x42 < w) {
                    for (i4 = 0; i4 < srcNumBands; ++i4) {
                        sample = src.getSample(xs, ys, i4);
                        srcLine[idx++] = (short)((float)sample * srcScaleFactor[i4] + 0.5f);
                    }
                    ++x42;
                    ++xs;
                }
                LCMSTransform x42 = this;
                synchronized (x42) {
                    LCMS.colorConvert(this, srcIL, dstIL);
                }
                int xd = dst.getMinX();
                idx = 0;
                x42 = 0;
                while (x42 < w) {
                    for (i4 = 0; i4 < dstNumBands; ++i4) {
                        sample = (int)((float)(dstLine[idx++] & 0xFFFF) * dstScaleFactor[i4] + 0.5f);
                        dst.setSample(xd, yd, i4, sample);
                    }
                    ++x42;
                    ++xd;
                }
                ++y;
                ++ys;
                ++yd;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short[] colorConvert(short[] src, short[] dst) {
        if (dst == null) {
            dst = new short[src.length / this.getNumInComponents() * this.getNumOutComponents()];
        }
        LCMSImageLayout srcIL = new LCMSImageLayout(src, src.length / this.getNumInComponents(), LCMSImageLayout.CHANNELS_SH(this.getNumInComponents()) | LCMSImageLayout.BYTES_SH(2), this.getNumInComponents() * 2);
        LCMSImageLayout dstIL = new LCMSImageLayout(dst, dst.length / this.getNumOutComponents(), LCMSImageLayout.CHANNELS_SH(this.getNumOutComponents()) | LCMSImageLayout.BYTES_SH(2), this.getNumOutComponents() * 2);
        LCMSTransform lCMSTransform = this;
        synchronized (lCMSTransform) {
            LCMS.colorConvert(this, srcIL, dstIL);
        }
        return dst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] colorConvert(byte[] src, byte[] dst) {
        if (dst == null) {
            dst = new byte[src.length / this.getNumInComponents() * this.getNumOutComponents()];
        }
        LCMSImageLayout srcIL = new LCMSImageLayout(src, src.length / this.getNumInComponents(), LCMSImageLayout.CHANNELS_SH(this.getNumInComponents()) | LCMSImageLayout.BYTES_SH(1), this.getNumInComponents());
        LCMSImageLayout dstIL = new LCMSImageLayout(dst, dst.length / this.getNumOutComponents(), LCMSImageLayout.CHANNELS_SH(this.getNumOutComponents()) | LCMSImageLayout.BYTES_SH(1), this.getNumOutComponents());
        LCMSTransform lCMSTransform = this;
        synchronized (lCMSTransform) {
            LCMS.colorConvert(this, srcIL, dstIL);
        }
        return dst;
    }

    static {
        if (ProfileDeferralMgr.deferring) {
            ProfileDeferralMgr.activateProfiles();
        }
    }
}

