/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import sun.applet.AppletMessageHandler;
import sun.applet.AppletSecurity;
import sun.applet.AppletViewer;
import sun.net.www.ParseUtil;

public class Main {
    static File theUserPropertiesFile;
    static final String[][] avDefaultUserProps;
    private static AppletMessageHandler amh;
    private boolean debugFlag = false;
    private boolean helpFlag = false;
    private String encoding = null;
    private boolean noSecurityFlag = false;
    private static boolean cmdLineTestFlag;
    private static Vector urlList;
    public static final String theVersion;

    public static void main(String[] args) {
        Main m = new Main();
        int ret = m.run(args);
        if (ret != 0 || cmdLineTestFlag) {
            System.exit(ret);
        }
    }

    private int run(String[] args) {
        int i;
        try {
            int j;
            if (args.length == 0) {
                Main.usage();
                return 0;
            }
            for (i = 0; i < args.length; i += j) {
                j = this.decodeArg(args, i);
                if (j != 0) continue;
                throw new ParseException(Main.lookup("main.err.unrecognizedarg", args[i]));
            }
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            return 1;
        }
        if (this.helpFlag) {
            Main.usage();
            return 0;
        }
        if (urlList.size() == 0) {
            System.err.println(Main.lookup("main.err.inputfile"));
            return 1;
        }
        if (this.debugFlag) {
            return this.invokeDebugger(args);
        }
        if (!this.noSecurityFlag && System.getSecurityManager() == null) {
            this.init();
        }
        for (i = 0; i < urlList.size(); ++i) {
            try {
                AppletViewer.parse((URL)urlList.elementAt(i), this.encoding);
                continue;
            }
            catch (IOException e) {
                System.err.println(Main.lookup("main.err.io", e.getMessage()));
                return 1;
            }
        }
        return 0;
    }

    private static void usage() {
        System.out.println(Main.lookup("usage"));
    }

    private int decodeArg(String[] args, int i) throws ParseException {
        String arg = args[i];
        int argc = args.length;
        if ("-help".equalsIgnoreCase(arg) || "-?".equals(arg)) {
            this.helpFlag = true;
            return 1;
        }
        if ("-encoding".equals(arg) && i < argc - 1) {
            if (this.encoding != null) {
                throw new ParseException(Main.lookup("main.err.dupoption", arg));
            }
            this.encoding = args[++i];
            return 2;
        }
        if ("-debug".equals(arg)) {
            this.debugFlag = true;
            return 1;
        }
        if ("-Xnosecurity".equals(arg)) {
            System.err.println();
            System.err.println(Main.lookup("main.warn.nosecmgr"));
            System.err.println();
            this.noSecurityFlag = true;
            return 1;
        }
        if ("-XcmdLineTest".equals(arg)) {
            cmdLineTestFlag = true;
            return 1;
        }
        if (arg.startsWith("-")) {
            throw new ParseException(Main.lookup("main.err.unsupportedopt", arg));
        }
        URL url = this.parseURL(arg);
        if (url != null) {
            urlList.addElement(url);
            return 1;
        }
        return 0;
    }

    private URL parseURL(String url) throws ParseException {
        URL u = null;
        String prefix = "file:";
        try {
            if (url.indexOf(58) <= 1) {
                u = ParseUtil.fileToEncodedURL(new File(url));
            } else if (url.startsWith(prefix) && url.length() != prefix.length() && !new File(url.substring(prefix.length())).isAbsolute()) {
                String path = ParseUtil.fileToEncodedURL(new File(System.getProperty("user.dir"))).getPath() + url.substring(prefix.length());
                u = new URL("file", "", path);
            } else {
                u = new URL(url);
            }
        }
        catch (MalformedURLException e) {
            throw new ParseException(Main.lookup("main.err.badurl", url, e.getMessage()));
        }
        return u;
    }

    private int invokeDebugger(String[] args) {
        String[] newArgs = new String[args.length + 1];
        int current = 0;
        String phonyDir = System.getProperty("java.home") + File.separator + "phony";
        newArgs[current++] = "-Djava.class.path=" + phonyDir;
        newArgs[current++] = "sun.applet.Main";
        for (int i = 0; i < args.length; ++i) {
            if ("-debug".equals(args[i])) continue;
            newArgs[current++] = args[i];
        }
        try {
            Class<?> c = Class.forName("com.sun.tools.example.debug.tty.TTY", true, ClassLoader.getSystemClassLoader());
            Method m = c.getDeclaredMethod("main", String[].class);
            m.invoke(null, new Object[]{newArgs});
        }
        catch (ClassNotFoundException cnfe) {
            System.err.println(Main.lookup("main.debug.cantfinddebug"));
            return 1;
        }
        catch (NoSuchMethodException nsme) {
            System.err.println(Main.lookup("main.debug.cantfindmain"));
            return 1;
        }
        catch (InvocationTargetException ite) {
            System.err.println(Main.lookup("main.debug.exceptionindebug"));
            return 1;
        }
        catch (IllegalAccessException iae) {
            System.err.println(Main.lookup("main.debug.cantaccess"));
            return 1;
        }
        return 0;
    }

    private void init() {
        Properties avProps = this.getAVProps();
        avProps.put("browser", "sun.applet.AppletViewer");
        avProps.put("browser.version", "1.06");
        avProps.put("browser.vendor", "Sun Microsystems Inc.");
        avProps.put("http.agent", "Java(tm) 2 SDK, Standard Edition v" + theVersion);
        avProps.put("package.restrict.definition.java", "true");
        avProps.put("package.restrict.definition.sun", "true");
        avProps.put("java.version.applet", "true");
        avProps.put("java.vendor.applet", "true");
        avProps.put("java.vendor.url.applet", "true");
        avProps.put("java.class.version.applet", "true");
        avProps.put("os.name.applet", "true");
        avProps.put("os.version.applet", "true");
        avProps.put("os.arch.applet", "true");
        avProps.put("file.separator.applet", "true");
        avProps.put("path.separator.applet", "true");
        avProps.put("line.separator.applet", "true");
        Properties sysProps = System.getProperties();
        Enumeration<?> e = sysProps.propertyNames();
        while (e.hasMoreElements()) {
            String val;
            String key = (String)e.nextElement();
            String oldVal = (String)avProps.setProperty(key, val = sysProps.getProperty(key));
            if (oldVal == null) continue;
            System.err.println(Main.lookup("main.warn.prop.overwrite", key, oldVal, val));
        }
        System.setProperties(avProps);
        if (!this.noSecurityFlag) {
            System.setSecurityManager(new AppletSecurity());
        } else {
            System.err.println(Main.lookup("main.nosecmgr"));
        }
    }

    private Properties getAVProps() {
        Properties avProps = new Properties();
        File dotAV = theUserPropertiesFile;
        if (dotAV.exists()) {
            if (dotAV.canRead()) {
                avProps = this.getAVProps(dotAV);
            } else {
                System.err.println(Main.lookup("main.warn.cantreadprops", dotAV.toString()));
                avProps = this.setDefaultAVProps();
            }
        } else {
            File userHome = new File(System.getProperty("user.home"));
            File dotHJ = new File(userHome, ".hotjava");
            if ((dotHJ = new File(dotHJ, "properties")).exists()) {
                avProps = this.getAVProps(dotHJ);
            } else {
                System.err.println(Main.lookup("main.warn.cantreadprops", dotHJ.toString()));
                avProps = this.setDefaultAVProps();
            }
            try {
                FileOutputStream out = new FileOutputStream(dotAV);
                avProps.store(out, Main.lookup("main.prop.store"));
                out.close();
            }
            catch (IOException e) {
                System.err.println(Main.lookup("main.err.prop.cantsave", dotAV.toString()));
            }
        }
        return avProps;
    }

    private Properties setDefaultAVProps() {
        Properties avProps = new Properties();
        for (int i = 0; i < avDefaultUserProps.length; ++i) {
            avProps.setProperty(avDefaultUserProps[i][0], avDefaultUserProps[i][1]);
        }
        return avProps;
    }

    private Properties getAVProps(File inFile) {
        Properties avProps = new Properties();
        Properties tmpProps = new Properties();
        try {
            FileInputStream in = new FileInputStream(inFile);
            tmpProps.load(new BufferedInputStream(in));
            in.close();
        }
        catch (IOException e) {
            System.err.println(Main.lookup("main.err.prop.cantread", inFile.toString()));
        }
        for (int i = 0; i < avDefaultUserProps.length; ++i) {
            String value = tmpProps.getProperty(avDefaultUserProps[i][0]);
            if (value != null) {
                avProps.setProperty(avDefaultUserProps[i][0], value);
                continue;
            }
            avProps.setProperty(avDefaultUserProps[i][0], avDefaultUserProps[i][1]);
        }
        return avProps;
    }

    private static String lookup(String key) {
        return amh.getMessage(key);
    }

    private static String lookup(String key, String arg0) {
        return amh.getMessage(key, arg0);
    }

    private static String lookup(String key, String arg0, String arg1) {
        return amh.getMessage(key, arg0, arg1);
    }

    private static String lookup(String key, String arg0, String arg1, String arg2) {
        return amh.getMessage(key, arg0, arg1, arg2);
    }

    static {
        avDefaultUserProps = new String[][]{{"http.proxyHost", ""}, {"http.proxyPort", "80"}, {"package.restrict.access.sun", "true"}};
        File userHome = new File(System.getProperty("user.home"));
        userHome.canWrite();
        theUserPropertiesFile = new File(userHome, ".appletviewer");
        amh = new AppletMessageHandler("appletviewer");
        cmdLineTestFlag = false;
        urlList = new Vector(1);
        theVersion = System.getProperty("java.version");
    }

    class ParseException
    extends RuntimeException {
        Throwable t;

        public ParseException(String msg) {
            super(msg);
            this.t = null;
        }

        public ParseException(Throwable t) {
            super(t.getMessage());
            this.t = null;
            this.t = t;
        }
    }
}

