/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.tools;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import net.sourceforge.jnlp.security.SecurityUtil;
import sun.misc.BASE64Encoder;

public class KeyTool {
    private KeyStore usercerts = null;
    private KeyStore cacerts = null;
    private KeyStore systemcerts = null;
    private String fullCertPath = SecurityUtil.getTrustedCertsFilename();
    private FileOutputStream fos = null;
    private boolean trustcacerts = true;
    private boolean rfc = true;
    private final char[] password = "changeit".toCharArray();
    private boolean noprompt = true;

    public KeyTool() throws Exception {
        this.usercerts = SecurityUtil.getUserKeyStore();
        this.cacerts = SecurityUtil.getCacertsKeyStore();
        this.systemcerts = SecurityUtil.getSystemCertStore();
    }

    public boolean importCert(File file) throws Exception {
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
        CertificateFactory cf = CertificateFactory.getInstance("X509");
        X509Certificate cert = null;
        if (bis.available() >= 1) {
            try {
                cert = (X509Certificate)cf.generateCertificate(bis);
            }
            catch (ClassCastException cce) {
                throw new Exception("Input file is not an X509 Certificate");
            }
            catch (CertificateException ce) {
                throw new Exception("Input file is not an X509 Certificate");
            }
        }
        return this.importCert(cert);
    }

    public boolean importCert(Certificate cert) throws Exception {
        String alias = this.usercerts.getCertificateAlias(cert);
        if (alias != null) {
            return true;
        }
        String newAlias = this.getRandomAlias();
        while (this.usercerts.getCertificate(newAlias) != null) {
            newAlias = this.getRandomAlias();
        }
        return this.addTrustedCert(newAlias, cert);
    }

    private String getRandomAlias() {
        Random r = new Random();
        String token = Long.toString(Math.abs(r.nextLong()), 36);
        return "trustedCert-" + token;
    }

    private void doPrintEntries(PrintStream out) throws Exception {
        out.println("KeyStore type: " + this.usercerts.getType());
        out.println("KeyStore provider: " + this.usercerts.getProvider().toString());
        out.println();
        Enumeration<String> e = this.usercerts.aliases();
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            this.doPrintEntry(alias, out, false);
        }
    }

    private void doPrintEntry(String alias, PrintStream out, boolean printWarning) throws Exception {
        if (!this.usercerts.containsAlias(alias)) {
            throw new Exception("Alias does not exist");
        }
        if (this.usercerts.entryInstanceOf(alias, KeyStore.TrustedCertificateEntry.class)) {
            Certificate cert = this.usercerts.getCertificate(alias);
            out.println("Alias: " + alias);
            out.println("Date Created: " + this.usercerts.getCreationDate(alias));
            out.println("Subject: " + this.getCN(((X509Certificate)this.usercerts.getCertificate(alias)).getSubjectX500Principal().getName()));
            out.println("Certificate fingerprint (MD5): " + this.getCertFingerPrint("MD5", cert));
            out.println();
        }
    }

    private String getCN(String principal) {
        int start = principal.indexOf("CN=");
        int end = principal.indexOf(",", start);
        if (end == -1) {
            end = principal.length();
        }
        if (start >= 0) {
            return principal.substring(start + 3, end);
        }
        return principal;
    }

    private String getCertFingerPrint(String mdAlg, Certificate cert) throws Exception {
        byte[] encCertInfo = cert.getEncoded();
        MessageDigest md = MessageDigest.getInstance(mdAlg);
        byte[] digest = md.digest(encCertInfo);
        return this.toHexString(digest);
    }

    private void byte2hex(byte b, StringBuffer buf) {
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int high = (b & 0xF0) >> 4;
        int low = b & 0xF;
        buf.append(hexChars[high]);
        buf.append(hexChars[low]);
    }

    private String toHexString(byte[] block) {
        StringBuffer buf = new StringBuffer();
        int len = block.length;
        for (int i = 0; i < len; ++i) {
            this.byte2hex(block[i], buf);
            if (i >= len - 1) continue;
            buf.append(":");
        }
        return buf.toString();
    }

    private boolean addTrustedCert(String alias, Certificate cert) throws Exception {
        if (this.isSelfSigned((X509Certificate)cert)) {
            cert.verify(cert.getPublicKey());
        }
        if (this.noprompt) {
            this.usercerts.setCertificateEntry(alias, cert);
            this.fos = new FileOutputStream(this.fullCertPath);
            this.usercerts.store(this.fos, this.password);
            this.fos.close();
            return true;
        }
        return false;
    }

    public boolean isTrusted(Certificate cert) throws Exception {
        if (cert != null) {
            return this.usercerts.getCertificateAlias(cert) != null;
        }
        return false;
    }

    private boolean isSelfSigned(X509Certificate cert) {
        return ((Object)cert.getSubjectDN()).equals(cert.getIssuerDN());
    }

    public boolean checkCacertsForCertificate(Certificate c) throws Exception {
        if (c != null) {
            String alias = null;
            if (this.cacerts != null) {
                alias = this.cacerts.getCertificateAlias(c);
                if (alias == null && this.systemcerts != null) {
                    alias = this.systemcerts.getCertificateAlias(c);
                }
            } else if (this.systemcerts != null) {
                alias = this.systemcerts.getCertificateAlias(c);
            }
            return alias != null;
        }
        return false;
    }

    public boolean establishCertChain(Certificate userCert, Certificate certToVerify) throws Exception {
        Vector<Certificate> chain;
        KeyStore caks;
        if (userCert != null) {
            PublicKey replyPubKey;
            PublicKey origPubKey = userCert.getPublicKey();
            if (!origPubKey.equals(replyPubKey = certToVerify.getPublicKey())) {
                throw new Exception("Public keys in reply and keystore don't match");
            }
            if (certToVerify.equals(userCert)) {
                throw new Exception("Certificate reply and certificate in keystore are identical");
            }
        }
        Hashtable<Principal, Vector<Certificate>> certs = null;
        if (this.usercerts.size() > 0) {
            certs = new Hashtable<Principal, Vector<Certificate>>(11);
            this.keystorecerts2Hashtable(this.usercerts, certs);
        }
        if (this.trustcacerts && (caks = SecurityUtil.getCacertsKeyStore()) != null && caks.size() > 0) {
            if (certs == null) {
                certs = new Hashtable(11);
            }
            this.keystorecerts2Hashtable(caks, certs);
        }
        if (this.buildChain((X509Certificate)certToVerify, chain = new Vector<Certificate>(2), certs)) {
            Certificate[] newChain = new Certificate[chain.size()];
            int j = 0;
            for (int i = chain.size() - 1; i >= 0; --i) {
                newChain[j] = chain.elementAt(i);
                ++j;
            }
            return newChain != null;
        }
        throw new Exception("Failed to establish chain from reply");
    }

    private void keystorecerts2Hashtable(KeyStore ks, Hashtable<Principal, Vector<Certificate>> hash) throws Exception {
        Enumeration<String> aliases = ks.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            Certificate cert = ks.getCertificate(alias);
            if (cert == null) continue;
            Principal subjectDN = ((X509Certificate)cert).getSubjectDN();
            Vector<Certificate> vec = hash.get(subjectDN);
            if (vec == null) {
                vec = new Vector();
                vec.addElement(cert);
            } else if (!vec.contains(cert)) {
                vec.addElement(cert);
            }
            hash.put(subjectDN, vec);
        }
    }

    private boolean buildChain(X509Certificate certToVerify, Vector<Certificate> chain, Hashtable<Principal, Vector<Certificate>> certs) {
        Principal issuer;
        Principal subject = certToVerify.getSubjectDN();
        if (((Object)subject).equals(issuer = certToVerify.getIssuerDN())) {
            chain.addElement(certToVerify);
            return true;
        }
        Vector<Certificate> vec = certs.get(issuer);
        if (vec == null) {
            return false;
        }
        Enumeration<Certificate> issuerCerts = vec.elements();
        while (issuerCerts.hasMoreElements()) {
            X509Certificate issuerCert = (X509Certificate)issuerCerts.nextElement();
            PublicKey issuerPubKey = issuerCert.getPublicKey();
            try {
                certToVerify.verify(issuerPubKey);
            }
            catch (Exception e) {
                continue;
            }
            if (!this.buildChain(issuerCert, chain, certs)) continue;
            chain.addElement(certToVerify);
            return true;
        }
        return false;
    }

    public static void dumpCert(Certificate cert, PrintStream out) throws IOException, CertificateException {
        boolean printRfc = true;
        if (printRfc) {
            BASE64Encoder encoder = new BASE64Encoder();
            out.println("-----BEGIN CERTIFICATE-----");
            encoder.encodeBuffer(cert.getEncoded(), (OutputStream)out);
            out.println("-----END CERTIFICATE-----");
        } else {
            out.write(cert.getEncoded());
        }
    }

    public static void main(String[] args) throws Exception {
        KeyTool kt = new KeyTool();
        kt.doPrintEntries(System.out);
    }
}

