/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.LabelUI;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.basic.LazyActionMap;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;
import sun.swing.UIAction;

public class BasicLabelUI
extends LabelUI
implements PropertyChangeListener {
    protected static BasicLabelUI labelUI = new BasicLabelUI();
    private static final BasicLabelUI SAFE_BASIC_LABEL_UI = new BasicLabelUI();
    private static Rectangle paintIconR = new Rectangle();
    private static Rectangle paintTextR = new Rectangle();
    private static Rectangle paintViewR = new Rectangle();
    private static Insets paintViewInsets = new Insets(0, 0, 0, 0);
    private static Rectangle iconR = new Rectangle();
    private static Rectangle textR = new Rectangle();
    private static Rectangle viewR = new Rectangle();
    private static Insets viewInsets = new Insets(0, 0, 0, 0);

    static void loadActionMap(LazyActionMap map) {
        map.put(new Actions("press"));
        map.put(new Actions("release"));
    }

    protected String layoutCL(JLabel label, FontMetrics fontMetrics, String text, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR) {
        return SwingUtilities.layoutCompoundLabel(label, fontMetrics, text, icon, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), viewR, iconR, textR, label.getIconTextGap());
    }

    protected void paintEnabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        int mnemIndex = l.getDisplayedMnemonicIndex();
        g.setColor(l.getForeground());
        SwingUtilities2.drawStringUnderlineCharAt(l, g, s, mnemIndex, textX, textY);
    }

    protected void paintDisabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        int accChar = l.getDisplayedMnemonicIndex();
        Color background = l.getBackground();
        g.setColor(background.brighter());
        SwingUtilities2.drawStringUnderlineCharAt(l, g, s, accChar, textX + 1, textY + 1);
        g.setColor(background.darker());
        SwingUtilities2.drawStringUnderlineCharAt(l, g, s, accChar, textX, textY);
    }

    public void paint(Graphics g, JComponent c) {
        Icon icon;
        JLabel label = (JLabel)c;
        String text = label.getText();
        Icon icon2 = icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        if (icon == null && text == null) {
            return;
        }
        FontMetrics fm = SwingUtilities2.getFontMetrics((JComponent)label, g);
        String clippedText = this.layout(label, fm, c.getWidth(), c.getHeight());
        if (icon != null) {
            icon.paintIcon(c, g, BasicLabelUI.paintIconR.x, BasicLabelUI.paintIconR.y);
        }
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, paintTextR);
            } else {
                int textX = BasicLabelUI.paintTextR.x;
                int textY = BasicLabelUI.paintTextR.y + fm.getAscent();
                if (label.isEnabled()) {
                    this.paintEnabledText(label, g, clippedText, textX, textY);
                } else {
                    this.paintDisabledText(label, g, clippedText, textX, textY);
                }
            }
        }
    }

    private String layout(JLabel label, FontMetrics fm, int width, int height) {
        Insets insets = label.getInsets(paintViewInsets);
        String text = label.getText();
        Icon icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        BasicLabelUI.paintViewR.x = insets.left;
        BasicLabelUI.paintViewR.y = insets.top;
        BasicLabelUI.paintViewR.width = width - (insets.left + insets.right);
        BasicLabelUI.paintViewR.height = height - (insets.top + insets.bottom);
        BasicLabelUI.paintIconR.height = 0;
        BasicLabelUI.paintIconR.width = 0;
        BasicLabelUI.paintIconR.y = 0;
        BasicLabelUI.paintIconR.x = 0;
        BasicLabelUI.paintTextR.height = 0;
        BasicLabelUI.paintTextR.width = 0;
        BasicLabelUI.paintTextR.y = 0;
        BasicLabelUI.paintTextR.x = 0;
        return this.layoutCL(label, fm, text, icon, paintViewR, paintIconR, paintTextR);
    }

    public Dimension getPreferredSize(JComponent c) {
        JLabel label = (JLabel)c;
        String text = label.getText();
        Icon icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        Insets insets = label.getInsets(viewInsets);
        Font font = label.getFont();
        int dx = insets.left + insets.right;
        int dy = insets.top + insets.bottom;
        if (icon == null && (text == null || text != null && font == null)) {
            return new Dimension(dx, dy);
        }
        if (text == null || icon != null && font == null) {
            return new Dimension(icon.getIconWidth() + dx, icon.getIconHeight() + dy);
        }
        FontMetrics fm = label.getFontMetrics(font);
        BasicLabelUI.iconR.height = 0;
        BasicLabelUI.iconR.width = 0;
        BasicLabelUI.iconR.y = 0;
        BasicLabelUI.iconR.x = 0;
        BasicLabelUI.textR.height = 0;
        BasicLabelUI.textR.width = 0;
        BasicLabelUI.textR.y = 0;
        BasicLabelUI.textR.x = 0;
        BasicLabelUI.viewR.x = dx;
        BasicLabelUI.viewR.y = dy;
        BasicLabelUI.viewR.height = Short.MAX_VALUE;
        BasicLabelUI.viewR.width = Short.MAX_VALUE;
        this.layoutCL(label, fm, text, icon, viewR, iconR, textR);
        int x1 = Math.min(BasicLabelUI.iconR.x, BasicLabelUI.textR.x);
        int x2 = Math.max(BasicLabelUI.iconR.x + BasicLabelUI.iconR.width, BasicLabelUI.textR.x + BasicLabelUI.textR.width);
        int y1 = Math.min(BasicLabelUI.iconR.y, BasicLabelUI.textR.y);
        int y2 = Math.max(BasicLabelUI.iconR.y + BasicLabelUI.iconR.height, BasicLabelUI.textR.y + BasicLabelUI.textR.height);
        Dimension rv = new Dimension(x2 - x1, y2 - y1);
        rv.width += dx;
        rv.height += dy;
        return rv;
    }

    public Dimension getMinimumSize(JComponent c) {
        Dimension d = this.getPreferredSize(c);
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            d.width = (int)((float)d.width - (v.getPreferredSpan(0) - v.getMinimumSpan(0)));
        }
        return d;
    }

    public Dimension getMaximumSize(JComponent c) {
        Dimension d = this.getPreferredSize(c);
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            d.width = (int)((float)d.width + (v.getMaximumSpan(0) - v.getPreferredSpan(0)));
        }
        return d;
    }

    public int getBaseline(JComponent c, int width, int height) {
        super.getBaseline(c, width, height);
        JLabel label = (JLabel)c;
        String text = label.getText();
        if (text == null || "".equals(text) || label.getFont() == null) {
            return -1;
        }
        FontMetrics fm = label.getFontMetrics(label.getFont());
        this.layout(label, fm, width, height);
        return BasicHTML.getBaseline(label, BasicLabelUI.paintTextR.y, fm.getAscent(), BasicLabelUI.paintTextR.width, BasicLabelUI.paintTextR.height);
    }

    public Component.BaselineResizeBehavior getBaselineResizeBehavior(JComponent c) {
        super.getBaselineResizeBehavior(c);
        if (c.getClientProperty("html") != null) {
            return Component.BaselineResizeBehavior.OTHER;
        }
        switch (((JLabel)c).getVerticalAlignment()) {
            case 1: {
                return Component.BaselineResizeBehavior.CONSTANT_ASCENT;
            }
            case 3: {
                return Component.BaselineResizeBehavior.CONSTANT_DESCENT;
            }
            case 0: {
                return Component.BaselineResizeBehavior.CENTER_OFFSET;
            }
        }
        return Component.BaselineResizeBehavior.OTHER;
    }

    public void installUI(JComponent c) {
        this.installDefaults((JLabel)c);
        this.installComponents((JLabel)c);
        this.installListeners((JLabel)c);
        this.installKeyboardActions((JLabel)c);
    }

    public void uninstallUI(JComponent c) {
        this.uninstallDefaults((JLabel)c);
        this.uninstallComponents((JLabel)c);
        this.uninstallListeners((JLabel)c);
        this.uninstallKeyboardActions((JLabel)c);
    }

    protected void installDefaults(JLabel c) {
        LookAndFeel.installColorsAndFont(c, "Label.background", "Label.foreground", "Label.font");
        LookAndFeel.installProperty(c, "opaque", Boolean.FALSE);
    }

    protected void installListeners(JLabel c) {
        c.addPropertyChangeListener(this);
    }

    protected void installComponents(JLabel c) {
        BasicHTML.updateRenderer(c, c.getText());
        c.setInheritsPopupMenu(true);
    }

    protected void installKeyboardActions(JLabel l) {
        int dka = l.getDisplayedMnemonic();
        Component lf = l.getLabelFor();
        if (dka != 0 && lf != null) {
            LazyActionMap.installLazyActionMap(l, BasicLabelUI.class, "Label.actionMap");
            InputMap inputMap = SwingUtilities.getUIInputMap(l, 2);
            if (inputMap == null) {
                inputMap = new ComponentInputMapUIResource(l);
                SwingUtilities.replaceUIInputMap(l, 2, inputMap);
            }
            inputMap.clear();
            inputMap.put(KeyStroke.getKeyStroke(dka, 8, false), "press");
        } else {
            InputMap inputMap = SwingUtilities.getUIInputMap(l, 2);
            if (inputMap != null) {
                inputMap.clear();
            }
        }
    }

    protected void uninstallDefaults(JLabel c) {
    }

    protected void uninstallListeners(JLabel c) {
        c.removePropertyChangeListener(this);
    }

    protected void uninstallComponents(JLabel c) {
        BasicHTML.updateRenderer(c, "");
    }

    protected void uninstallKeyboardActions(JLabel c) {
        SwingUtilities.replaceUIInputMap(c, 0, null);
        SwingUtilities.replaceUIInputMap(c, 2, null);
        SwingUtilities.replaceUIActionMap(c, null);
    }

    public static ComponentUI createUI(JComponent c) {
        if (System.getSecurityManager() != null) {
            return SAFE_BASIC_LABEL_UI;
        }
        return labelUI;
    }

    public void propertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        if (name == "text" || "font" == name || "foreground" == name) {
            JLabel lbl = (JLabel)e.getSource();
            String text = lbl.getText();
            BasicHTML.updateRenderer(lbl, text);
        } else if (name == "labelFor" || name == "displayedMnemonic") {
            this.installKeyboardActions((JLabel)e.getSource());
        }
    }

    private static class Actions
    extends UIAction {
        private static final String PRESS = "press";
        private static final String RELEASE = "release";

        Actions(String key) {
            super(key);
        }

        public void actionPerformed(ActionEvent e) {
            JLabel label = (JLabel)e.getSource();
            String key = this.getName();
            if (key == PRESS) {
                this.doPress(label);
            } else if (key == RELEASE) {
                this.doRelease(label);
            }
        }

        private void doPress(JLabel label) {
            Component labelFor = label.getLabelFor();
            if (labelFor != null && labelFor.isEnabled()) {
                InputMap inputMap = SwingUtilities.getUIInputMap(label, 0);
                if (inputMap == null) {
                    inputMap = new InputMapUIResource();
                    SwingUtilities.replaceUIInputMap(label, 0, inputMap);
                }
                int dka = label.getDisplayedMnemonic();
                inputMap.put(KeyStroke.getKeyStroke(dka, 8, true), RELEASE);
                inputMap.put(KeyStroke.getKeyStroke(18, 0, true), RELEASE);
                label.requestFocus();
            }
        }

        private void doRelease(JLabel label) {
            Component labelFor = label.getLabelFor();
            if (labelFor != null && labelFor.isEnabled()) {
                InputMap inputMap = SwingUtilities.getUIInputMap(label, 0);
                if (inputMap != null) {
                    inputMap.remove(KeyStroke.getKeyStroke(label.getDisplayedMnemonic(), 8, true));
                    inputMap.remove(KeyStroke.getKeyStroke(18, 0, true));
                }
                if (labelFor instanceof Container && ((Container)labelFor).isFocusCycleRoot()) {
                    labelFor.requestFocus();
                } else {
                    SwingUtilities2.compositeRequestFocus(labelFor);
                }
            }
        }
    }
}

