/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.ArrayPersistenceDelegate;
import java.beans.BeanInfo;
import java.beans.ConstructorProperties;
import java.beans.DefaultPersistenceDelegate;
import java.beans.EnumPersistenceDelegate;
import java.beans.Introspector;
import java.beans.NullPersistenceDelegate;
import java.beans.PersistenceDelegate;
import java.beans.PrimitivePersistenceDelegate;
import java.beans.PropertyDescriptor;
import java.beans.ProxyPersistenceDelegate;
import java.beans.ReflectionUtils;
import java.beans.java_awt_AWTKeyStroke_PersistenceDelegate;
import java.beans.java_awt_Font_PersistenceDelegate;
import java.beans.java_util_Date_PersistenceDelegate;
import java.beans.java_util_EnumSet_PersistenceDelegate;
import java.beans.javax_swing_border_MatteBorder_PersistenceDelegate;
import java.lang.reflect.Constructor;
import java.lang.reflect.Proxy;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MetaData {
    private static Hashtable internalPersistenceDelegates = new Hashtable();
    private static Hashtable transientProperties = new Hashtable();
    private static PersistenceDelegate nullPersistenceDelegate = new NullPersistenceDelegate();
    private static PersistenceDelegate enumPersistenceDelegate = new EnumPersistenceDelegate();
    private static PersistenceDelegate primitivePersistenceDelegate = new PrimitivePersistenceDelegate();
    private static PersistenceDelegate defaultPersistenceDelegate = new DefaultPersistenceDelegate();
    private static PersistenceDelegate arrayPersistenceDelegate;
    private static PersistenceDelegate proxyPersistenceDelegate;

    MetaData() {
    }

    static boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public static synchronized PersistenceDelegate getPersistenceDelegate(Class type) {
        PersistenceDelegate pd;
        if (type == null) {
            return nullPersistenceDelegate;
        }
        if (Enum.class.isAssignableFrom(type)) {
            return enumPersistenceDelegate;
        }
        if (ReflectionUtils.isPrimitive(type)) {
            return primitivePersistenceDelegate;
        }
        if (type.isArray()) {
            if (arrayPersistenceDelegate == null) {
                arrayPersistenceDelegate = new ArrayPersistenceDelegate();
            }
            return arrayPersistenceDelegate;
        }
        try {
            if (Proxy.isProxyClass(type)) {
                if (proxyPersistenceDelegate == null) {
                    proxyPersistenceDelegate = new ProxyPersistenceDelegate();
                }
                return proxyPersistenceDelegate;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String typeName = type.getName();
        if (MetaData.getBeanAttribute(type, "transient_init") == null) {
            Vector tp = (Vector)transientProperties.get(typeName);
            if (tp != null) {
                for (int i = 0; i < tp.size(); ++i) {
                    MetaData.setPropertyAttribute(type, (String)tp.get(i), "transient", Boolean.TRUE);
                }
            }
            MetaData.setBeanAttribute(type, "transient_init", Boolean.TRUE);
        }
        if ((pd = (PersistenceDelegate)MetaData.getBeanAttribute(type, "persistenceDelegate")) == null) {
            pd = (PersistenceDelegate)internalPersistenceDelegates.get(typeName);
            if (pd != null) {
                return pd;
            }
            internalPersistenceDelegates.put(typeName, defaultPersistenceDelegate);
            try {
                String name = type.getName();
                Class<?> c = Class.forName("java.beans." + name.replace('.', '_') + "_PersistenceDelegate");
                pd = (PersistenceDelegate)c.newInstance();
                internalPersistenceDelegates.put(typeName, pd);
            }
            catch (ClassNotFoundException e) {
                String[] properties = MetaData.getConstructorProperties(type);
                if (properties != null) {
                    pd = new DefaultPersistenceDelegate(properties);
                    internalPersistenceDelegates.put(typeName, pd);
                }
            }
            catch (Exception e) {
                System.err.println("Internal error: " + e);
            }
        }
        return pd != null ? pd : defaultPersistenceDelegate;
    }

    private static String[] getConstructorProperties(Class type) {
        String[] names = null;
        int length = 0;
        for (Constructor<?> constructor : type.getConstructors()) {
            String[] value = MetaData.getAnnotationValue(constructor);
            if (value == null || length >= value.length || !MetaData.isValid(constructor, value)) continue;
            names = value;
            length = value.length;
        }
        return names;
    }

    private static String[] getAnnotationValue(Constructor<?> constructor) {
        ConstructorProperties annotation = constructor.getAnnotation(ConstructorProperties.class);
        return annotation != null ? annotation.value() : null;
    }

    private static boolean isValid(Constructor<?> constructor, String[] names) {
        Class<?>[] parameters = constructor.getParameterTypes();
        if (names.length != parameters.length) {
            return false;
        }
        for (String name : names) {
            if (name != null) continue;
            return false;
        }
        return true;
    }

    public static BeanInfo getBeanInfo(Class type) {
        BeanInfo info = null;
        try {
            info = Introspector.getBeanInfo(type);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return info;
    }

    private static PropertyDescriptor getPropertyDescriptor(Class type, String propertyName) {
        BeanInfo info = MetaData.getBeanInfo(type);
        PropertyDescriptor[] propertyDescriptors = info.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            PropertyDescriptor pd = propertyDescriptors[i];
            if (!propertyName.equals(pd.getName())) continue;
            return pd;
        }
        return null;
    }

    private static void setPropertyAttribute(Class type, String property, String attribute, Object value) {
        PropertyDescriptor pd = MetaData.getPropertyDescriptor(type, property);
        if (pd == null) {
            System.err.println("Warning: property " + property + " is not defined on " + type);
            return;
        }
        pd.setValue(attribute, value);
    }

    private static void setBeanAttribute(Class type, String attribute, Object value) {
        MetaData.getBeanInfo(type).getBeanDescriptor().setValue(attribute, value);
    }

    private static Object getBeanAttribute(Class type, String attribute) {
        return MetaData.getBeanInfo(type).getBeanDescriptor().getValue(attribute);
    }

    private static synchronized void registerConstructor(String typeName, String[] constructor) {
        internalPersistenceDelegates.put(typeName, new DefaultPersistenceDelegate(constructor));
    }

    private static void removeProperty(String typeName, String property) {
        Vector<String> tp = (Vector<String>)transientProperties.get(typeName);
        if (tp == null) {
            tp = new Vector<String>();
            transientProperties.put(typeName, tp);
        }
        tp.add(property);
    }

    static {
        MetaData.registerConstructor("java.beans.Statement", new String[]{"target", "methodName", "arguments"});
        MetaData.registerConstructor("java.beans.Expression", new String[]{"target", "methodName", "arguments"});
        MetaData.registerConstructor("java.beans.EventHandler", new String[]{"target", "action", "eventPropertyName", "listenerMethodName"});
        MetaData.registerConstructor("java.awt.Color", new String[]{"red", "green", "blue", "alpha"});
        MetaData.registerConstructor("java.awt.Cursor", new String[]{"type"});
        MetaData.registerConstructor("java.awt.ScrollPane", new String[]{"scrollbarDisplayPolicy"});
        MetaData.registerConstructor("javax.swing.plaf.ColorUIResource", new String[]{"red", "green", "blue"});
        MetaData.registerConstructor("javax.swing.tree.DefaultTreeModel", new String[]{"root"});
        MetaData.registerConstructor("javax.swing.JTree", new String[]{"model"});
        MetaData.registerConstructor("javax.swing.tree.TreePath", new String[]{"path"});
        MetaData.registerConstructor("javax.swing.OverlayLayout", new String[]{"target"});
        MetaData.registerConstructor("javax.swing.BoxLayout", new String[]{"target", "axis"});
        MetaData.registerConstructor("javax.swing.Box$Filler", new String[]{"minimumSize", "preferredSize", "maximumSize"});
        MetaData.registerConstructor("javax.swing.DefaultCellEditor", new String[]{"component"});
        MetaData.registerConstructor("javax.swing.JSplitPane", new String[]{"orientation"});
        MetaData.registerConstructor("javax.swing.ImageIcon", new String[]{"description"});
        MetaData.registerConstructor("javax.swing.JButton", new String[]{"text"});
        MetaData.registerConstructor("javax.swing.border.BevelBorder", new String[]{"bevelType", "highlightOuterColor", "highlightInnerColor", "shadowOuterColor", "shadowInnerColor"});
        MetaData.registerConstructor("javax.swing.plaf.BorderUIResource$BevelBorderUIResource", new String[]{"bevelType", "highlightOuterColor", "highlightInnerColor", "shadowOuterColor", "shadowInnerColor"});
        MetaData.registerConstructor("javax.swing.border.CompoundBorder", new String[]{"outsideBorder", "insideBorder"});
        MetaData.registerConstructor("javax.swing.plaf.BorderUIResource$CompoundBorderUIResource", new String[]{"outsideBorder", "insideBorder"});
        MetaData.registerConstructor("javax.swing.border.EmptyBorder", new String[]{"borderInsets"});
        MetaData.registerConstructor("javax.swing.plaf.BorderUIResource$EmptyBorderUIResource", new String[]{"borderInsets"});
        MetaData.registerConstructor("javax.swing.border.EtchedBorder", new String[]{"etchType", "highlightColor", "shadowColor"});
        MetaData.registerConstructor("javax.swing.plaf.BorderUIResource$EtchedBorderUIResource", new String[]{"etchType", "highlightColor", "shadowColor"});
        MetaData.registerConstructor("javax.swing.border.LineBorder", new String[]{"lineColor", "thickness", "roundedCorners"});
        MetaData.registerConstructor("javax.swing.plaf.BorderUIResource$LineBorderUIResource", new String[]{"lineColor", "thickness"});
        MetaData.registerConstructor("javax.swing.border.SoftBevelBorder", new String[]{"bevelType", "highlightOuterColor", "highlightInnerColor", "shadowOuterColor", "shadowInnerColor"});
        MetaData.registerConstructor("javax.swing.border.TitledBorder", new String[]{"border", "title", "titleJustification", "titlePosition", "titleFont", "titleColor"});
        MetaData.registerConstructor("javax.swing.plaf.BorderUIResource$TitledBorderUIResource", new String[]{"border", "title", "titleJustification", "titlePosition", "titleFont", "titleColor"});
        internalPersistenceDelegates.put("java.net.URI", new PrimitivePersistenceDelegate());
        internalPersistenceDelegates.put("javax.swing.plaf.BorderUIResource$MatteBorderUIResource", new javax_swing_border_MatteBorder_PersistenceDelegate());
        internalPersistenceDelegates.put("javax.swing.plaf.FontUIResource", new java_awt_Font_PersistenceDelegate());
        internalPersistenceDelegates.put("javax.swing.KeyStroke", new java_awt_AWTKeyStroke_PersistenceDelegate());
        internalPersistenceDelegates.put("java.sql.Date", new java_util_Date_PersistenceDelegate());
        internalPersistenceDelegates.put("java.sql.Time", new java_util_Date_PersistenceDelegate());
        internalPersistenceDelegates.put("java.util.JumboEnumSet", new java_util_EnumSet_PersistenceDelegate());
        internalPersistenceDelegates.put("java.util.RegularEnumSet", new java_util_EnumSet_PersistenceDelegate());
        MetaData.removeProperty("java.awt.geom.RectangularShape", "frame");
        MetaData.removeProperty("java.awt.Rectangle", "bounds");
        MetaData.removeProperty("java.awt.Dimension", "size");
        MetaData.removeProperty("java.awt.Point", "location");
        MetaData.removeProperty("java.awt.Component", "foreground");
        MetaData.removeProperty("java.awt.Component", "background");
        MetaData.removeProperty("java.awt.Component", "font");
        MetaData.removeProperty("java.awt.Component", "visible");
        MetaData.removeProperty("java.awt.ScrollPane", "scrollPosition");
        MetaData.removeProperty("java.awt.im.InputContext", "compositionEnabled");
        MetaData.removeProperty("javax.swing.JComponent", "minimumSize");
        MetaData.removeProperty("javax.swing.JComponent", "preferredSize");
        MetaData.removeProperty("javax.swing.JComponent", "maximumSize");
        MetaData.removeProperty("javax.swing.ImageIcon", "image");
        MetaData.removeProperty("javax.swing.ImageIcon", "imageObserver");
        MetaData.removeProperty("javax.swing.JMenuBar", "helpMenu");
        MetaData.removeProperty("javax.swing.JScrollPane", "verticalScrollBar");
        MetaData.removeProperty("javax.swing.JScrollPane", "horizontalScrollBar");
        MetaData.removeProperty("javax.swing.JScrollPane", "rowHeader");
        MetaData.removeProperty("javax.swing.JScrollPane", "columnHeader");
        MetaData.removeProperty("javax.swing.JViewport", "extentSize");
        MetaData.removeProperty("javax.swing.table.JTableHeader", "defaultRenderer");
        MetaData.removeProperty("javax.swing.JList", "cellRenderer");
        MetaData.removeProperty("javax.swing.JList", "selectedIndices");
        MetaData.removeProperty("javax.swing.DefaultListSelectionModel", "leadSelectionIndex");
        MetaData.removeProperty("javax.swing.DefaultListSelectionModel", "anchorSelectionIndex");
        MetaData.removeProperty("javax.swing.JComboBox", "selectedIndex");
        MetaData.removeProperty("javax.swing.JTabbedPane", "selectedIndex");
        MetaData.removeProperty("javax.swing.JTabbedPane", "selectedComponent");
        MetaData.removeProperty("javax.swing.AbstractButton", "disabledIcon");
        MetaData.removeProperty("javax.swing.JLabel", "disabledIcon");
        MetaData.removeProperty("javax.swing.text.JTextComponent", "caret");
        MetaData.removeProperty("javax.swing.text.JTextComponent", "caretPosition");
        MetaData.removeProperty("javax.swing.text.JTextComponent", "selectionStart");
        MetaData.removeProperty("javax.swing.text.JTextComponent", "selectionEnd");
    }
}

