/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.MenuContainer;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.awt.peer.MenuComponentPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleStateSet;
import sun.awt.AppContext;

public abstract class MenuComponent
implements Serializable {
    transient MenuComponentPeer peer;
    transient MenuContainer parent;
    transient AppContext appContext;
    Font font;
    private String name;
    private boolean nameExplicitlySet = false;
    boolean newEventsOnly = false;
    static final String actionListenerK = "actionL";
    static final String itemListenerK = "itemL";
    private static final long serialVersionUID = -4536902356223894379L;
    AccessibleContext accessibleContext = null;

    public MenuComponent() throws HeadlessException {
        GraphicsEnvironment.checkHeadless();
        this.appContext = AppContext.getAppContext();
    }

    String constructComponentName() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        if (this.name == null && !this.nameExplicitlySet) {
            MenuComponent menuComponent = this;
            synchronized (menuComponent) {
                if (this.name == null && !this.nameExplicitlySet) {
                    this.name = this.constructComponentName();
                }
            }
        }
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String name) {
        MenuComponent menuComponent = this;
        synchronized (menuComponent) {
            this.name = name;
            this.nameExplicitlySet = true;
        }
    }

    public MenuContainer getParent() {
        return this.getParent_NoClientCode();
    }

    final MenuContainer getParent_NoClientCode() {
        return this.parent;
    }

    @Deprecated
    public MenuComponentPeer getPeer() {
        return this.peer;
    }

    public Font getFont() {
        Font font = this.font;
        if (font != null) {
            return font;
        }
        MenuContainer parent = this.parent;
        if (parent != null) {
            return parent.getFont();
        }
        return null;
    }

    final Font getFont_NoClientCode() {
        Font font = this.font;
        if (font != null) {
            return font;
        }
        MenuContainer parent = this.parent;
        if (parent != null) {
            if (parent instanceof Component) {
                font = ((Component)parent).getFont_NoClientCode();
            } else if (parent instanceof MenuComponent) {
                font = ((MenuComponent)((Object)parent)).getFont_NoClientCode();
            }
        }
        return font;
    }

    public void setFont(Font f) {
        this.font = f;
        MenuComponentPeer peer = this.peer;
        if (peer != null) {
            peer.setFont(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            MenuComponentPeer p = this.peer;
            if (p != null) {
                Toolkit.getEventQueue().removeSourceEvents(this, true);
                this.peer = null;
                p.dispose();
            }
        }
    }

    @Deprecated
    public boolean postEvent(Event evt) {
        MenuContainer parent = this.parent;
        if (parent != null) {
            parent.postEvent(evt);
        }
        return false;
    }

    public final void dispatchEvent(AWTEvent e) {
        this.dispatchEventImpl(e);
    }

    void dispatchEventImpl(AWTEvent e) {
        EventQueue.setCurrentEventAndMostRecentTime(e);
        Toolkit.getDefaultToolkit().notifyAWTEventListeners(e);
        if (this.newEventsOnly || this.parent != null && this.parent instanceof MenuComponent && ((MenuComponent)((Object)this.parent)).newEventsOnly) {
            if (this.eventEnabled(e)) {
                this.processEvent(e);
            } else if (e instanceof ActionEvent && this.parent != null) {
                e.setSource(this.parent);
                ((MenuComponent)((Object)this.parent)).dispatchEvent(e);
            }
        } else {
            Event olde = e.convertToOld();
            if (olde != null) {
                this.postEvent(olde);
            }
        }
    }

    boolean eventEnabled(AWTEvent e) {
        return false;
    }

    protected void processEvent(AWTEvent e) {
    }

    protected String paramString() {
        String thisName = this.getName();
        return thisName != null ? thisName : "";
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.paramString() + "]";
    }

    protected final Object getTreeLock() {
        return Component.LOCK;
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException, HeadlessException {
        GraphicsEnvironment.checkHeadless();
        s.defaultReadObject();
        this.appContext = AppContext.getAppContext();
    }

    private static native void initIDs();

    public AccessibleContext getAccessibleContext() {
        return this.accessibleContext;
    }

    int getAccessibleIndexInParent() {
        MenuContainer localParent = this.parent;
        if (!(localParent instanceof MenuComponent)) {
            return -1;
        }
        MenuComponent localParentMenu = (MenuComponent)((Object)localParent);
        return localParentMenu.getAccessibleChildIndex(this);
    }

    int getAccessibleChildIndex(MenuComponent child) {
        return -1;
    }

    AccessibleStateSet getAccessibleStateSet() {
        AccessibleStateSet states = new AccessibleStateSet();
        return states;
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            MenuComponent.initIDs();
        }
    }

    protected abstract class AccessibleAWTMenuComponent
    extends AccessibleContext
    implements Serializable,
    AccessibleComponent,
    AccessibleSelection {
        private static final long serialVersionUID = -4269533416223798698L;

        protected AccessibleAWTMenuComponent() {
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public String getAccessibleName() {
            return this.accessibleName;
        }

        public String getAccessibleDescription() {
            return this.accessibleDescription;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.AWT_COMPONENT;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return MenuComponent.this.getAccessibleStateSet();
        }

        public Accessible getAccessibleParent() {
            if (this.accessibleParent != null) {
                return this.accessibleParent;
            }
            MenuContainer parent = MenuComponent.this.getParent();
            if (parent instanceof Accessible) {
                return (Accessible)((Object)parent);
            }
            return null;
        }

        public int getAccessibleIndexInParent() {
            return MenuComponent.this.getAccessibleIndexInParent();
        }

        public int getAccessibleChildrenCount() {
            return 0;
        }

        public Accessible getAccessibleChild(int i) {
            return null;
        }

        public Locale getLocale() {
            MenuContainer parent = MenuComponent.this.getParent();
            if (parent instanceof Component) {
                return ((Component)parent).getLocale();
            }
            return Locale.getDefault();
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public Color getBackground() {
            return null;
        }

        public void setBackground(Color c) {
        }

        public Color getForeground() {
            return null;
        }

        public void setForeground(Color c) {
        }

        public Cursor getCursor() {
            return null;
        }

        public void setCursor(Cursor cursor) {
        }

        public Font getFont() {
            return MenuComponent.this.getFont();
        }

        public void setFont(Font f) {
            MenuComponent.this.setFont(f);
        }

        public FontMetrics getFontMetrics(Font f) {
            return null;
        }

        public boolean isEnabled() {
            return true;
        }

        public void setEnabled(boolean b) {
        }

        public boolean isVisible() {
            return true;
        }

        public void setVisible(boolean b) {
        }

        public boolean isShowing() {
            return true;
        }

        public boolean contains(Point p) {
            return false;
        }

        public Point getLocationOnScreen() {
            return null;
        }

        public Point getLocation() {
            return null;
        }

        public void setLocation(Point p) {
        }

        public Rectangle getBounds() {
            return null;
        }

        public void setBounds(Rectangle r) {
        }

        public Dimension getSize() {
            return null;
        }

        public void setSize(Dimension d) {
        }

        public Accessible getAccessibleAt(Point p) {
            return null;
        }

        public boolean isFocusTraversable() {
            return true;
        }

        public void requestFocus() {
        }

        public void addFocusListener(FocusListener l) {
        }

        public void removeFocusListener(FocusListener l) {
        }

        public int getAccessibleSelectionCount() {
            return 0;
        }

        public Accessible getAccessibleSelection(int i) {
            return null;
        }

        public boolean isAccessibleChildSelected(int i) {
            return false;
        }

        public void addAccessibleSelection(int i) {
        }

        public void removeAccessibleSelection(int i) {
        }

        public void clearAccessibleSelection() {
        }

        public void selectAllAccessibleSelection() {
        }
    }
}

