/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.sasl.gsskerb;

import com.sun.security.sasl.gsskerb.GssKrb5Client;
import com.sun.security.sasl.gsskerb.GssKrb5Server;
import com.sun.security.sasl.util.PolicyUtils;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FactoryImpl
implements SaslClientFactory,
SaslServerFactory {
    private static final String[] myMechs = new String[]{"GSSAPI"};
    private static final int[] mechPolicies = new int[]{19};
    private static final int GSS_KERB_V5 = 0;

    @Override
    public SaslClient createSaslClient(String[] mechs, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        for (int i = 0; i < mechs.length; ++i) {
            if (!mechs[i].equals(myMechs[0]) || !PolicyUtils.checkPolicy(mechPolicies[0], props)) continue;
            return new GssKrb5Client(authorizationId, protocol, serverName, props, cbh);
        }
        return null;
    }

    @Override
    public SaslServer createSaslServer(String mech, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        if (mech.equals(myMechs[0]) && PolicyUtils.checkPolicy(mechPolicies[0], props)) {
            if (cbh == null) {
                throw new SaslException("Callback handler with support for AuthorizeCallback required");
            }
            return new GssKrb5Server(protocol, serverName, props, cbh);
        }
        return null;
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        return PolicyUtils.filterMechs(myMechs, mechPolicies, props);
    }
}

