/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.algorithms;

import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class JCEMapper {
    static Logger log = Logger.getLogger(JCEMapper.class.getName());
    private static Map uriToJCEName = new HashMap();
    private static Map algorithmsMap = new HashMap();
    private static String providerName = null;

    public static void init(Element mappingElement) throws Exception {
        JCEMapper.loadAlgorithms((Element)mappingElement.getElementsByTagName("Algorithms").item(0));
    }

    static void loadAlgorithms(Element algorithmsEl) {
        Element[] algorithms = XMLUtils.selectNodes(algorithmsEl.getFirstChild(), "http://www.xmlsecurity.org/NS/#configuration", "Algorithm");
        for (int i = 0; i < algorithms.length; ++i) {
            Element el = algorithms[i];
            String id = el.getAttribute("URI");
            String jceName = el.getAttribute("JCEName");
            uriToJCEName.put(id, jceName);
            algorithmsMap.put(id, new Algorithm(el));
        }
    }

    static Algorithm getAlgorithmMapping(String algoURI) {
        return (Algorithm)algorithmsMap.get(algoURI);
    }

    public static String translateURItoJCEID(String AlgorithmURI) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Request for URI " + AlgorithmURI);
        }
        String jceName = (String)uriToJCEName.get(AlgorithmURI);
        return jceName;
    }

    public static String getAlgorithmClassFromURI(String AlgorithmURI) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Request for URI " + AlgorithmURI);
        }
        return ((Algorithm)JCEMapper.algorithmsMap.get((Object)AlgorithmURI)).algorithmClass;
    }

    public static int getKeyLengthFromURI(String AlgorithmURI) {
        return Integer.parseInt(((Algorithm)JCEMapper.algorithmsMap.get((Object)AlgorithmURI)).keyLength);
    }

    public static String getJCEKeyAlgorithmFromURI(String AlgorithmURI) {
        return ((Algorithm)JCEMapper.algorithmsMap.get((Object)AlgorithmURI)).requiredKey;
    }

    public static String getProviderId() {
        return providerName;
    }

    public static void setProviderId(String provider) {
        providerName = provider;
    }

    public static class Algorithm {
        String algorithmClass;
        String keyLength;
        String requiredKey;

        public Algorithm(Element el) {
            this.algorithmClass = el.getAttribute("AlgorithmClass");
            this.keyLength = el.getAttribute("KeyLength");
            this.requiredKey = el.getAttribute("RequiredKey");
        }
    }
}

