/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap.sasl;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;

final class DefaultCallbackHandler
implements CallbackHandler {
    private char[] passwd;
    private String authenticationID;
    private String authRealm;

    DefaultCallbackHandler(String principal, Object cred, String realm) throws IOException {
        this.authenticationID = principal;
        this.authRealm = realm;
        if (cred instanceof String) {
            this.passwd = ((String)cred).toCharArray();
        } else if (cred instanceof char[]) {
            this.passwd = (char[])((char[])cred).clone();
        } else if (cred != null) {
            String orig = new String((byte[])cred, "UTF8");
            this.passwd = orig.toCharArray();
        }
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof NameCallback) {
                ((NameCallback)callbacks[i]).setName(this.authenticationID);
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                ((PasswordCallback)callbacks[i]).setPassword(this.passwd);
                continue;
            }
            if (callbacks[i] instanceof RealmChoiceCallback) {
                String[] choices = ((RealmChoiceCallback)callbacks[i]).getChoices();
                int selected = 0;
                if (this.authRealm != null && this.authRealm.length() > 0) {
                    selected = -1;
                    for (int j = 0; j < choices.length; ++j) {
                        if (!choices[j].equals(this.authRealm)) continue;
                        selected = j;
                    }
                    if (selected == -1) {
                        StringBuffer allChoices = new StringBuffer();
                        for (int j = 0; j < choices.length; ++j) {
                            allChoices.append(choices[j] + ",");
                        }
                        throw new IOException("Cannot match 'java.naming.security.sasl.realm' property value, '" + this.authRealm + "' with choices " + allChoices + "in RealmChoiceCallback");
                    }
                }
                ((RealmChoiceCallback)callbacks[i]).setSelectedIndex(selected);
                continue;
            }
            if (callbacks[i] instanceof RealmCallback) {
                RealmCallback rcb = (RealmCallback)callbacks[i];
                if (this.authRealm != null) {
                    rcb.setText(this.authRealm);
                    continue;
                }
                String defaultRealm = rcb.getDefaultText();
                if (defaultRealm != null) {
                    rcb.setText(defaultRealm);
                    continue;
                }
                rcb.setText("");
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i]);
        }
    }

    void clearPassword() {
        if (this.passwd != null) {
            for (int i = 0; i < this.passwd.length; ++i) {
                this.passwd[i] = '\u0000';
            }
            this.passwd = null;
        }
    }

    protected void finalize() throws Throwable {
        this.clearPassword();
    }
}

