/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.LdapCtx;
import com.sun.jndi.ldap.LdapNamingEnumeration;
import com.sun.jndi.ldap.LdapReferralContext;
import com.sun.jndi.ldap.LdapReferralException;
import com.sun.jndi.ldap.LdapResult;
import com.sun.jndi.ldap.LdapURL;
import com.sun.jndi.ldap.Obj;
import com.sun.jndi.ldap.SearchResultWithControls;
import com.sun.jndi.toolkit.ctx.Continuation;
import java.util.Vector;
import javax.naming.CompositeName;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import javax.naming.spi.DirectoryManager;

final class LdapSearchEnumeration
extends LdapNamingEnumeration {
    private Name startName;
    private LdapCtx.SearchArgs searchArgs = null;

    LdapSearchEnumeration(LdapCtx homeCtx, LdapResult search_results, String starter, LdapCtx.SearchArgs args, Continuation cont) throws NamingException {
        super(homeCtx, search_results, args.name, cont);
        this.startName = new LdapName(starter);
        this.searchArgs = args;
    }

    protected NameClassPair createItem(String dn, Attributes attrs, Vector respCtls) throws NamingException {
        String relHome;
        String relStart;
        Object obj = null;
        boolean relative = true;
        try {
            LdapName parsed = new LdapName(dn);
            if (this.startName != null && parsed.startsWith(this.startName)) {
                relStart = parsed.getSuffix(this.startName.size()).toString();
                relHome = parsed.getSuffix(this.homeCtx.currentParsedDN.size()).toString();
            } else {
                relative = false;
                relHome = relStart = LdapURL.toUrlString(this.homeCtx.hostname, this.homeCtx.port_number, dn, this.homeCtx.hasLdapsScheme);
            }
        }
        catch (NamingException e) {
            relative = false;
            relHome = relStart = LdapURL.toUrlString(this.homeCtx.hostname, this.homeCtx.port_number, dn, this.homeCtx.hasLdapsScheme);
        }
        CompositeName cn = new CompositeName();
        if (!relStart.equals("")) {
            cn.add(relStart);
        }
        CompositeName rcn = new CompositeName();
        if (!relHome.equals("")) {
            rcn.add(relHome);
        }
        this.homeCtx.setParents(attrs, rcn);
        if (this.searchArgs.cons.getReturningObjFlag()) {
            if (attrs.get(Obj.JAVA_ATTRIBUTES[2]) != null) {
                obj = Obj.decodeObject(attrs);
            }
            if (obj == null) {
                obj = new LdapCtx(this.homeCtx, dn);
            }
            try {
                obj = DirectoryManager.getObjectInstance(obj, rcn, relative ? this.homeCtx : null, this.homeCtx.envprops, attrs);
            }
            catch (NamingException e) {
                throw e;
            }
            catch (Exception e) {
                NamingException ne = new NamingException("problem generating object using object factory");
                ne.setRootCause(e);
                throw ne;
            }
            String[] reqAttrs = this.searchArgs.reqAttrs;
            if (this.searchArgs.reqAttrs != null) {
                int i;
                BasicAttributes rattrs = new BasicAttributes(true);
                for (i = 0; i < reqAttrs.length; ++i) {
                    rattrs.put(reqAttrs[i], null);
                }
                for (i = 0; i < Obj.JAVA_ATTRIBUTES.length; ++i) {
                    if (rattrs.get(Obj.JAVA_ATTRIBUTES[i]) != null) continue;
                    attrs.remove(Obj.JAVA_ATTRIBUTES[i]);
                }
            }
        }
        SearchResult sr = respCtls != null ? new SearchResultWithControls(relative ? cn.toString() : relStart, obj, attrs, relative, this.homeCtx.convertControls(respCtls)) : new SearchResult(relative ? cn.toString() : relStart, obj, attrs, relative);
        sr.setNameInNamespace(dn);
        return sr;
    }

    public void appendUnprocessedReferrals(LdapReferralException ex) {
        this.startName = null;
        super.appendUnprocessedReferrals(ex);
    }

    protected LdapNamingEnumeration getReferredResults(LdapReferralContext refCtx) throws NamingException {
        return (LdapSearchEnumeration)refCtx.search(this.searchArgs.name, this.searchArgs.filter, this.searchArgs.cons);
    }

    protected void update(LdapNamingEnumeration ne) {
        super.update(ne);
        LdapSearchEnumeration se = (LdapSearchEnumeration)ne;
        this.startName = se.startName;
    }

    void setStartName(Name nm) {
        this.startName = nm;
    }
}

