/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.internal;

import com.sun.jmx.snmp.SnmpEngineId;
import com.sun.jmx.snmp.SnmpUnknownModelLcdException;
import com.sun.jmx.snmp.SnmpUnknownSubSystemException;
import com.sun.jmx.snmp.internal.SnmpModelLcd;
import com.sun.jmx.snmp.internal.SnmpSubSystem;
import java.util.Hashtable;

public abstract class SnmpLcd {
    private Hashtable<SnmpSubSystem, SubSysLcdManager> subs = new Hashtable();

    public abstract int getEngineBoots();

    public abstract String getEngineId();

    public abstract void storeEngineBoots(int var1);

    public abstract void storeEngineId(SnmpEngineId var1);

    public void addModelLcd(SnmpSubSystem sys, int id, SnmpModelLcd lcd) {
        SubSysLcdManager subsys = this.subs.get(sys);
        if (subsys == null) {
            subsys = new SubSysLcdManager();
            this.subs.put(sys, subsys);
        }
        subsys.addModelLcd(id, lcd);
    }

    public void removeModelLcd(SnmpSubSystem sys, int id) throws SnmpUnknownModelLcdException, SnmpUnknownSubSystemException {
        SubSysLcdManager subsys = this.subs.get(sys);
        if (subsys != null) {
            SnmpModelLcd lcd = subsys.removeModelLcd(id);
            if (lcd == null) {
                throw new SnmpUnknownModelLcdException("Model : " + id);
            }
        } else {
            throw new SnmpUnknownSubSystemException(sys.toString());
        }
    }

    public SnmpModelLcd getModelLcd(SnmpSubSystem sys, int id) {
        SubSysLcdManager subsys = this.subs.get(sys);
        if (subsys == null) {
            return null;
        }
        return subsys.getModelLcd(id);
    }

    class SubSysLcdManager {
        private Hashtable<Integer, SnmpModelLcd> models = new Hashtable();

        SubSysLcdManager() {
        }

        public void addModelLcd(int id, SnmpModelLcd usmlcd) {
            this.models.put(new Integer(id), usmlcd);
        }

        public SnmpModelLcd getModelLcd(int id) {
            return this.models.get(new Integer(id));
        }

        public SnmpModelLcd removeModelLcd(int id) {
            return this.models.remove(new Integer(id));
        }
    }
}

