/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.daemon;

import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.agent.SnmpMibAgent;
import java.util.Enumeration;
import java.util.Vector;

final class SnmpMibTree {
    private SnmpMibAgent defaultAgent = null;
    private TreeNode root = new TreeNode(-1L, null, null);

    public void setDefaultAgent(SnmpMibAgent def) {
        this.defaultAgent = def;
        this.root.agent = def;
    }

    public SnmpMibAgent getDefaultAgent() {
        return this.defaultAgent;
    }

    public void register(SnmpMibAgent agent2) {
        this.root.registerNode(agent2);
    }

    public void register(SnmpMibAgent agent2, long[] oid) {
        this.root.registerNode(oid, 0, agent2);
    }

    public SnmpMibAgent getAgentMib(SnmpOid oid) {
        TreeNode node = this.root.retrieveMatchingBranch(oid.longValue(), 0);
        if (node == null) {
            return this.defaultAgent;
        }
        if (node.getAgentMib() == null) {
            return this.defaultAgent;
        }
        return node.getAgentMib();
    }

    public void unregister(SnmpMibAgent agent2, SnmpOid[] oids) {
        for (int i = 0; i < oids.length; ++i) {
            long[] oid = oids[i].longValue();
            TreeNode node = this.root.retrieveMatchingBranch(oid, 0);
            if (node == null) continue;
            node.removeAgent(agent2);
        }
    }

    public void unregister(SnmpMibAgent agent2) {
        this.root.removeAgentFully(agent2);
    }

    public void printTree() {
        this.root.printTree(">");
    }

    final class TreeNode {
        private Vector<TreeNode> children = new Vector();
        private Vector<SnmpMibAgent> agents = new Vector();
        private long nodeValue;
        private SnmpMibAgent agent;
        private TreeNode parent;

        void registerNode(SnmpMibAgent agent2) {
            long[] oid = agent2.getRootOid();
            this.registerNode(oid, 0, agent2);
        }

        TreeNode retrieveMatchingBranch(long[] oid, int cursor) {
            TreeNode node = this.retrieveChild(oid, cursor);
            if (node == null) {
                return this;
            }
            if (this.children.size() == 0) {
                return node;
            }
            if (cursor + 1 == oid.length) {
                return node;
            }
            TreeNode n = node.retrieveMatchingBranch(oid, cursor + 1);
            return n.agent == null ? this : n;
        }

        SnmpMibAgent getAgentMib() {
            return this.agent;
        }

        public void printTree(String ident) {
            StringBuffer buff = new StringBuffer();
            if (this.agents == null) {
                return;
            }
            Enumeration<Object> e = this.agents.elements();
            while (e.hasMoreElements()) {
                SnmpMibAgent mib = e.nextElement();
                if (mib == null) {
                    buff.append("empty ");
                    continue;
                }
                buff.append(mib.getMibName() + " ");
            }
            ident = ident + " ";
            if (this.children == null) {
                return;
            }
            e = this.children.elements();
            while (e.hasMoreElements()) {
                TreeNode node = (TreeNode)e.nextElement();
                node.printTree(ident);
            }
        }

        private TreeNode(long nodeValue, SnmpMibAgent agent2, TreeNode sup) {
            this.nodeValue = nodeValue;
            this.parent = sup;
            this.agents.addElement(agent2);
        }

        private void removeAgentFully(SnmpMibAgent agent2) {
            Vector<TreeNode> v = new Vector<TreeNode>();
            Enumeration<TreeNode> e = this.children.elements();
            while (e.hasMoreElements()) {
                TreeNode node = e.nextElement();
                node.removeAgentFully(agent2);
                if (!node.agents.isEmpty()) continue;
                v.add(node);
            }
            e = v.elements();
            while (e.hasMoreElements()) {
                this.children.removeElement(e.nextElement());
            }
            this.removeAgent(agent2);
        }

        private void removeAgent(SnmpMibAgent mib) {
            if (!this.agents.contains(mib)) {
                return;
            }
            this.agents.removeElement(mib);
            if (!this.agents.isEmpty()) {
                this.agent = this.agents.firstElement();
            }
        }

        private void setAgent(SnmpMibAgent agent2) {
            this.agent = agent2;
        }

        private void registerNode(long[] oid, int cursor, SnmpMibAgent agent2) {
            if (cursor >= oid.length) {
                return;
            }
            TreeNode child = this.retrieveChild(oid, cursor);
            if (child == null) {
                long theValue = oid[cursor];
                child = new TreeNode(theValue, agent2, this);
                this.children.addElement(child);
            } else if (!this.agents.contains(agent2)) {
                this.agents.addElement(agent2);
            }
            if (cursor == oid.length - 1) {
                child.setAgent(agent2);
            } else {
                child.registerNode(oid, cursor + 1, agent2);
            }
        }

        private TreeNode retrieveChild(long[] oid, int current) {
            long theValue = oid[current];
            Enumeration<TreeNode> e = this.children.elements();
            while (e.hasMoreElements()) {
                TreeNode node = e.nextElement();
                if (!node.match(theValue)) continue;
                return node;
            }
            return null;
        }

        private final boolean match(long value) {
            return this.nodeValue == value;
        }
    }
}

