/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.agent;

final class LongList {
    public static int DEFAULT_CAPACITY = 10;
    public static int DEFAULT_INCREMENT = 10;
    private final int DELTA;
    private int size = 0;
    public long[] list;

    LongList() {
        this(DEFAULT_CAPACITY, DEFAULT_INCREMENT);
    }

    LongList(int initialCapacity) {
        this(initialCapacity, DEFAULT_INCREMENT);
    }

    LongList(int initialCapacity, int delta) {
        this.DELTA = delta;
        this.list = this.allocate(initialCapacity);
    }

    public final int size() {
        return this.size;
    }

    public final boolean add(long o) {
        if (this.size >= this.list.length) {
            this.resize();
        }
        this.list[this.size++] = o;
        return true;
    }

    public final void add(int index, long o) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        if (index >= this.list.length) {
            this.resize();
        }
        if (index == this.size) {
            this.list[this.size++] = o;
            return;
        }
        System.arraycopy(this.list, index, this.list, index + 1, this.size - index);
        this.list[index] = o;
        ++this.size;
    }

    public final void add(int at, long[] src, int from, int count) {
        if (count <= 0) {
            return;
        }
        if (at > this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.ensure(this.size + count);
        if (at < this.size) {
            System.arraycopy(this.list, at, this.list, at + count, this.size - at);
        }
        System.arraycopy(src, from, this.list, at, count);
        this.size += count;
    }

    public final long remove(int from, int count) {
        if (count < 1 || from < 0) {
            return -1L;
        }
        if (from + count > this.size) {
            return -1L;
        }
        long o = this.list[from];
        int oldsize = this.size;
        this.size -= count;
        if (from == this.size) {
            return o;
        }
        System.arraycopy(this.list, from + count, this.list, from, this.size - from);
        return o;
    }

    public final long remove(int index) {
        if (index >= this.size) {
            return -1L;
        }
        long o = this.list[index];
        this.list[index] = 0L;
        if (index == --this.size) {
            return o;
        }
        System.arraycopy(this.list, index + 1, this.list, index, this.size - index);
        return o;
    }

    public final long[] toArray(long[] a) {
        System.arraycopy(this.list, 0, a, 0, this.size);
        return a;
    }

    public final long[] toArray() {
        return this.toArray(new long[this.size]);
    }

    private final void resize() {
        long[] newlist = this.allocate(this.list.length + this.DELTA);
        System.arraycopy(this.list, 0, newlist, 0, this.size);
        this.list = newlist;
    }

    private final void ensure(int length) {
        if (this.list.length < length) {
            int min = this.list.length + this.DELTA;
            length = length < min ? min : length;
            long[] newlist = this.allocate(length);
            System.arraycopy(this.list, 0, newlist, 0, this.size);
            this.list = newlist;
        }
    }

    private final long[] allocate(int length) {
        return new long[length];
    }
}

