/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.snmp.BerDecoder;
import com.sun.jmx.snmp.BerEncoder;
import com.sun.jmx.snmp.BerException;
import com.sun.jmx.snmp.SnmpDefinitions;
import com.sun.jmx.snmp.SnmpIpAddress;
import com.sun.jmx.snmp.SnmpMsg;
import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpPdu;
import com.sun.jmx.snmp.SnmpPduBulk;
import com.sun.jmx.snmp.SnmpPduPacket;
import com.sun.jmx.snmp.SnmpPduRequest;
import com.sun.jmx.snmp.SnmpPduTrap;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpTooBigException;
import java.util.logging.Level;

public class SnmpMessage
extends SnmpMsg
implements SnmpDefinitions {
    public byte[] community;

    public int encodeMessage(byte[] outputBytes) throws SnmpTooBigException {
        int encodingLength = 0;
        if (this.data == null) {
            throw new IllegalArgumentException("Data field is null");
        }
        try {
            BerEncoder benc = new BerEncoder(outputBytes);
            benc.openSequence();
            benc.putAny(this.data, this.dataLength);
            benc.putOctetString(this.community != null ? this.community : new byte[]{});
            benc.putInteger(this.version);
            benc.closeSequence();
            encodingLength = benc.trim();
        }
        catch (ArrayIndexOutOfBoundsException x) {
            throw new SnmpTooBigException();
        }
        return encodingLength;
    }

    public int getRequestId(byte[] inputBytes) throws SnmpStatusException {
        int requestId = 0;
        BerDecoder bdec = null;
        BerDecoder bdec2 = null;
        byte[] any = null;
        try {
            bdec = new BerDecoder(inputBytes);
            bdec.openSequence();
            bdec.fetchInteger();
            bdec.fetchOctetString();
            any = bdec.fetchAny();
            bdec2 = new BerDecoder(any);
            int type = bdec2.getTag();
            bdec2.openSequence(type);
            requestId = bdec2.fetchInteger();
        }
        catch (BerException x) {
            throw new SnmpStatusException("Invalid encoding");
        }
        try {
            bdec.closeSequence();
        }
        catch (BerException x) {
            // empty catch block
        }
        try {
            bdec2.closeSequence();
        }
        catch (BerException x) {
            // empty catch block
        }
        return requestId;
    }

    public void decodeMessage(byte[] inputBytes, int byteCount) throws SnmpStatusException {
        try {
            BerDecoder bdec = new BerDecoder(inputBytes);
            bdec.openSequence();
            this.version = bdec.fetchInteger();
            this.community = bdec.fetchOctetString();
            this.data = bdec.fetchAny();
            this.dataLength = this.data.length;
            bdec.closeSequence();
        }
        catch (BerException x) {
            throw new SnmpStatusException("Invalid encoding");
        }
    }

    public void encodeSnmpPdu(SnmpPdu pdu, int maxDataLength) throws SnmpStatusException, SnmpTooBigException {
        SnmpPduPacket pdupacket = (SnmpPduPacket)pdu;
        this.version = pdupacket.version;
        this.community = pdupacket.community;
        this.address = pdupacket.address;
        this.port = pdupacket.port;
        this.data = new byte[maxDataLength];
        try {
            BerEncoder benc = new BerEncoder(this.data);
            benc.openSequence();
            this.encodeVarBindList(benc, pdupacket.varBindList);
            switch (pdupacket.type) {
                case 1: 
                case 2: 
                case 4: 
                case 6: 
                case 7: 
                case 9: 
                case 10: {
                    SnmpPduRequest reqPdu = (SnmpPduRequest)pdupacket;
                    benc.putInteger(reqPdu.errorIndex);
                    benc.putInteger(reqPdu.errorStatus);
                    benc.putInteger(reqPdu.requestId);
                    break;
                }
                case 8: {
                    SnmpPduBulk bulkPdu = (SnmpPduBulk)pdupacket;
                    benc.putInteger(bulkPdu.maxRepetitions);
                    benc.putInteger(bulkPdu.nonRepeaters);
                    benc.putInteger(bulkPdu.requestId);
                    break;
                }
                case 5: {
                    SnmpPduTrap trapPdu = (SnmpPduTrap)pdupacket;
                    benc.putInteger(trapPdu.timeStamp, 31);
                    benc.putInteger(trapPdu.specificTrap);
                    benc.putInteger(trapPdu.genericTrap);
                    if (trapPdu.agentAddr != null) {
                        benc.putOctetString(trapPdu.agentAddr.byteValue(), 1);
                    } else {
                        benc.putOctetString(new byte[0], 1);
                    }
                    benc.putOid(trapPdu.enterprise.longValue());
                    break;
                }
                default: {
                    throw new SnmpStatusException("Invalid pdu type " + String.valueOf(pdupacket.type));
                }
            }
            benc.closeSequence(pdupacket.type);
            this.dataLength = benc.trim();
        }
        catch (ArrayIndexOutOfBoundsException x) {
            throw new SnmpTooBigException();
        }
    }

    public SnmpPdu decodeSnmpPdu() throws SnmpStatusException {
        SnmpPduPacket pdu = null;
        BerDecoder bdec = new BerDecoder(this.data);
        try {
            int type = bdec.getTag();
            bdec.openSequence(type);
            switch (type) {
                case 1: 
                case 2: 
                case 4: 
                case 6: 
                case 7: 
                case 9: 
                case 10: {
                    SnmpPduRequest reqPdu = new SnmpPduRequest();
                    reqPdu.requestId = bdec.fetchInteger();
                    reqPdu.errorStatus = bdec.fetchInteger();
                    reqPdu.errorIndex = bdec.fetchInteger();
                    pdu = reqPdu;
                    break;
                }
                case 8: {
                    SnmpPduBulk bulkPdu = new SnmpPduBulk();
                    bulkPdu.requestId = bdec.fetchInteger();
                    bulkPdu.nonRepeaters = bdec.fetchInteger();
                    bulkPdu.maxRepetitions = bdec.fetchInteger();
                    pdu = bulkPdu;
                    break;
                }
                case 5: {
                    SnmpPduTrap trapPdu = new SnmpPduTrap();
                    trapPdu.enterprise = new SnmpOid(bdec.fetchOid());
                    byte[] b = bdec.fetchOctetString(1);
                    trapPdu.agentAddr = b.length != 0 ? new SnmpIpAddress(b) : null;
                    trapPdu.genericTrap = bdec.fetchInteger();
                    trapPdu.specificTrap = bdec.fetchInteger();
                    trapPdu.timeStamp = bdec.fetchInteger(31);
                    pdu = trapPdu;
                    break;
                }
                default: {
                    throw new SnmpStatusException(0);
                }
            }
            pdu.type = type;
            pdu.varBindList = this.decodeVarBindList(bdec);
            bdec.closeSequence();
        }
        catch (BerException e) {
            if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_LOGGER.logp(Level.FINEST, SnmpMessage.class.getName(), "decodeSnmpPdu", "BerException", e);
            }
            throw new SnmpStatusException(0);
        }
        catch (IllegalArgumentException e) {
            if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_LOGGER.logp(Level.FINEST, SnmpMessage.class.getName(), "decodeSnmpPdu", "IllegalArgumentException", e);
            }
            throw new SnmpStatusException(0);
        }
        pdu.version = this.version;
        pdu.community = this.community;
        pdu.address = this.address;
        pdu.port = this.port;
        return pdu;
    }

    public String printMessage() {
        StringBuffer sb = new StringBuffer();
        if (this.community == null) {
            sb.append("Community: null");
        } else {
            sb.append("Community: {\n");
            sb.append(SnmpMessage.dumpHexBuffer(this.community, 0, this.community.length));
            sb.append("\n}\n");
        }
        return sb.append(super.printMessage()).toString();
    }
}

