/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

abstract class SimpleEUCDecoder
extends CharsetDecoder {
    private final int SS2 = 142;
    private final int SS3 = 143;
    protected static String mappingTableG1;
    protected static String byteToCharTable;

    protected SimpleEUCDecoder(Charset cs) {
        super(cs, 0.5f, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult decodeArrayLoop(ByteBuffer src, CharBuffer dst) {
        byte[] sa = src.array();
        int sp = src.arrayOffset() + src.position();
        int sl = src.arrayOffset() + src.limit();
        assert (sp <= sl);
        char[] da = dst.array();
        int dp = dst.arrayOffset() + dst.position();
        int dl = dst.arrayOffset() + dst.limit();
        assert (dp <= dl);
        dp = dp <= dl ? dp : dl;
        try {
            int inputSize;
            for (sp = sp <= sl ? sp : sl; sp < sl; sp += inputSize) {
                inputSize = 1;
                int outputChar = 65533;
                int byte1 = sa[sp] & 0xFF;
                if (byte1 <= 159) {
                    if (byte1 == 142 || byte1 == 143) {
                        CoderResult coderResult = CoderResult.malformedForLength(1);
                        return coderResult;
                    }
                    outputChar = byteToCharTable.charAt(byte1);
                } else {
                    if (byte1 < 161 || byte1 > 254) {
                        CoderResult coderResult = CoderResult.malformedForLength(1);
                        return coderResult;
                    }
                    if (sl - sp < 2) {
                        CoderResult coderResult = CoderResult.UNDERFLOW;
                        return coderResult;
                    }
                    int byte2 = sa[sp + 1] & 0xFF;
                    ++inputSize;
                    if (byte2 < 161 || byte2 > 254) {
                        CoderResult coderResult = CoderResult.malformedForLength(2);
                        return coderResult;
                    }
                    outputChar = mappingTableG1.charAt((byte1 - 161) * 94 + byte2 - 161);
                }
                if (outputChar == 65533) {
                    CoderResult coderResult = CoderResult.unmappableForLength(inputSize);
                    return coderResult;
                }
                if (dl - dp < 1) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                da[dp++] = outputChar;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            src.position(sp - src.arrayOffset());
            dst.position(dp - dst.arrayOffset());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult decodeBufferLoop(ByteBuffer src, CharBuffer dst) {
        int mark = src.position();
        try {
            while (src.hasRemaining()) {
                char outputChar = '\ufffd';
                int inputSize = 1;
                int byte1 = src.get() & 0xFF;
                if (byte1 <= 159) {
                    if (byte1 == 142 || byte1 == 143) {
                        CoderResult coderResult = CoderResult.malformedForLength(1);
                        return coderResult;
                    }
                    outputChar = byteToCharTable.charAt(byte1);
                } else {
                    if (byte1 < 161 || byte1 > 254) {
                        CoderResult coderResult = CoderResult.malformedForLength(1);
                        return coderResult;
                    }
                    if (!src.hasRemaining()) {
                        CoderResult coderResult = CoderResult.UNDERFLOW;
                        return coderResult;
                    }
                    int byte2 = src.get() & 0xFF;
                    ++inputSize;
                    if (byte2 < 161 || byte2 > 254) {
                        CoderResult coderResult = CoderResult.malformedForLength(2);
                        return coderResult;
                    }
                    outputChar = mappingTableG1.charAt((byte1 - 161) * 94 + byte2 - 161);
                }
                if (outputChar == '\ufffd') {
                    CoderResult coderResult = CoderResult.unmappableForLength(inputSize);
                    return coderResult;
                }
                if (!dst.hasRemaining()) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                dst.put(outputChar);
                mark += inputSize;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            src.position(mark);
        }
    }

    protected CoderResult decodeLoop(ByteBuffer src, CharBuffer dst) {
        if (src.hasArray() && dst.hasArray()) {
            return this.decodeArrayLoop(src, dst);
        }
        return this.decodeBufferLoop(src, dst);
    }
}

