/*
 * Decompiled with CFR 0.152.
 */
package org.classpath.icedtea.pulseaudio;

import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.Control;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;

abstract class PulseAudioLine
implements Line {
    protected List<LineListener> lineListeners = new ArrayList<LineListener>();
    protected List<Control> controls = new ArrayList<Control>();
    protected boolean isOpen = false;

    PulseAudioLine() {
    }

    @Override
    public void addLineListener(LineListener listener) {
        this.lineListeners.add(listener);
    }

    @Override
    public void close() {
        if (!this.isOpen) {
            throw new IllegalStateException("Line is not open");
        }
        this.lineListeners.clear();
        this.isOpen = false;
    }

    protected void fireLineEvent(LineEvent e) {
        for (LineListener lineListener : this.lineListeners) {
            lineListener.update(e);
        }
    }

    @Override
    public Control getControl(Control.Type control) {
        if (this.isOpen) {
            for (Control aControl : this.controls) {
                if (aControl.getType() != control) continue;
                return aControl;
            }
        }
        throw new IllegalArgumentException(control.toString() + " not supported");
    }

    @Override
    public Control[] getControls() {
        if (!this.isOpen) {
            return new Control[0];
        }
        return this.controls.toArray(new Control[0]);
    }

    @Override
    public boolean isControlSupported(Control.Type control) {
        for (Control myControl : this.controls) {
            if (myControl.getType().getClass() != control.getClass()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void removeLineListener(LineListener listener) {
        this.lineListeners.remove(listener);
    }
}

