/****************************************************************************
**
** This file is part of the Hyves PhoneGap container.
** Copyright (C) 2010-2011 Hyves (Startphone Ltd.)
** http://www.hyves.nl
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

#ifndef ANIMATEDSTACKEDWIDGET_H
#define ANIMATEDSTACKEDWIDGET_H

#include <QWidget>

class QStackedLayout;

class AnimatedStackedWidget : public QWidget
{
    Q_OBJECT

public:
    explicit AnimatedStackedWidget(QWidget *parent = 0);

    int addWidget(QWidget *widget);
    int currentIndex() const;
    QWidget *currentWidget() const;
    int insertWidget(int index, QWidget *widget);
    QWidget *widget(int index) const;

signals:
    void currentChanged(int index);
    void widgetRemoved(int index);

public slots:
    void setCurrentIndex(int index);
    void setCurrentWidget(QWidget *widget);

private slots:
    void animationFinished();

private:
    QStackedLayout *m_layout;
};

#endif // ANIMATEDSTACKEDWIDGET_H
