#include "mainwindow.h"
#include "gapapplication.h"

#ifdef Q_WS_MAEMO_5
#include <QLocale>
#include <QSettings>
#include <QTranslator>
#endif


#if defined(Q_WS_S60)
bool qt_sendSpontaneousEvent(QObject *receiver, QEvent *event) {

    return QCoreApplication::sendSpontaneousEvent(receiver, event);
}
#endif

int main(int argc, char *argv[]) {

#if !defined(Q_WS_S60) && !defined(Q_WS_MAEMO_5)
    QApplication::setGraphicsSystem("raster");
#endif

    GapApplication app(argc, argv);
    app.setOrganizationDomain("www.hyves.nl");
    app.setOrganizationName("Hyves");
    app.setApplicationName("Hyves");
    app.setApplicationVersion("1.0.8");

#ifdef Q_WS_MAEMO_5
    // try to get the user's language from settings (format is <language>_<Country>, e.g. en_US)
    // if not set fall back to system language...
    QString lang = QSettings().value("locale", QLocale::system().name()).toString();
    QTranslator translator;
    if (!translator.load("hyves." + lang, "/usr/share/hyves/translations")) {
        qDebug("Failed to load language file, using default: en_US");
        translator.load("hyves.en_US", "/usr/share/hyves/translations");
    }
    app.installTranslator(&translator);
#endif

    MainWindow window;
#if defined(Q_OS_SYMBIAN)
    window.showFullScreen();
#elif defined(Q_WS_MAEMO_5)
    window.showMaximized();
#else
    window.resize(360, 640);
    window.show();
#endif

#if defined(QT_KEYPAD_NAVIGATION)
    QApplication::setNavigationMode(Qt::NavigationModeCursorAuto);
#endif

    return app.exec();
}
