// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDON_FMMM_FILE_DETAILS_DIALOG_H
#define _HILDON_FMMM_FILE_DETAILS_DIALOG_H


#include <glibmm.h>

/*
 * Copyright (c) 2006-2009  The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtkmm/dialog.h>
#include <gtkmm/treemodel.h>
#include <hildon-fmmm/file-system-model.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonFileDetailsDialog HildonFileDetailsDialog;
typedef struct _HildonFileDetailsDialogClass HildonFileDetailsDialogClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class FileDetailsDialog_Class; } // namespace Hildon
namespace Hildon
{

/** The Hildon::FileDetailsDialog is a dialog to show file information.
 * It has two tabs:
 * - One tab contains the file name, size, last modification date and some general information.
 * - One tab is for the use of applications. It might show, for example, the line count,
 *   preview of a document or length of a sound.
 *
 * This dialog is used not only in the file manager application, but also in all kinds
 * of applications with user files, such as editors and viewers.
 *
 * The additional tab can be set via the additional-tab and additional-tab-label properties. 
 *
 * @ingroup HildonDialogs
 */

class FileDetailsDialog : public Gtk::Dialog
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef FileDetailsDialog CppObjectType;
  typedef FileDetailsDialog_Class CppClassType;
  typedef HildonFileDetailsDialog BaseObjectType;
  typedef HildonFileDetailsDialogClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~FileDetailsDialog();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class FileDetailsDialog_Class;
  static CppClassType filedetailsdialog_class_;

  // noncopyable
  FileDetailsDialog(const FileDetailsDialog&);
  FileDetailsDialog& operator=(const FileDetailsDialog&);

protected:
  explicit FileDetailsDialog(const Glib::ConstructParams& construct_params);
  explicit FileDetailsDialog(HildonFileDetailsDialog* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonFileDetailsDialog*       gobj()       { return reinterpret_cast<HildonFileDetailsDialog*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonFileDetailsDialog* gobj() const { return reinterpret_cast<HildonFileDetailsDialog*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

  
public:
  /** This a preferred way to create a Hildon::FileDetailsDialog.
   * You can use a shared model structure to save loading times
   * (because you probably already have one at your disposal).
   *
   * @param parent The parent window.
   * @param model a Hildon::FileSystemModel object used to fetch data
   */
  FileDetailsDialog(Gtk::Window& parent, const Glib::RefPtr<FileSystemModel>& model);

  /** This a preferred way to create a Hildon::FileDetailsDialog.
   * You can use a shared model structure to save loading times
   * (because you probably already have one at your disposal).
   *
   * @param model a Hildon::FileSystemModel object used to fetch data
   */
  explicit FileDetailsDialog(const Glib::RefPtr<FileSystemModel>& model);

  
  /** Sets the dialog to display information about a file defined by
   * given iterator.
   * @param iter A Gtk::TreeIter pointing to desired file.
   */
  void set_file_iter(const Gtk::TreeModel::iterator& iter);

  /** Gets an iterator pointing to the item for the displayed file in the Hildon::FileSystemModel.
   *
   * @result An iterator to the displayed file.
   */
  Gtk::TreeModel::iterator get_file_iter();
  

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Do we want to show the tab label.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_show_tabs() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Do we want to show the tab label.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_show_tabs() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Tab to show additinal information.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Gtk::Widget*> property_additional_tab() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Tab to show additinal information.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Gtk::Widget*> property_additional_tab() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Label to the additional tab.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_additional_tab_label() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Label to the additional tab.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_additional_tab_label() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** HildonFileSystemModel to use when fetching information.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<FileSystemModel> > property_model() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** HildonFileSystemModel to use when fetching information.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<FileSystemModel> > property_model() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether or not to enable the read-only checkbox.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_enable_read_only_checkbox() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether or not to enable the read-only checkbox.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_enable_read_only_checkbox() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether or not to show the file icon next to the file type.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_show_type_icon() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether or not to show the file icon next to the file type.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_show_type_icon() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} // namespace Hildon


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Hildon::FileDetailsDialog
   */
  Hildon::FileDetailsDialog* wrap(HildonFileDetailsDialog* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDON_FMMM_FILE_DETAILS_DIALOG_H */

