import gtk, hildon

class SearchableList(hildon.PannableArea):
    """Widget which exposes a TreeView with find-as-you-type features.
         
       Copyright (c) Andrew Flegg <andrew@bleb.org> 2010.
       Released under the Artistic Licence."""
    
    
    # -----------------------------------------------------------------------
    def __init__(self, search_column):
        """Constructor. Passed a search column - expected to be exposed from
           a subclass.

           Subclasses must also initialise self.treestore, self.treeview and
           then do self.add(self.treeview)."""
        
        hildon.PannableArea.__init__(self)
        self._search_column = search_column
        self.set_size_request_policy(hildon.SIZE_REQUEST_CHILDREN)

        self.hbox_entry_filter = None


    # -----------------------------------------------------------------------
    def get_search(self):
        """Return a search box. If added to the tree will handle filtering this
           treeview automatically."""

        self.hbox_entry_filter = gtk.VBox()
        real_hbox = gtk.HBox()
        self.hbox_entry_filter.pack_end(real_hbox, False, False)

        self.entry_filter = hildon.Entry(gtk.HILDON_SIZE_FINGER_HEIGHT)
        self.entry_filter.connect('changed', lambda w: self.filter.refilter())
        real_hbox.pack_start(self.entry_filter, True, True)

        #close = hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL, title = _('Show all'))
        #close.connect('clicked', self._hide_search)
        #real_hbox.pack_end(close, False, False, 0)

        (path, col) = self.treeview.get_cursor()
        self.filter = self.treeview.get_model().filter_new()
        self.filter.set_visible_func(self._visible_func, self._search_column)
        self.treeview.connect('key-press-event', self._on_key_press)
        self.treeview.set_model(self.filter)
        if path:
            self.treeview.scroll_to_cell(path)
        real_hbox.show_all()

        return self.hbox_entry_filter



    # -----------------------------------------------------------------------
    def _on_key_press(self, treeview, event):
        if event.keyval == gtk.keysyms.Escape or event.keyval == gtk.keysyms.BackSpace:
            self._hide_search()
        elif event.state & gtk.gdk.CONTROL_MASK:
            # Don't handle type-ahead when control is pressed (so shortcuts
            # with the Ctrl key still work, e.g. Ctrl+A, ...)
            return True
        else:
            unicode_char_id = gtk.gdk.keyval_to_unicode(event.keyval)
            if unicode_char_id == 0:
                return False
            input_char = unichr(unicode_char_id)
            self._show_search(input_char)
        return True



    # -----------------------------------------------------------------------
    def _visible_func(self, model, iter, column):
        text = self.entry_filter.get_text().lower()
        if not self.hbox_entry_filter.get_property('visible'):
            return True
        elif text == '':
            self._hide_search()
            return True
        else:
            value = model.get_value(iter, column).lower()
            return text in value

    
    # -----------------------------------------------------------------------
    def _hide_search(self, *args):
        self.hbox_entry_filter.hide()
        self.entry_filter.set_text('')
        self.filter.refilter()
        self.treeview.grab_focus()


    # -----------------------------------------------------------------------
    def _show_search(self, input_char):
        self.hbox_entry_filter.show_all()
        self.entry_filter.insert_text(input_char, -1)
        self.entry_filter.grab_focus()
        self.entry_filter.set_position(-1)

