import hildon
import gtk, gobject, glib
import gettext
import gnome.gconf

class AccountsDialogue:
    """Show a dialogue box containing the provided accounts, and their
       configuration information. Clicking on a provider will open
       its dialogue box, if any, or toggle enablement if not.
         
       Copyright (c) Andrew Flegg <andrew@bleb.org> 2010.
       Released under the Artistic Licence."""

    # -----------------------------------------------------------------------
    def __init__(self, window, providers):
        """Constructor. Passed a parent window, and a list of Providers."""

        self.window    = window
        self.providers = providers
        self.gconf     = gnome.gconf.client_get_default()

        self.account_color = self._get_color('ActiveTextColor')
        self.tick_icon     = gtk.icon_theme_get_default().load_icon('widgets_tickmark_list', 48, 0)
        self.icons         = {}

        for provider in providers:
            try:
                self.icons[provider.get_name()] = gtk.gdk.pixbuf_new_from_file('/opt/hermes/share/account-%s.png' % (provider.get_id()))
            except glib.GError, e:
                self.icons[provider.get_name()] = None
                print "Couldn't find icon:", e.message



    # -----------------------------------------------------------------------
    def show(self):
        """Show the dialogue and handle clicks appropriately."""

        # -- Initialise the Gtk components...
        #
        dialog = gtk.Dialog(_('Accounts'), self.window)
        dialog.add_button(_('Save'), gtk.RESPONSE_OK)

        parea = hildon.PannableArea()
        store = gtk.ListStore(gtk.gdk.Pixbuf, str, str, gtk.gdk.Pixbuf, gobject.TYPE_PYOBJECT)

        # -- Populate the model...
        #
        for provider in self.providers:
            name = provider.get_name()
            enabled = self.gconf.get_bool('/apps/maemo/hermes/use_%s' % (provider.get_id()))
            store.append(row = [self.icons[name],
                                name,
                                provider.get_account_detail(),
                                enabled and self.tick_icon or None,
                                provider])

        # -- Build the TreeView...
        #
        view = gtk.TreeView(store)
        view.append_column(gtk.TreeViewColumn('Logo', gtk.CellRendererPixbuf(), pixbuf = 0))

        tvcolumn = gtk.TreeViewColumn('Name', gtk.CellRendererText(), text = 1)
        tvcolumn.set_expand(True)
        view.append_column(tvcolumn)

        renderer = gtk.CellRendererText()
        renderer.set_property('foreground-gdk', self.account_color)
        renderer.set_property('scale', 0.75)
        tvcolumn = gtk.TreeViewColumn('Account', renderer, text = 2)
        tvcolumn.set_expand(False)
        view.append_column(tvcolumn)

        view.append_column(gtk.TreeViewColumn('Enabled', gtk.CellRendererPixbuf(), pixbuf = 3))
        view.connect('row-activated', self._activated)

        parea.set_size_request_policy(hildon.SIZE_REQUEST_CHILDREN)
        parea.add(view)

        self.dialog = dialog
        dialog.vbox.add(parea)
        dialog.show_all()
        dialog.run() # We actually always Save. Bad, I know.
        dialog.hide()


    # -----------------------------------------------------------------------
    def _activated(self, treeview, path, column):
        """A row's been selected. Open its preferences dialogue if any,
           otherwise just toggle its enabled status."""

        iter      = treeview.get_model().get_iter(path)
        provider  = treeview.get_model().get_value(iter, 4)
        use_key   = '/apps/maemo/hermes/use_%s' % (provider.get_id())

        enabled = not self.gconf.get_bool(use_key)
        if provider.has_preferences():
            enabled = provider.open_preferences(self.dialog)

        if enabled is not None:
            self.gconf.set_bool(use_key, enabled)
            treeview.get_model().set_value(iter, 2, provider.get_account_detail())
            treeview.get_model().set_value(iter, 3, enabled and self.tick_icon or None)


    # -----------------------------------------------------------------------
    def _get_color(self, logicalcolorname):
        """Return the colour definition for 'logicalcolorname' in the standard
           styles. This is typically used for getting  'ActiveTextColor', which
           appears as blue in the default theme on Maemo 5."""

        settings = gtk.settings_get_default()
        color_style = gtk.rc_get_style_by_paths(settings, 'GtkButton', \
                                                          'osso-logical-colors', gtk.Button)
        return color_style.lookup_color(logicalcolorname)

