import re

class PhoneNumber():
    """Encapsulate a phone number.
    
       Copyright (c) Andrew Flegg <andrew@bleb.org> 2010.
       Released under the Artistic Licence."""

    
    def __init__(self, number, device=None, type=None, country=None):
        """Store a phone number.
        
             'device' can be one of: None, 'landline', 'mobile'
             'type' can be one of: None, 'home', 'work'
             'country' can be a two-character ISO-3166 country code.
        """
        
        self._country = country and country.lower() or None
        self._number  = _build_number(number, self._country)
        self._device  = device
        self._type    = type
    
    # -----------------------------------------------------------------------
    def __repr__(self):
        device = self._device
        type = self._type
        if device and type:
            return "Tel (%s %s): %s" % (type, device, self.get_number())
        if device or type:
            return "Tel (%s): %s" % (type or device, self.get_number())
        return "Tel: %s" % self.get_number()

    
    # -----------------------------------------------------------------------
    def get_device(self):
        """Return the device type. Can be one of None, 'landline' or 'mobile'."""
        
        return self._device

    
    # -----------------------------------------------------------------------
    def get_type(self):
        """Return the number type. Can be one of None, 'home' or 'work'.""" 
        
        return self._type

    
    # -----------------------------------------------------------------------
    def get_country(self):
        """Return the country type.""" 
        
        return self._country

    
    # -----------------------------------------------------------------------
    def get_number(self):
        """Return the number, turning it into an international format
           if possible.""" 
        
        return self._number


# -----------------------------------------------------------------------
_stripre = re.compile(r'[^\dp#\*]+')
_dropre  = re.compile(r'^0')

def _build_number(number, country):
    """Return the number, turning it into an international format
       if possible."""
       
    clean_number = _stripre.sub('', number)
    dropped_zero = _dropre.sub('', clean_number)
    if number.startswith('+'):
        return '+%s' % (clean_number)
    if country == 'af':
        return '+93%s' % (clean_number)
    if country == 'al':
        return '+355%s' % (clean_number)
    if country == 'dz':
        return '+213%s' % (clean_number)
    if country == 'ad':
        return '+376%s' % (clean_number)
    if country == 'ao':
        return '+244%s' % (clean_number)
    if country == 'aq':
        return '+672%s' % (clean_number)
    if country == 'ar':
        return '+54%s' % (clean_number)
    if country == 'am':
        return '+374%s' % (clean_number)
    if country == 'aw':
        return '+297%s' % (clean_number)
    if country == 'au':
        return '+61%s' % (clean_number)
    if country == 'at':
        return '+43%s' % (clean_number)
    if country == 'az':
        return '+994%s' % (clean_number)
    if country == 'bh':
        return '+973%s' % (clean_number)
    if country == 'bd':
        return '+880%s' % (clean_number)
    if country == 'by':
        return '+375%s' % (clean_number)
    if country == 'be':
        return '+32%s' % (clean_number)
    if country == 'bz':
        return '+501%s' % (clean_number)
    if country == 'bj':
        return '+229%s' % (clean_number)
    if country == 'bt':
        return '+975%s' % (clean_number)
    if country == 'bo':
        return '+591%s' % (clean_number)
    if country == 'ba':
        return '+387%s' % (clean_number)
    if country == 'bw':
        return '+267%s' % (clean_number)
    if country == 'br':
        return '+55%s' % (clean_number)
    if country == 'bn':
        return '+673%s' % (clean_number)
    if country == 'bg':
        return '+359%s' % (clean_number)
    if country == 'bf':
        return '+226%s' % (clean_number)
    if country == 'mm':
        return '+95%s' % (clean_number)
    if country == 'bi':
        return '+257%s' % (clean_number)
    if country == 'kh':
        return '+855%s' % (clean_number)
    if country == 'cm':
        return '+237%s' % (clean_number)
    if country == 'ca':
        return '+1%s' % (clean_number)
    if country == 'cv':
        return '+238%s' % (clean_number)
    if country == 'cf':
        return '+236%s' % (clean_number)
    if country == 'td':
        return '+235%s' % (clean_number)
    if country == 'cl':
        return '+56%s' % (clean_number)
    if country == 'cn':
        return '+86%s' % (clean_number)
    if country == 'cx':
        return '+61%s' % (clean_number)
    if country == 'cc':
        return '+61%s' % (clean_number)
    if country == 'co':
        return '+57%s' % (clean_number)
    if country == 'km':
        return '+269%s' % (clean_number)
    if country == 'cg':
        return '+242%s' % (clean_number)
    if country == 'cd':
        return '+243%s' % (clean_number)
    if country == 'ck':
        return '+682%s' % (clean_number)
    if country == 'cr':
        return '+506%s' % (clean_number)
    if country == 'hr':
        return '+385%s' % (clean_number)
    if country == 'cu':
        return '+53%s' % (clean_number)
    if country == 'cy':
        return '+357%s' % (clean_number)
    if country == 'cz':
        return '+420%s' % (clean_number)
    if country == 'dk':
        return '+45%s' % (clean_number)
    if country == 'dj':
        return '+253%s' % (clean_number)
    if country == 'tl':
        return '+670%s' % (clean_number)
    if country == 'ec':
        return '+593%s' % (clean_number)
    if country == 'eg':
        return '+20%s' % (clean_number)
    if country == 'sv':
        return '+503%s' % (clean_number)
    if country == 'gq':
        return '+240%s' % (clean_number)
    if country == 'er':
        return '+291%s' % (clean_number)
    if country == 'ee':
        return '+372%s' % (clean_number)
    if country == 'et':
        return '+251%s' % (clean_number)
    if country == 'fk':
        return '+500%s' % (clean_number)
    if country == 'fo':
        return '+298%s' % (clean_number)
    if country == 'fj':
        return '+679%s' % (clean_number)
    if country == 'fi':
        return '+358%s' % (clean_number)
    if country == 'fr':
        return '+33%s' % (dropped_zero)
    if country == 'pf':
        return '+689%s' % (clean_number)
    if country == 'ga':
        return '+241%s' % (clean_number)
    if country == 'gm':
        return '+220%s' % (clean_number)
    if country == 'ge':
        return '+995%s' % (clean_number)
    if country == 'de':
        return '+49%s' % (clean_number)
    if country == 'gh':
        return '+233%s' % (clean_number)
    if country == 'gi':
        return '+350%s' % (clean_number)
    if country == 'gr':
        return '+30%s' % (clean_number)
    if country == 'gl':
        return '+299%s' % (clean_number)
    if country == 'gt':
        return '+502%s' % (clean_number)
    if country == 'gn':
        return '+224%s' % (clean_number)
    if country == 'gw':
        return '+245%s' % (clean_number)
    if country == 'gy':
        return '+592%s' % (clean_number)
    if country == 'ht':
        return '+509%s' % (clean_number)
    if country == 'hn':
        return '+504%s' % (clean_number)
    if country == 'hk':
        return '+852%s' % (clean_number)
    if country == 'hu':
        return '+36%s' % (clean_number)
    if country == 'in':
        return '+91%s' % (clean_number)
    if country == 'id':
        return '+62%s' % (clean_number)
    if country == 'ir':
        return '+98%s' % (clean_number)
    if country == 'iq':
        return '+964%s' % (clean_number)
    if country == 'ie':
        return '+353%s' % (clean_number)
    if country == 'im':
        return '+44%s' % (dropped_zero)
    if country == 'il':
        return '+972%s' % (clean_number)
    if country == 'it':
        return '+39%s' % (clean_number)
    if country == 'ci':
        return '+225%s' % (clean_number)
    if country == 'jp':
        return '+81%s' % (clean_number)
    if country == 'jo':
        return '+962%s' % (clean_number)
    if country == 'kz':
        return '+7%s' % (clean_number)
    if country == 'ke':
        return '+254%s' % (clean_number)
    if country == 'ki':
        return '+686%s' % (clean_number)
    if country == 'kw':
        return '+965%s' % (clean_number)
    if country == 'kg':
        return '+996%s' % (clean_number)
    if country == 'la':
        return '+856%s' % (clean_number)
    if country == 'lv':
        return '+371%s' % (clean_number)
    if country == 'lb':
        return '+961%s' % (clean_number)
    if country == 'ls':
        return '+266%s' % (clean_number)
    if country == 'lr':
        return '+231%s' % (clean_number)
    if country == 'ly':
        return '+218%s' % (clean_number)
    if country == 'li':
        return '+423%s' % (clean_number)
    if country == 'lt':
        return '+370%s' % (clean_number)
    if country == 'lu':
        return '+352%s' % (clean_number)
    if country == 'mo':
        return '+853%s' % (clean_number)
    if country == 'mk':
        return '+389%s' % (clean_number)
    if country == 'mg':
        return '+261%s' % (clean_number)
    if country == 'mw':
        return '+265%s' % (clean_number)
    if country == 'my':
        return '+60%s' % (clean_number)
    if country == 'mv':
        return '+960%s' % (clean_number)
    if country == 'ml':
        return '+223%s' % (clean_number)
    if country == 'mt':
        return '+356%s' % (clean_number)
    if country == 'mh':
        return '+692%s' % (clean_number)
    if country == 'mr':
        return '+222%s' % (clean_number)
    if country == 'mu':
        return '+230%s' % (clean_number)
    if country == 'yt':
        return '+262%s' % (clean_number)
    if country == 'mx':
        return '+52%s' % (clean_number)
    if country == 'fm':
        return '+691%s' % (clean_number)
    if country == 'md':
        return '+373%s' % (clean_number)
    if country == 'mc':
        return '+377%s' % (clean_number)
    if country == 'mn':
        return '+976%s' % (clean_number)
    if country == 'me':
        return '+382%s' % (clean_number)
    if country == 'ma':
        return '+212%s' % (clean_number)
    if country == 'mz':
        return '+258%s' % (clean_number)
    if country == 'na':
        return '+264%s' % (clean_number)
    if country == 'nr':
        return '+674%s' % (clean_number)
    if country == 'np':
        return '+977%s' % (clean_number)
    if country == 'nl':
        return '+31%s' % (clean_number)
    if country == 'an':
        return '+599%s' % (clean_number)
    if country == 'nc':
        return '+687%s' % (clean_number)
    if country == 'nz':
        return '+64%s' % (clean_number)
    if country == 'ni':
        return '+505%s' % (clean_number)
    if country == 'ne':
        return '+227%s' % (clean_number)
    if country == 'ng':
        return '+234%s' % (clean_number)
    if country == 'nu':
        return '+683%s' % (clean_number)
    if country == 'kp':
        return '+850%s' % (clean_number)
    if country == 'no':
        return '+47%s' % (clean_number)
    if country == 'om':
        return '+968%s' % (clean_number)
    if country == 'pk':
        return '+92%s' % (clean_number)
    if country == 'pw':
        return '+680%s' % (clean_number)
    if country == 'pa':
        return '+507%s' % (clean_number)
    if country == 'pg':
        return '+675%s' % (clean_number)
    if country == 'py':
        return '+595%s' % (clean_number)
    if country == 'pe':
        return '+51%s' % (clean_number)
    if country == 'ph':
        return '+63%s' % (clean_number)
    if country == 'pn':
        return '+870%s' % (clean_number)
    if country == 'pl':
        return '+48%s' % (clean_number)
    if country == 'pt':
        return '+351%s' % (clean_number)
    if country == 'pr':
        return '+1%s' % (clean_number)
    if country == 'qa':
        return '+974%s' % (clean_number)
    if country == 'ro':
        return '+40%s' % (clean_number)
    if country == 'ru':
        return '+7%s' % (clean_number)
    if country == 'rw':
        return '+250%s' % (clean_number)
    if country == 'bl':
        return '+590%s' % (clean_number)
    if country == 'ws':
        return '+685%s' % (clean_number)
    if country == 'sm':
        return '+378%s' % (clean_number)
    if country == 'st':
        return '+239%s' % (clean_number)
    if country == 'sa':
        return '+966%s' % (clean_number)
    if country == 'sn':
        return '+221%s' % (clean_number)
    if country == 'rs':
        return '+381%s' % (clean_number)
    if country == 'sc':
        return '+248%s' % (clean_number)
    if country == 'sl':
        return '+232%s' % (clean_number)
    if country == 'sg':
        return '+65%s' % (clean_number)
    if country == 'sk':
        return '+421%s' % (clean_number)
    if country == 'si':
        return '+386%s' % (clean_number)
    if country == 'sb':
        return '+677%s' % (clean_number)
    if country == 'so':
        return '+252%s' % (clean_number)
    if country == 'za':
        return '+27%s' % (clean_number)
    if country == 'kr':
        return '+82%s' % (clean_number)
    if country == 'es':
        return '+34%s' % (clean_number)
    if country == 'lk':
        return '+94%s' % (clean_number)
    if country == 'sh':
        return '+290%s' % (clean_number)
    if country == 'pm':
        return '+508%s' % (clean_number)
    if country == 'sd':
        return '+249%s' % (clean_number)
    if country == 'sr':
        return '+597%s' % (clean_number)
    if country == 'sz':
        return '+268%s' % (clean_number)
    if country == 'se':
        return '+46%s' % (clean_number)
    if country == 'ch':
        return '+41%s' % (clean_number)
    if country == 'sy':
        return '+963%s' % (clean_number)
    if country == 'tw':
        return '+886%s' % (clean_number)
    if country == 'tj':
        return '+992%s' % (clean_number)
    if country == 'tz':
        return '+255%s' % (clean_number)
    if country == 'th':
        return '+66%s' % (clean_number)
    if country == 'tg':
        return '+228%s' % (clean_number)
    if country == 'tk':
        return '+690%s' % (clean_number)
    if country == 'to':
        return '+676%s' % (clean_number)
    if country == 'tn':
        return '+216%s' % (clean_number)
    if country == 'tr':
        return '+90%s' % (clean_number)
    if country == 'tm':
        return '+993%s' % (clean_number)
    if country == 'tv':
        return '+688%s' % (clean_number)
    if country == 'ae':
        return '+971%s' % (clean_number)
    if country == 'ug':
        return '+256%s' % (clean_number)
    if country == 'gb':
        return '+44%s' % (dropped_zero)
    if country == 'ua':
        return '+380%s' % (clean_number)
    if country == 'uy':
        return '+598%s' % (clean_number)
    if country == 'us':
        return '+1%s' % (clean_number)
    if country == 'uz':
        return '+998%s' % (clean_number)
    if country == 'vu':
        return '+678%s' % (clean_number)
    if country == 'va':
        return '+39%s' % (clean_number)
    if country == 've':
        return '+58%s' % (clean_number)
    if country == 'vn':
        return '+84%s' % (clean_number)
    if country == 'wf':
        return '+681%s' % (clean_number)
    if country == 'ye':
        return '+967%s' % (clean_number)
    if country == 'zm':
        return '+260%s' % (clean_number)
    if country == 'zw':
        return '+263%s' % (clean_number)
            
    return clean_number
