#ifndef CONFIG_H
#define CONFIG_H

/*
  This source is part of the FindMine program.
  Copyright (C) 2004  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <string>
#include <vector>

#include <Lum/Images/Image.h>

class Hiscore
{
public:
  class Entry
  {
  public:
    std::wstring name;
    time_t       time;
  };

public:
  size_t             width;
  size_t             height;
  size_t             bombs;
  std::vector<Entry> list;
};

enum Image {
  hiddenImage     = 0,
  bombImage       = 1,
  markedImage     = 2,

  countImage      = 3
};

class Theme
{
public:
  std::wstring          name;
  Lum::Images::ImageRef images[countImage];
  size_t                boxSize;
};

extern std::vector<Theme> themes;
extern std::wstring themeName;

extern void SetUserName(const std::wstring& name);
extern std::wstring GetUserName();
extern void SetCurrentGame(size_t width, size_t height, size_t bombs);
extern void GetCurrentGame(size_t& width, size_t& height, size_t& bombs);
extern void SetOneButtonMode(bool use);
extern bool GetOneButtonMode();

extern bool LoadConfig();
extern bool LoadThemes();

extern bool SaveConfig();

extern void FreeConfig();

extern Hiscore* GetConfig(size_t width, size_t height, size_t bombs);

#endif
