/****************************************************************************
**
** Copyright (C) 2010  Aimone Davide realsportcars@hotmail.com
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

#include "kb_alfanum.h"
#include "ui_kb_alfanum.h"

kb_AlfaNum::kb_AlfaNum(QWidget *parent) :
        Keyboard(parent),
        ui(new Ui::kb_AlfaNum)
{
    ui->setupUi(this);

    m_nkbType = Core::Alfanumeric;

    SettingsMenu *menu = SettingsMenu::instance(this);
    ui->btSettings->setMenu(menu);
    connect(menu,SIGNAL(inputStyleChanged(int)),this,SLOT(settingsChanged(int)));

    m_settingsMenu = qobject_cast<SettingsMenu *> (ui->btSettings->menu());
    m_btShift = ui->btShift;

    //add to button group
    m_bgCharacters->addButton(ui->btOne);
    m_bgCharacters->addButton(ui->btTwo);
    m_bgCharacters->addButton(ui->btThree);
    m_bgCharacters->addButton(ui->btFour);
    m_bgCharacters->addButton(ui->btFive);
    m_bgCharacters->addButton(ui->btSix);
    m_bgCharacters->addButton(ui->btSeven);
    m_bgCharacters->addButton(ui->btEight);
    m_bgCharacters->addButton(ui->btNine);
    //

    connect(ui->btOne,SIGNAL(released()),this, SLOT(inputClicked()));
    connect(ui->btTwo,SIGNAL(released()),this, SLOT(inputClicked()));
    connect(ui->btThree,SIGNAL(released()),this, SLOT(inputClicked()));
    connect(ui->btFour,SIGNAL(released()),this, SLOT(inputClicked()));
    connect(ui->btFive,SIGNAL(released()),this, SLOT(inputClicked()));
    connect(ui->btSix,SIGNAL(released()),this, SLOT(inputClicked()));
    connect(ui->btSeven,SIGNAL(released()),this, SLOT(inputClicked()));
    connect(ui->btEight,SIGNAL(released()),this, SLOT(inputClicked()));
    connect(ui->btNine,SIGNAL(released()),this, SLOT(inputClicked()));
    connect(ui->btZero,SIGNAL(released()),this, SLOT(inputClicked()));
    connect(ui->btNext,SIGNAL(released()),this, SLOT(nextWordClicked()));
    connect(ui->btPrev,SIGNAL(released()),this, SLOT(prevWordClicked()));
    connect(ui->btMoveCurNext,SIGNAL(released()),this, SLOT(moveRightClicked()));
    connect(ui->btMoveCurPrev,SIGNAL(released()),this, SLOT(moveLeftClicked()));
    connect(ui->btDelChar,SIGNAL(released()),this, SLOT(deleteClicked()));
    connect(ui->btShift, SIGNAL(released()), this, SLOT(maiuscClicked()));

    //set icons from file: easy customization
    QString iconsPath = QApplication::applicationDirPath() + "/icons/";
    ui->btMoveCurPrev->setIcon(QIcon(iconsPath + "left.png"));
    ui->btDelChar->setIcon(QIcon(iconsPath + "delete.png"));
    ui->btSettings->setIcon(QIcon(iconsPath + "preferences.png"));
    ui->btMoveCurNext->setIcon(QIcon(iconsPath + "right.png"));
    m_btShift->setGraphicNoCheck(iconsPath + "up.png","");
    m_btShift->setGraphicSingleCheck(iconsPath + "up.png","");
    m_btShift->setGraphicDoubleCheck(iconsPath + "up2.png","");
    //
}

kb_AlfaNum::~kb_AlfaNum()
{
    delete ui;
}

void kb_AlfaNum::inputClicked()
{
    QPushButton *clickedButton = qobject_cast<QPushButton *>(sender());
    QString lastPress = clickedButton->text().at(0);

    charButtonClicked(lastPress,Core::Alfanumeric);
    //emit input(lastPress,Core::Alfanumeric);
}

void kb_AlfaNum::nextWordClicked()
{
    emit input(NEXTWORD,Core::Alfanumeric);
}

void kb_AlfaNum::prevWordClicked()
{
    emit input(PREVWORD,Core::Alfanumeric);
}
void kb_AlfaNum::moveRightClicked()
{
    emit input(MOVERIGHT,Core::Alfanumeric);
}

void kb_AlfaNum::moveLeftClicked()
{
    emit input(MOVELEFT,Core::Alfanumeric);
}

void kb_AlfaNum::deleteClicked()
{
    emit input(DELETE,Core::Alfanumeric);
}

