/****************************************************************************
**
** Copyright (C) 2010  Aimone Davide realsportcars@hotmail.com
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

#ifndef CORE_H
#define CORE_H

#include <QObject>

class Core : public QObject
{
    Q_OBJECT
public:

    //Const used in application
    explicit Core(QObject *parent = 0);
    static const QString ORIENTATION_LANDSCAPE;
    static const QString ORIENTATION_PORTRAIT;
    static const QString ORIENTATION_AUTO;

    static const QString SETTING_ORG;
    static const QString SETTING_APPNAME;
    static const QString SETTING_LANGUAGE;
    static const QString SETTING_ORIENTATION;
    static const QString SETTING_PHONEBOOK;
    static const QString SETTING_FONTSIZE;
    static const QString SETTING_CURRENT_KEYBOARD;
    static const QString SETTING_QWERTY_LAYOUT;
    static const QString SETTING_LABEL_COLOR;
    //static const QString SETTING_VIBRATION;

    static const QString PREF_LANDSCAPE_KB;
    static const QString PREF_PORTRAIT_KB;

    enum QwertyLayout{latinLayout,khmerLayout,russianLayout,greekLayout,noneLayout};
    enum LabelColor{themeDefault,black,white,grey,purple,pink,red,yellow,green,aqua,blue,orange};
    //enum vibrationFeedback{defaultVibration,forceVibration,forceNoVibration};

    static const QString LBL_FASTWRITE_ON;
    static const QString LBL_FASTWRITE_OFF;
    static const QString LBL_AUTOCAPITALIZATION;
    static const QString LBL_UPPERCASE;
    static const QString LBL_LOWERCASE;
    static const QString LBL_DIGIT;
    static const QString LBL_QWERTY;
    static const QString LBL_ALFANUM;

    static const int FONTSIZE_DEFAULT;
    static const int FONTSIZE_BIG;
    static const int FONTSIZE_BIGGER;

    enum Keyboards{Qwerty, Alfanumeric};
};

#endif // CORE_H
