/*
    Copyright 2010 Marcello V. Mansueto <marcello.m@yahoo.com>

    This file is part of dlh.

    dlh is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    dlh is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with dlh.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <QHeaderView>
#include "tableview.h"

TableView::TableView(QWidget *parent) : QTableView(parent) {
}

void TableView::init(QSqlTableModel *model) {
    setModel(model);
    setEditTriggers(NoEditTriggers);
    setSelectionMode(QAbstractItemView::NoSelection);
    resizeColumnsToContents();
    setColumnWidth(8, 500);
    scrollToBottom();
}
