/*
    Copyright 2010 Marcello V. Mansueto <marcello.m@yahoo.com>

    This file is part of dlh.

    dlh is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    dlh is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with dlh.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef DLH_PLUGIN_H
#define DLH_PLUGIN_H

#include <glib-object.h>

#include <libhildondesktop/libhildondesktop.h>

G_BEGIN_DECLS

typedef struct _DlhPlugin DlhPlugin;
typedef struct _DlhPluginClass DlhPluginClass;

#define DLH_TYPE_HOME_PLUGIN   (DLH_home_plugin_get_type ())

#define DLH_HOME_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                        DLH_TYPE_HOME_PLUGIN, DlhHomePlugin))

#define DLH_HOME_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), \
                        DLH_TYPE_HOME_PLUGIN,  DlhHomePluginClass))

#define DLH_IS_HOME_PLUGIN(obj)  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                        DLH_TYPE_HOME_PLUGIN))
 
#define DLH_IS_HOME_PLUGIN_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), \
                        DLH_TYPE_HOME_PLUGIN))

#define DLH_HOME_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                        DLH_TYPE_HOME_PLUGIN,  DlhHomePluginClass))
 
struct _DlhPlugin
{
    HDHomePluginItem hitem;
};
 
struct _DlhPluginClass
{
    HDHomePluginItemClass parent_class;
};
 
GType DLH_home_plugin_get_type(void);

G_END_DECLS

#endif

