/*
* Copyright (c) 2011 Mladen Milankovic <mmlado at gmail.com>.
*
* This file is part of Demine application
*
* Demine is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Demine is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.

* You should have received a copy of the GNU General Public License
* along with Demine.  If not, see <http://www.gnu.org/licenses/>.
*/

import QtQuick 1.0

import "core"

Rectangle {
    id: main
    width: 800
    height: 480
    color: 'green'

    /*PinchArea {
        //width: table.width
        //height: table.height
        anchors.fill: parent
        pinch.target: table
        //enabled: true
        pinch.minimumScale: 1
        pinch.maximumScale: 2
        //pinch.dragAxis: Pinch.XandYAxis

        /*onPinchStarted: {
            //console.debug(table.height*table.scale);
            //console.debug(pinch.scale);
            if (pinch.scale > 2) {
                pinch.scale = 2
            }
            if (pinch.scale < 1) {
                pinch.scale = 1
            }
            flickable.contentHeight = table.height*pinch.scale;
            flickable.contentWidth = table.width*pinch.scale;
        }*/

        /*onPinchUpdated: {
            //console.debug(table.height*table.scale);
            console.debug(pinch.scale);
            if (flickable.contentWidth * pinch.scale < main.width) return;
            if (flickable.contentWidth * pinch.scale > main.width*2) return;
            flickable.contentHeight = main.width*pinch.scale;
            flickable.contentWidth = main.width*pinch.scale;
        }

        onPinchFinished: {
            //main.contentX = table.x
            //main.contentY = table.y
            console.debug(table.height * table.scale);
            console.debug(table.width * table.scale);

            flickable.contentHeight = table.height * table.scale;
            flickable.contentWidth = table.width * table.scale;
        }
    }*/
    Flickable {
        id:  flickable
        width: parent.width
        height: parent.height
        anchors.fill: parent
        contentWidth: main.width * 1
        contentHeight: main.width * 1
        Table {
            id: table
            width: parent.width
            height: parent.height
            onLost: main.lost()
            onWon: main.won()
            columns: 10
            rows: 10
        }
    }
    Dialog {
        id: dialog
        onClosed: table.newGame();
    }
    function lost() {
        dialog.show('Game over.');
    }

    function won() {
        dialog.show('You won!');
    }
}
