#ifndef THUMBNAILLABEL_H
#define THUMBNAILLABEL_H

#include <QWidget>
#include <QMouseEvent>
#include <QPaintEvent>

class QImage;

class ThumbnailLabel : public QWidget
{
    Q_OBJECT

public:
    explicit ThumbnailLabel(QWidget *parent = 0);
    explicit ThumbnailLabel(int duration, QWidget *parent = 0);
    inline bool interactive() const { return m_interactive; }
    inline void setInteractive(bool interactive) { m_interactive = interactive; }
    inline QImage image() const { return m_image; }
    void setImage(const QImage &image);
    inline int duration() const { return m_duration; }
    void setDuration(int duration);

protected:
    void mousePressEvent(QMouseEvent *event);
    void mouseReleaseEvent(QMouseEvent *event);
    void leaveEvent(QEvent *event);
    void paintEvent(QPaintEvent *event);

signals:
    void clicked();

private:
    QImage m_image;
    int m_duration;
    bool m_interactive;
    bool m_pressed;
};

#endif // THUMBNAILLABEL_H
