#ifndef DAILYMOTIONVIDEOCOMMENTSTAB_H
#define DAILYMOTIONVIDEOCOMMENTSTAB_H

#include "abstracttab.h"
#include "../base/videoitem.h"

class DailymotionCommentListModel;
class ListView;
class QAction;
class QLabel;
class QGridLayout;
class QModelIndex;

class DailymotionVideoCommentsTab : public AbstractTab
{
    Q_OBJECT

public:
    explicit DailymotionVideoCommentsTab(QSharedPointer<VideoItem> video, QWidget *parent);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);
    void showCommentDialog();
    void showUserChannel(const QModelIndex &index);

private:
    QSharedPointer<VideoItem> m_video;
    DailymotionCommentListModel *m_model;
    ListView *m_listView;
    QAction *m_commentAction;
    QLabel *m_noResultsLabel;
    QGridLayout *m_grid;
};

#endif // DAILYMOTIONVIDEOCOMMENTSTAB_H
