#include "dailymotionplaylistdialog.h"
#include "dailymotionplaylistdelegate.h"
#include "dailymotionnewplaylistdialog.h"
#include "../base/dailymotionuserplaylistlistmodel.h"
#include "../base/dailymotion.h"
#include "listview.h"
#include <QDialogButtonBox>
#include <QPushButton>
#include <QLabel>
#include <QGridLayout>

DailymotionPlaylistDialog::DailymotionPlaylistDialog(QWidget *parent) :
    AbstractDialog(parent),
    m_model(new DailymotionUserPlaylistListModel(this)),
    m_listView(new ListView(this)),
    m_buttonBox(new QDialogButtonBox(Qt::Vertical, this)),
    m_newButton(m_buttonBox->addButton(tr("New playlist"), QDialogButtonBox::ActionRole)),
    m_noResultsLabel(new QLabel(tr("No playlists found"), this)),
    m_grid(new QGridLayout(this))
{
    this->setWindowTitle(tr("Add to playlist"));
    this->toggleBusy(true);

    m_listView->setItemDelegate(new DailymotionPlaylistDelegate(m_listView));

    QFont font;
    font.setPixelSize(40);
    font.setBold(true);
    m_noResultsLabel->setFont(font);
    m_noResultsLabel->setAlignment(Qt::AlignCenter);
    m_noResultsLabel->hide();

    this->connect(m_newButton, SIGNAL(clicked()), this, SLOT(showNewPlaylistDialog()));
    this->connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));

    if (Dailymotion::instance()->playlistsLoaded()) {
        this->onPlaylistsLoaded();
    }
    else {
        this->connect(Dailymotion::instance(), SIGNAL(allPlaylistsLoaded()), this, SLOT(onPlaylistsLoaded()));
    }

    this->onOrientationChanged();
}

void DailymotionPlaylistDialog::setLandscapeLayout() {
    this->setFixedHeight(340);
    m_noResultsLabel->setFixedSize(800, 340);
    m_buttonBox->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_listView, 0, 0);
        m_grid->addWidget(m_buttonBox, 0, 1, Qt::AlignBottom);
    }
    else {
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 0, 1, Qt::AlignBottom);
    }
}

void DailymotionPlaylistDialog::setPortraitLayout() {
    this->setFixedHeight(600);
    m_noResultsLabel->setFixedSize(480, 600);
    m_buttonBox->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_listView, 0, 0);
        m_grid->addWidget(m_buttonBox, 1, 0, Qt::AlignBottom);
    }
    else {
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 1, 0, Qt::AlignBottom);
    }
}

void DailymotionPlaylistDialog::onPlaylistsLoaded() {
    this->toggleBusy(false);
    m_noResultsLabel->setVisible(m_model->rowCount() == 0);
    m_listView->setModel(m_model);
}

void DailymotionPlaylistDialog::onItemClicked(const QModelIndex &index) {
    if (index.isValid()) {
        emit playlistChosen(index.data(DailymotionUserPlaylistListModel::PlaylistIdRole).toString());
        this->accept();
    }
}

void DailymotionPlaylistDialog::showNewPlaylistDialog() {
    DailymotionNewPlaylistDialog *dialog = new DailymotionNewPlaylistDialog(this);
    dialog->open();
    this->connect(dialog, SIGNAL(playlistCreated(QVariantMap)), this, SIGNAL(addToNewPlaylist(QVariantMap)));
    this->connect(dialog, SIGNAL(accepted()), this, SLOT(accept()));
}
