#include "accountdelegate.h"
#include "../base/youtubeaccountslistmodel.h"
#include <QPainter>

AccountDelegate::AccountDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
}

void AccountDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    bool active = index.data(YouTubeAccountsListModel::ActiveRole).toBool();

    if ((option.state) & (QStyle::State_Selected)) {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundPressed.png"));
    }
    else {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundNormal.png"));
    }

    if (active) {
        QRect checkRect = option.rect;
        checkRect.moveLeft(checkRect.right() - 53);
        checkRect.moveTop(checkRect.top() + 16);
        checkRect.setSize(QSize(48, 48));
        painter->drawImage(checkRect, QImage("/usr/share/icons/hicolor/48x48/hildon/widgets_tickmark_grid.png"));
    }

    painter->drawText(option.rect, Qt::AlignCenter, index.data().toString());
}

QSize AccountDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(index)

    return QSize(option.rect.width(), 80);
}
