#ifndef PLAYBACKLISTMODEL_H
#define PLAYBACKLISTMODEL_H

#include "abstractvideolistmodel.h"

class PlaybackListModel : public AbstractVideoListModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)
    Q_PROPERTY(bool itemsSelected
               READ itemsSelected
               NOTIFY itemsSelectedChanged)

public:
    explicit PlaybackListModel(QObject *parent = 0);
    void insertVideo(int row, QSharedPointer<VideoItem> video);
    void addVideo(QSharedPointer<VideoItem> video);
    void addVideos(QList< QSharedPointer<VideoItem> > videos);
#ifdef QML_USER_INTERFACE
    Q_INVOKABLE void addVideoFromQML(VideoItem *video);
    Q_INVOKABLE void insertVideoFromQML(int row, VideoItem *video);
    Q_INVOKABLE void addVideosFromQML(QList<VideoItem*> videos);
#endif
    static PlaybackListModel* playbackQueue();

public slots:
    void removeVideo(int row);
    void removeSelectedVideos();
    void downloadSelectedVideos(bool saveAsAudio = false);
    inline void toggleSelected(int row) { AbstractVideoListModel::toggleSelected(row); emit itemsSelectedChanged(this->itemsSelected()); }
    inline void selectAll() { AbstractVideoListModel::selectAll(); emit itemsSelectedChanged(true); }
    inline void selectNone() { AbstractVideoListModel::selectNone(); emit itemsSelectedChanged(false); }

signals:
    void alert(const QString &message);
    void countChanged(int count);
    void itemsSelectedChanged(bool selected);
};

#endif // PLAYBACKLISTMODEL_H
