#include "dailymotionuserplaylistlistmodel.h"
#include "dailymotion.h"

DailymotionUserPlaylistListModel::DailymotionUserPlaylistListModel(QObject *parent) :
    QAbstractListModel(parent)
{
    m_roleNames[IdRole] = "id";
    m_roleNames[PlaylistIdRole] = "playlistId";
    m_roleNames[TitleRole] = "title";
    m_roleNames[ArtistRole] = "artist";
    m_roleNames[DateRole] = "date";
    m_roleNames[VideoCountRole] = "videoCount";
    m_roleNames[DescriptionRole] = "description";
#if QT_VERSION < 0x050000
    this->setRoleNames(m_roleNames);
#endif

    if (!Dailymotion::instance()->playlistsLoaded()) {
        Dailymotion::instance()->getPlaylists();
    }

    this->connect(Dailymotion::instance(), SIGNAL(playlistAddedToCache(int)), this, SLOT(onPlaylistAdded(int)));
    this->connect(Dailymotion::instance(), SIGNAL(playlistRemovedFromCache(int)), this, SLOT(onPlaylistRemoved(int)));
    this->connect(Dailymotion::instance(), SIGNAL(playlistUpdated(int)), this, SLOT(onPlaylistUpdated(int)));
}

#if QT_VERSION >= 0x050000
QHash<int, QByteArray> DailymotionUserPlaylistListModel::roleNames() const {
    return m_roleNames;
}
#endif

void DailymotionUserPlaylistListModel::onPlaylistAdded(int row) {
    this->beginInsertRows(QModelIndex(), row, row);
    this->endInsertRows();
    emit countChanged(this->rowCount());
}

void DailymotionUserPlaylistListModel::onPlaylistRemoved(int row) {
    this->beginRemoveRows(QModelIndex(), row, row);
    this->endRemoveRows();
    emit countChanged(this->rowCount());
}

void DailymotionUserPlaylistListModel::onPlaylistUpdated(int row) {
    emit dataChanged(this->index(row), this->index(row));
}

int DailymotionUserPlaylistListModel::rowCount(const QModelIndex &parent) const {
    Q_UNUSED(parent)

    return Dailymotion::instance()->playlists()->size();
}

QVariant DailymotionUserPlaylistListModel::data(const QModelIndex &index, int role) const {
    switch (role) {
    case IdRole:
        return Dailymotion::instance()->playlists()->at(index.row()).data()->id();
    case PlaylistIdRole:
        return Dailymotion::instance()->playlists()->at(index.row()).data()->playlistId();
    case TitleRole:
        return Dailymotion::instance()->playlists()->at(index.row()).data()->title();
    case ArtistRole:
        return Dailymotion::instance()->playlists()->at(index.row()).data()->artist();
    case DateRole:
        return Dailymotion::instance()->playlists()->at(index.row()).data()->date();
    case VideoCountRole:
        return Dailymotion::instance()->playlists()->at(index.row()).data()->videoCount();
    case DescriptionRole:
        return Dailymotion::instance()->playlists()->at(index.row()).data()->description();
    default:
        return QVariant();
    }
}

QVariant DailymotionUserPlaylistListModel::data(int row, const QByteArray &role) const {
    return this->data(this->index(row), this->roleNames().key(role));
}

QSharedPointer<PlaylistItem> DailymotionUserPlaylistListModel::get(int row) const {
    return QSharedPointer<PlaylistItem>(Dailymotion::instance()->playlists()->at(row));
}

#ifdef QML_USER_INTERFACE
PlaylistItem* DailymotionUserPlaylistListModel::getFromQML(int row) const {
    return Dailymotion::instance()->playlists()->at(row).data();
}
#endif
