#include "dailymotion.h"
#include "../../cutetubeapp/src/base/json.h"
#include "../../cutetubeapp/src/base/utils.h"
#include <QNetworkRequest>
#include <QNetworkReply>
#include <QDebug>

using namespace QtJson;

Dailymotion::Dailymotion(QObject *parent) :
    QObject(parent), m_nam(0),
    m_clientId("808ed79fa59e10f3952e"),
    m_clientSecret("5753a7aa0fb0772b628d160aabe3da6059f97375")
{
}

Dailymotion::~Dailymotion() {}


QNetworkReply* Dailymotion::createReply(QString feed, int offset) {
    QUrl url(feed);

    if (userSignedIn()) {
        url.addQueryItem("access_token", this->accessToken());
    }

    if (offset) {
        url.addQueryItem("page", QString::number(offset));
    }

    url.addQueryItem("family_filter", "false");

    qDebug() << url;

    QNetworkRequest request(url);
    request.setRawHeader("User-Agent", QString("cuteTube/%1 (Qt)").arg(Utils::versionNumberString()).toUtf8());

    return this->networkAccessManager()->get(request);
}

void Dailymotion::setAccount(const QString &user, const QString &token, const QString &refresh) {
    if (user != this->username()) {
        this->setUsername(user);
    }

    this->setAccessToken(token);
    this->setRefreshToken(refresh);

    if ((user.isEmpty()) && (!token.isEmpty())) {
        emit newAccountSet();
    }
}

void Dailymotion::refreshAccessToken() {
    QUrl url("https://api.dailymotion.com/oauth/token");

    QByteArray body("client_id=" + m_clientId.toUtf8() +
                    "&client_secret=" + m_clientSecret.toUtf8() +
                    "&refresh_token=" + this->refreshToken().toUtf8() +
                    "&grant_type=refresh_token");

    QNetworkRequest request(url);
    request.setRawHeader("User-Agent", QString("cuteTube/%1 (Qt)").arg(Utils::versionNumberString()).toUtf8());
    request.setHeader(QNetworkRequest::ContentTypeHeader, "application/x-www-form-urlencoded");
    QNetworkReply *reply = this->networkAccessManager()->post(request, body);
    this->connect(reply, SIGNAL(finished()), this, SLOT(checkTokenRefresh()));
}

void Dailymotion::checkTokenRefresh() {
    QNetworkReply* reply = qobject_cast<QNetworkReply*>(this->sender());

    if (!reply) {
        emit refreshError();
        return;
    }

    QString response(reply->readAll());
    bool ok;
    QVariantMap result = Json::parse(response, ok).toMap();

    if (!ok) {
        emit refreshError();
    }
    else {
        QString token = result.value("access_token").toString();
        QString refresh = result.value("refresh_token").toString();

        if (token.isEmpty()) {
            emit refreshError();
        }
        else {
            this->setAccessToken(token);
            this->setRefreshToken(refresh);
            emit accessTokenRefreshed(token, refresh);
        }
    }
}
