#ifndef YOUTUBEPLAYLISTLISTWINDOW_H
#define YOUTUBEPLAYLISTLISTWINDOW_H

#include "stackedwindow.h"
#include "../base/playlistitem.h"
#include "../base/enums.h"

class YouTubePlaylistListModel;
class ListView;
class QLabel;
class QModelIndex;

class YouTubePlaylistListWindow : public StackedWindow
{
    Q_OBJECT
public:
    explicit YouTubePlaylistListWindow(QWidget *parent);
    void setPlaylistFeed(const QUrl &feed);
    void search(const QString &query, Queries::QueryOrder order);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);
    void onItemClicked(const QModelIndex &index);
    void showPlaylist(QSharedPointer<PlaylistItem> playlist);

private:
    ListView *m_listView;
    YouTubePlaylistListModel *m_model;
    QLabel *m_noResultsLabel;
};

#endif // YOUTUBEPLAYLISTLISTWINDOW_H
