#include "videoplaybackwindow.h"
#include "../base/settings.h"
#include "../base/screensaver.h"
#include <QVBoxLayout>

VideoPlaybackWindow::VideoPlaybackWindow(QList< QSharedPointer<VideoItem> > playlist, QWidget *parent) :
    StackedWindow(parent),
    m_oldOrientation(Settings::instance()->screenOrientation()),
    m_videoWidget(new VideoWidget(this)),
    m_player(new QMediaPlayer(this)),
    m_controls(new VideoControls(m_player, playlist, this))
{
    this->setWindowState(Qt::WindowFullScreen);
    this->setWindowTitle(tr("Now playing"));
    this->setCentralWidget(new QWidget(this));

    QVBoxLayout *vbox = new QVBoxLayout(this->centralWidget());
    vbox->setContentsMargins(0, 0, 0, 0);
    vbox->setSpacing(0);
    vbox->addWidget(m_videoWidget);
    vbox->addWidget(m_controls);

    Settings::instance()->setScreenOrientation(ScreenOrientation::LockLandscape);
    ScreenSaver::preventBlanking(this->winId(), true);

    m_player->setVideoOutput(m_videoWidget);
    m_player->setVolume(100);

    m_controls->hide();

    this->connect(m_videoWidget, SIGNAL(clicked()), this, SLOT(toggleControls()));
    this->connect(m_controls, SIGNAL(back()), this, SLOT(close()));
    this->connect(m_player, SIGNAL(stateChanged(QMediaPlayer::State)), this, SLOT(onStateChanged(QMediaPlayer::State)));
}

VideoPlaybackWindow::~VideoPlaybackWindow() {
    m_player->stop();
    Settings::instance()->setScreenOrientation(m_oldOrientation);
    ScreenSaver::preventBlanking(this->winId(), false);
}

void VideoPlaybackWindow::toggleControls() {
    m_controls->setVisible(!m_controls->isVisible());
}

bool VideoPlaybackWindow::event(QEvent *e) {
    switch (e->type()) {
    case QEvent::WindowActivate:
        ScreenSaver::preventBlanking(this->winId(), m_player->state() == QMediaPlayer::PlayingState);
        break;
    case QEvent::WindowDeactivate:
        ScreenSaver::preventBlanking(this->winId(), false);
        break;
    default:
        break;
    }

    return StackedWindow::event(e);
}

void VideoPlaybackWindow::keyPressEvent(QKeyEvent *event) {
    switch (event->key()) {
    case Qt::Key_F:
        this->toggleControls();
        return;
    case Qt::Key_Backspace:
        this->close();
        return;
    default:
        m_controls->keyPressEvent(event);
        return;
    }
}

void VideoPlaybackWindow::onStateChanged(QMediaPlayer::State state) {
    switch (state) {
    case QMediaPlayer::PlayingState:
        ScreenSaver::preventBlanking(this->winId(), this->isActiveWindow());
        return;
    default:
        ScreenSaver::preventBlanking(this->winId(), false);
        return;
    }
}
