#ifndef DAILYMOTIONUSERPLAYLISTLISTTAB_H
#define DAILYMOTIONUSERPLAYLISTLISTTAB_H

#include "abstracttab.h"
#include "../base/playlistitem.h"

class ListView;
class DailymotionUserPlaylistListModel;
class QLabel;
class QMenu;
class QAction;
class QGridLayout;
class QModelIndex;

class DailymotionUserPlaylistListTab : public AbstractTab
{
    Q_OBJECT
public:
    explicit DailymotionUserPlaylistListTab(QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onPlaylistsLoaded();
    void onCountChanged(int count);
    void onItemClicked(const QModelIndex &index);
    void showPlaylist(QSharedPointer<PlaylistItem> playlist);
    void showContextMenu(const QPoint &pos);
    void deletePlaylist();
    void showNewPlaylistDialog();

private:
    ListView *m_listView;
    DailymotionUserPlaylistListModel *m_model;
    QMenu *m_contextMenu;
    QAction *m_deleteAction;
    QAction *m_newPlaylistAction;
    QLabel *m_noResultsLabel;
    QGridLayout *m_grid;
};

#endif // DAILYMOTIONUSERPLAYLISTLISTTAB_H
