#ifndef AVATARLABEL_H
#define AVATARLABEL_H

#include <QWidget>
#include <QMouseEvent>
#include <QPaintEvent>

class QImage;

class AvatarLabel : public QWidget
{
    Q_OBJECT

public:
    explicit AvatarLabel(QWidget *parent = 0);
    inline bool interactive() const { return m_interactive; }
    inline void setInteractive(bool interactive) { m_interactive = interactive; }
    inline QString name() const { return m_name; }
    void setName(const QString &name);
    inline QImage image() const { return m_image; }
    void setImage(const QImage &image);

protected:
    void mousePressEvent(QMouseEvent *event);
    void mouseReleaseEvent(QMouseEvent *event);
    void leaveEvent(QEvent *event);
    void paintEvent(QPaintEvent *event);

signals:
    void clicked();

private:
    QString m_name;
    QImage m_image;
    bool m_interactive;
    bool m_pressed;
};

#endif // AVATARLABEL_H
