#include "youtubecategorymodel.h"
#include "feedurls.h"

YouTubeCategoryModel::YouTubeCategoryModel(QObject *parent) :
    SelectionModel(parent)
{
    m_time_filters[Queries::AllTime] = "all_time";
    m_time_filters[Queries::ThisWeek] = "this_week";
    m_time_filters[Queries::ThisMonth] = "this_month";

    this->addItem(tr("Cars & Vehicles"), this->feedFromValues("Autos"));
    this->addItem(tr("Comedy"), this->feedFromValues("Comedy"));
    this->addItem(tr("Education"), this->feedFromValues("Education"));
    this->addItem(tr("Entertainment"), this->feedFromValues("Entertainment"));
    this->addItem(tr("Film"), this->feedFromValues("Film"));
    this->addItem(tr("Gaming"), this->feedFromValues("Games"));
    this->addItem(tr("Most Discussed"), this->feedFromValues("most_discussed", true, Queries::AllTime));
    this->addItem(tr("Most Discussed (Today)"), this->feedFromValues("most_discussed", true, Queries::Today));
    this->addItem(tr("Most Discussed (This Week)"), this->feedFromValues("most_discussed", true, Queries::ThisWeek));
    this->addItem(tr("Most Discussed (This Month)"), this->feedFromValues("most_discussed", true, Queries::ThisMonth));
    this->addItem(tr("Most Popular"), this->feedFromValues("most_viewed", true, Queries::AllTime));
    this->addItem(tr("Most Popular (Today)"), this->feedFromValues("most_popular", true, Queries::Today));
    this->addItem(tr("Most Popular (This Week)"), this->feedFromValues("most_popular", true, Queries::ThisWeek));
    this->addItem(tr("Most Popular (This Month)"), this->feedFromValues("most_popular", true, Queries::ThisMonth));
    this->addItem(tr("Most Recent"), this->feedFromValues("most_recent", true));
    this->addItem(tr("Most Responded"), this->feedFromValues("most_responded", true, Queries::AllTime));
    this->addItem(tr("Most Responded (Today)"), this->feedFromValues("most_responded", true, Queries::Today));
    this->addItem(tr("Most Responded (This Week)"), this->feedFromValues("most_responded", true, Queries::ThisWeek));
    this->addItem(tr("Most Responded (This Month)"), this->feedFromValues("most_responded", true, Queries::ThisMonth));
    this->addItem(tr("Most Shared"), this->feedFromValues("most_shared", true));
    this->addItem(tr("Music"), this->feedFromValues("Music"));
    this->addItem(tr("News & Politics"), this->feedFromValues("News"));
    this->addItem(tr("Non-profits & Activism"), this->feedFromValues("Nonprofit"));
    this->addItem(tr("People"), this->feedFromValues("People"));
    this->addItem(tr("Pets & Animals"), this->feedFromValues("Animals"));
    this->addItem(tr("Recently Featured"), this->feedFromValues("recently_featured", true));
    this->addItem(tr("Science & Technology"), this->feedFromValues("Tech"));
    this->addItem(tr("Sport"), this->feedFromValues("Sports"));
    this->addItem(tr("Style"), this->feedFromValues("Howto"));
    this->addItem(tr("Top Favourites"), this->feedFromValues("top_favorites", true, Queries::AllTime));
    this->addItem(tr("Top Favourites (Today)"), this->feedFromValues("top_favorites", true, Queries::Today));
    this->addItem(tr("Top Favourites (This Week)"), this->feedFromValues("top_favorites", true, Queries::ThisWeek));
    this->addItem(tr("Top Favourites (This Month)"), this->feedFromValues("top_favorites", true, Queries::ThisMonth));
    this->addItem(tr("Top Rated"), this->feedFromValues("top_rated", true, Queries::AllTime));
    this->addItem(tr("Top Rated (Today)"), this->feedFromValues("top_rated", true, Queries::Today));
    this->addItem(tr("Top Rated (This Week)"), this->feedFromValues("top_rated", true, Queries::ThisWeek));
    this->addItem(tr("Top Rated (This Month)"), this->feedFromValues("top_rated", true, Queries::ThisMonth));
    this->addItem(tr("Travel & Events"), this->feedFromValues("Travel"));
    this->addItem(tr("Trending Videos"), this->feedFromValues("on_the_web", true));
    emit countChanged(this->rowCount());
}

QString YouTubeCategoryModel::feedFromValues(const QString &value, bool standard, Queries::TimeFilter time) {
    QString feed;

    if (standard) {
        feed = YOUTUBE_STANDARD_FEEDS_BASE_URL + QString("%1?v=2.1&max-results=30").arg(value);

        if (time != Queries::None) {
            feed.append(QString("&time=%1").arg(m_time_filters.value(time, "all_time")));
        }
    }
    else {
        feed = YOUTUBE_VIDEOS_BASE_URL + QString("?v=2.1&max-results=30&orderby=published&category=%1").arg(value);
    }

    return feed;
}
