#include "dailymotionsubscriptionlistmodel.h"
#include "dailymotion.h"
#ifndef QML_USER_INTERFACE
#include "thumbnailcache.h"
#endif

DailymotionSubscriptionListModel::DailymotionSubscriptionListModel(QObject *parent) :
    QAbstractListModel(parent)
  #ifndef QML_USER_INTERFACE
    ,m_cache(new ThumbnailCache)
  #endif
{
    QHash<int, QByteArray> roles;
    roles[IdRole] = "id";
    roles[SubscriptionIdRole] = "subscriptionId";
    roles[UsernameRole] = "username";
    roles[ChannelNameRole] = "channelName";
#ifndef QML_USER_INTERFACE
    roles[AvatarRole] = "avatar";
#endif
    roles[AvatarUrlRole] = "avatarUrl";
    roles[VideoCountRole] = "videoCount";
    roles[DescriptionRole] = "description";
    roles[ViewCountRole] = "viewCount";
    roles[SubscriberCountRole] = "subscriberCount";
    roles[SubscriptionRole] = "subscription";
    this->setRoleNames(roles);
#ifndef QML_USER_INTERFACE
    this->connect(m_cache, SIGNAL(thumbnailReady()), this, SLOT(onThumbnailReady()));
#endif
    if (!Dailymotion::instance()->subscriptionsLoaded()) {
        Dailymotion::instance()->getSubscriptions();
    }

    this->connect(Dailymotion::instance(), SIGNAL(subscriptionAddedToCache(int)), this, SLOT(onSubscriptionAdded(int)));
    this->connect(Dailymotion::instance(), SIGNAL(subscriptionRemovedFromCache(int)), this, SLOT(onSubscriptionRemoved(int)));
}

DailymotionSubscriptionListModel::~DailymotionSubscriptionListModel() {
#ifndef QML_USER_INTERFACE
    delete m_cache;
    m_cache = 0;
#endif
}

void DailymotionSubscriptionListModel::onSubscriptionAdded(int row) {
    this->beginInsertRows(QModelIndex(), row, row);
    this->endInsertRows();
    emit countChanged(this->rowCount());
}

void DailymotionSubscriptionListModel::onSubscriptionRemoved(int row) {
    this->beginRemoveRows(QModelIndex(), row, row);
    this->endRemoveRows();
    emit countChanged(this->rowCount());
}

int DailymotionSubscriptionListModel::rowCount(const QModelIndex &parent) const {
    Q_UNUSED(parent)

    return Dailymotion::instance()->subscriptions()->size();
}

QVariant DailymotionSubscriptionListModel::data(const QModelIndex &index, int role) const {
    switch (role) {
    case IdRole:
        return Dailymotion::instance()->subscriptions()->at(index.row()).data()->id();
    case SubscriptionIdRole:
        return Dailymotion::instance()->subscriptions()->at(index.row()).data()->subscriptionId();
    case UsernameRole:
        return Dailymotion::instance()->subscriptions()->at(index.row()).data()->username();
    case ChannelNameRole:
        return Dailymotion::instance()->subscriptions()->at(index.row()).data()->channelName();
#ifndef QML_USER_INTERFACE
    case AvatarRole:
        return m_cache->thumbnail(Dailymotion::instance()->subscriptions()->at(index.row()).data()->avatarUrl(), QSize(60, 60));
#endif
    case AvatarUrlRole:
        return Dailymotion::instance()->subscriptions()->at(index.row()).data()->avatarUrl();
    case VideoCountRole:
        return Dailymotion::instance()->subscriptions()->at(index.row()).data()->videoCount();
    case DescriptionRole:
        return Dailymotion::instance()->subscriptions()->at(index.row()).data()->description();
    case ViewCountRole:
        return Dailymotion::instance()->subscriptions()->at(index.row()).data()->viewCount();
    case SubscriberCountRole:
        return Dailymotion::instance()->subscriptions()->at(index.row()).data()->subscriberCount();
    case SubscriptionRole:
        return Dailymotion::instance()->subscriptions()->at(index.row()).data()->subscription();
    default:
        return QVariant();
    }
}

QVariant DailymotionSubscriptionListModel::data(int row, const QByteArray &role) const {
    return this->data(this->index(row), this->roleNames().key(role));
}

QSharedPointer<UserItem> DailymotionSubscriptionListModel::get(int row) const {
    return QSharedPointer<UserItem>(Dailymotion::instance()->subscriptions()->at(row));
}

#ifdef QML_USER_INTERFACE
UserItem* DailymotionSubscriptionListModel::getFromQML(int row) const {
    return Dailymotion::instance()->subscriptions()->at(row).data();
}
#endif

#ifndef QML_USER_INTERFACE
void DailymotionSubscriptionListModel::onThumbnailReady() {
    emit dataChanged(this->index(0), this->index(this->rowCount() - 1));
}
#endif
